//+------------------------------------------------------------------+
//|                                             SignalML_MACD_OBV.mqh |
//|                             Copyright 2000-2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>

#resource "Python/72_2.onnx" as uchar __72_2[]
#resource "Python/72_3.onnx" as uchar __72_3[]
#resource "Python/72_5.onnx" as uchar __72_5[]
#define __PATTERNS 3
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals of ML with MACD and OBV                             |
//| Type=SignalAdvanced                                              |
//| Name=MACD and OBV                                                 |
//| ShortName=ML_MACD_OBV                                             |
//| Class=CSignalML_MACD_OBV                                          |
//| Page=signal_sar_rvi                                              |
//| Parameter=Pattern_2,int,50,Pattern 2                             |
//| Parameter=Pattern_3,int,50,Pattern 3                             |
//| Parameter=Pattern_5,int,50,Pattern 5                             |
//| Parameter=PatternsUsed,int,255,Patterns Used BitMap              |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalML_MACD_OBV.                                         |
//| Purpose: Class of generator of trade signals based on            |
//|          Signals of ML with MACD and OBV                          |
//| Is derived from the CExpertSignal class.                         |
//+------------------------------------------------------------------+
#define __PERIOD 15
class CSignalML_MACD_OBV : public CExpertSignal
{
protected:
   CiMACD            m_macd;
   CiOBV             m_obv;
   CiStdDev          m_stddev;
   int               m_patterns_used;

   long              m_handles[__PATTERNS];
   //--- adjusted parameters

   //--- "weights" of market models (0-100)
   int               m_pattern_2;      // model 2
   int               m_pattern_3;      // model 3
   int               m_pattern_5;      // model 5
   //
   //int               m_patterns_usage;   //

public:
   CSignalML_MACD_OBV(void);
   ~CSignalML_MACD_OBV(void);
   //--- methods of setting adjustable parameters
   //--- methods of adjusting "weights" of market models
   void              Pattern_2(int value)
   {  m_pattern_2 = value;
   }
   void              Pattern_3(int value)
   {  m_pattern_3 = value;
   }
   void              Pattern_5(int value)
   {  m_pattern_5 = value;
   }
   void              PatternsUsed(int value)
   {  m_patterns_used = value;
      PatternsUsage(value);
   }
   //--- method of verification of settings
   virtual bool      ValidationSettings(void);
   //--- method of creating the oscillator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void) override;
   virtual int       ShortCondition(void) override;
   virtual double    Direction(void) override;

protected:
   //--- method of initialization of the oscillator
   bool              InitML_MACD_OBV(CIndicators *indicators);
   //--- methods of getting data
   double            MACD(int ind)
   {  //
      m_macd.Refresh(-1);
      return(m_macd.Main(ind));
   }
   double            OBV(int ind)
   {  //
      m_obv.Refresh(-1);
      return(m_obv.GetData(0, ind));
   }
   double            Close(int ind)
   {  //
      m_close.Refresh(-1);
      return(m_close.GetData(ind));
   }
   double            High(int ind)
   {  //
      m_high.Refresh(-1);
      return(m_high.GetData(ind));
   }
   double            Low(int ind)
   {  //
      m_low.Refresh(-1);
      return(m_low.GetData(ind));
   }
   long              Volume(int ind)
   {  //
      m_tick_volume.Refresh(-1);
      return(m_tick_volume.GetData(ind));
   }
   int               X()
   {  //
      return(StartIndex());
   }
   //--- methods to check for patterns
   bool              IsPattern_2(ENUM_POSITION_TYPE T);
   bool              IsPattern_3(ENUM_POSITION_TYPE T);
   bool              IsPattern_5(ENUM_POSITION_TYPE T);

   double            RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X);
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CSignalML_MACD_OBV::CSignalML_MACD_OBV(void) : m_pattern_2(50),
   m_pattern_3(50),
   m_pattern_5(50)
//m_patterns_usage(255)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_TICK_VOLUME;
   PatternsUsage(m_patterns_usage);
//--- create model from static buffer
   m_handles[0] = OnnxCreateFromBuffer(__72_2, ONNX_DEFAULT);
   m_handles[1] = OnnxCreateFromBuffer(__72_3, ONNX_DEFAULT);
   m_handles[2] = OnnxCreateFromBuffer(__72_5, ONNX_DEFAULT);
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CSignalML_MACD_OBV::~CSignalML_MACD_OBV(void)
{
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::ValidationSettings(void)
{
//--- validation settings of additional filters
   if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   const ulong _out_shape[] = {1, 1};
   for(int i = 0; i < __PATTERNS; i++)
   {  // Set input shapes
      const ulong _in_shape[] = {1, 2};
      if(!OnnxSetInputShape(m_handles[i], ONNX_DEFAULT, _in_shape))
      {  Print("OnnxSetInputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
      // Set output shapes
      if(!OnnxSetOutputShape(m_handles[i], 0, _out_shape))
      {  Print("OnnxSetOutputShape error ", GetLastError(), " for feature: ", i);
         return(false);
      }
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- create and initialize MA oscillator
   if(!InitML_MACD_OBV(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Initialize MA indicators.                                        |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::InitML_MACD_OBV(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- add object to collection
   if(!indicators.Add(GetPointer(m_macd)))
   {  printf(__FUNCTION__ + ": error adding object");
      return(false);
   }
//--- initialize object

   if(!m_macd.Create(m_symbol.Name(), m_period,12,26,9,PRICE_CLOSE))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
   if(!m_obv.Create(m_symbol.Name(), m_period,VOLUME_TICK))
   {  printf(__FUNCTION__ + ": error initializing object");
      return(false);
   }
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Detecting the "weighted" direction                               |
//+------------------------------------------------------------------+
double CSignalML_MACD_OBV::Direction(void)
{  return(LongCondition() - ShortCondition());
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalML_MACD_OBV::LongCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_2;
         results++;
      }
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_3;
         results++;
      }
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_BUY))
   {  _x[0] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_BUY, _x);
      if(_y > 0.0)
      {  result += m_pattern_5;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalML_MACD_OBV::ShortCondition(void)
{  int result  = 0, results = 0;
   vectorf _x;
   _x.Init(2);
   _x.Fill(0.0);
//--- if the model 2 is used
   if(((m_patterns_usage & 0x04) != 0) && IsPattern_2(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_2;
         results++;
      }
   }
//--- if the model 3 is used
   if(((m_patterns_usage & 0x08) != 0) && IsPattern_3(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_3;
         results++;
      }
   }
//--- if the model 5 is used
   if(((m_patterns_usage & 0x20) != 0) && IsPattern_5(POSITION_TYPE_SELL))
   {  _x[1] = 1.0f;
      double _y = RunModel(0, POSITION_TYPE_SELL, _x);
      if(_y < 0.0)
      {  result += m_pattern_5;
         results++;
      }
   }
//--- return the result
//if(result > 0)printf(__FUNCSIG__+" result is: %i",result);
   if(results > 0 && result > 0)
   {  return(int(round(result / results)));
   }
   return(0);
}
//+------------------------------------------------------------------+
//| Check for Pattern 2.                                             |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::IsPattern_2(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && Low(X()) < Low(X() + 1) && MACD(X()) > MACD(X() + 1) && OBV(X()) > OBV(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && High(X()) > High(X() + 1) && MACD(X()) < MACD(X() + 1) && OBV(X()) < OBV(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 3.                                             |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::IsPattern_3(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && MACD(X()) > MACD(X() + 1) && MACD(X() + 1) < MACD(X() + 2) && OBV(X()) > OBV(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && MACD(X()) < MACD(X() + 1) && MACD(X() + 1) > MACD(X() + 2) && OBV(X()) < OBV(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Check for Pattern 5.                                             |
//+------------------------------------------------------------------+
bool CSignalML_MACD_OBV::IsPattern_5(ENUM_POSITION_TYPE T)
{  if(T == POSITION_TYPE_BUY && MACD(X()) > MACD(X() + 1) && MACD(X()) < 0.0 && OBV(X()) > OBV(X() + 1))
   {  return(true);
   }
   else if(T == POSITION_TYPE_SELL && MACD(X()) < MACD(X() + 1) && MACD(X()) > 0.0 && OBV(X()) < OBV(X() + 1))
   {  return(true);
   }
   return(false);
}
//+------------------------------------------------------------------+
//| Forward Feed Network, to Get Forecast State.                     |
//+------------------------------------------------------------------+
double CSignalML_MACD_OBV::RunModel(int Index, ENUM_POSITION_TYPE T, vectorf &X)
{  vectorf _y(1);
   _y.Fill(0.0);
   ResetLastError();
   if(!OnnxRun(m_handles[Index], ONNX_NO_CONVERSION, X, _y))
   {  printf(__FUNCSIG__ + " failed to get y forecast, err: %i", GetLastError());
      return(double(_y[0]));
   }
   printf(__FUNCSIG__ + " pre y is: "+DoubleToString(_y[0],5));
   if(T == POSITION_TYPE_BUY && _y[0] > 0.5f)
   {  _y[0] = 2.0f * (_y[0] - 0.5f);
   }
   else if(T == POSITION_TYPE_SELL && _y[0] < 0.5f)
   {  _y[0] = 2.0f * (0.5f - _y[0]);
   }
   printf(__FUNCSIG__ + " post y is: ", DoubleToString(_y[0],5));
   return(double(_y[0]));
}
//+------------------------------------------------------------------+
