# -*- coding: utf-8 -*-
"""Monte Carlo simulation .ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/12w2QW51dSozvE-nj_kxqi_8_bVS5o5Ow
"""

import numpy as np
import matplotlib.pyplot as plt

# Parameters
win_rate = 0.40
reward_risk_ratio = 1.5  # 1.5:1
risk_per_trade = 1  # Risk $1 per trade (normalized)
num_trades = 1000  # Total number of trades to simulate
num_simulations = 1000  # Number of Monte Carlo simulations

# Monte Carlo simulation
equity_curves = []
# Initialize list to store drawdown statistics
drawdown_stats = []

for _ in range(num_simulations):
    equity = 0
    curve = [equity] # Start curve with initial equity (0)
    peak = equity # Track peak equity for drawdown calculation
   # max_drawdown = 0 # Track max drawdown for this simulation

    for _ in range(num_trades):
        if np.random.rand() < win_rate:
            pnl = risk_per_trade * reward_risk_ratio
        else:
            pnl = -risk_per_trade
        equity += pnl
        curve.append(equity)

    equity_curves.append(curve)

# Convert to numpy array for easier analysis
# Note: equity_curves will now have shape (num_simulations, num_trades + 1)
# because we added the initial equity point.
equity_curves = np.array(equity_curves)

# Plot results
plt.figure(figsize=(12, 6))
for i in range(min(num_simulations, 100)):
    # Adjust indexing if plotting against trade number (starts from 0)
    plt.plot(range(num_trades + 1), equity_curves[i], alpha=0.2, color='blue')


# Plot mean curve
mean_curve = equity_curves.mean(axis=0)
plt.plot(range(num_trades + 1), mean_curve, color='red', linewidth=2, label='Mean Equity Curve')


plt.title(f'Monte Carlo Simulation: {num_simulations} Simulations, {num_trades} Trades Each\nWin Rate = {win_rate*100:.1f}%, R:R = {reward_risk_ratio}:1')
plt.xlabel('Number of Trades')
plt.ylabel('Equity (P&L)')
plt.legend()
plt.grid(True)
plt.tight_layout()
plt.show()

# Summary statistics
# Final equity is now the last element of the curve, which has num_trades + 1 points
final_equity = equity_curves[:, -1]
mean_final_equity = final_equity.mean()
median_final_equity = np.median(final_equity)
std_final_equity = final_equity.std()
percent_profitable = np.mean(final_equity > 0) * 100

print('mean_final_equity:',mean_final_equity, '\nmedian_final_equity:', median_final_equity,
 '\nstd_final_equity:', std_final_equity,'\npercent_profitable:', percent_profitable,'%')