//+------------------------------------------------------------------+
//|                                 RSI_Simple_Directions_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#property indicator_separate_window

#property indicator_buffers 2

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red
#property indicator_color3  Red

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

// buffers
double Values[];           // values
double Growing[];          // buffer for marking growing parts

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   IndicatorBuffers(3);
   
   // buffers associating
   SetIndexBuffer(0, Values);

   SetIndexBuffer(1, Growing);
   
   // buffer settings
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();

   // count values
   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
   
   //    --     
   for (i = toCount - 1; i >=0; i--)
   {
      // to check  we need at least 1 older bars
      // if they are not available, there is no reason to continue
      if (i + 1 >= Bars)
      {
         continue;
      }

      // check empty values
      if (
            Values[i]      == EmptyValueUsed || 
            Values[i + 1]  == EmptyValueUsed ||
            Values[i]      == EMPTY_VALUE    || 
            Values[i + 1]  == EMPTY_VALUE
      )
      {
         continue;
      }
      
      // cleaning current marks
      Growing[i] = EMPTY_VALUE;
      
      // growing
      if (Values[i] > Values[i + 1])
      {
         Growing[i] = Values[i];
         Growing[i + 1] = Values[i + 1];
      }
   }

   return(0);
}