//+------------------------------------------------------------------+
//|                                    RSI_Directions_Lib_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#include <Indicator_Painting.mqh>

#property indicator_separate_window

#property indicator_buffers 3

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red
#property indicator_color3  Red

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;

// buffers
double Values[];
double Growing1[];
double Growing2[];

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   IndicatorBuffers(3);
   
   SetIndexBuffer(0, Values);

   SetIndexBuffer(1, Growing1);
   SetIndexBuffer(2, Growing2);
   
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexStyle(2, DRAW_LINE);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();

   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
   
   MarkGrowing(Values, Growing1, Growing2, toCount - 1, 0, EmptyValueUsed);
   
   return(0);
}