//+------------------------------------------------------------------+
//|                                       RSI_Crosses_Lib_Sample.mq4 |
//|                                       Copyright  2009, TheXpert |
//|                                           theforexpert@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2009, TheXpert"
#property link      "theforexpert@gmail.com"

#include <Indicator_Painting.mqh>

#property indicator_separate_window

#property indicator_buffers 3

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_color1  White
#property indicator_color2  Red
#property indicator_color3  Blue

extern int RSIPeriod       = 9;
extern int AppliedPrice    = 0;
extern int MAPeriod        = 5;

// buffers
double Values[];
double SmoothedValues[];
double Crosses[];

int DigitsUsed = 5;
int EmptyValueUsed = 0;

int init()
{
   SetIndexBuffer(0, Values);
   SetIndexBuffer(1, SmoothedValues);
   SetIndexBuffer(2, Crosses);
   
   SetIndexStyle(0, DRAW_LINE);
   SetIndexStyle(1, DRAW_LINE, STYLE_DASH);
   SetIndexStyle(2, DRAW_ARROW, STYLE_SOLID, 2);
   
   SetIndexArrow(2, 251);
   
   IndicatorDigits(DigitsUsed);
   
   SetIndexDrawBegin(0, RSIPeriod);
   SetIndexDrawBegin(1, RSIPeriod + MAPeriod);
   SetIndexDrawBegin(2, RSIPeriod + MAPeriod + 1);

   return(0);
}

int start()
{
   int toCount = Bars - IndicatorCounted();  
   
   for (int i = toCount - 1; i >=0; i--)
   {
      Values[i] = NormalizeDouble(iRSI(Symbol(), 0, RSIPeriod, AppliedPrice, i), DigitsUsed);
   }
      
   for (i = toCount - 1; i >=0; i--)
   {
      SmoothedValues[i] = NormalizeDouble(iMAOnArray(Values, 0, MAPeriod, 0, MODE_EMA, i), DigitsUsed);
   }
      
   MarkCrosses(Values, SmoothedValues, Crosses, toCount - 1, 0, CROSS_ALL, 0);
   
   return(0);
}