//+------------------------------------------------------------------+
//|: 00%.                                                  |
//|                                                        MARCI.mq4 |
//|         Copyright  2008-2009, Emelyanov A.V. <nav_soft@mail.ru> |
//|                                               <nav_soft@mail.ru> |
//+------------------------------------------------------------------+
//+-----------------------------------------------------------------------------------------------------+
//|  1.                                                                      |
//| :  100%                                                                              |
//+-----------------------------------------------------------------------------------------------------+
//----  
#property copyright "Copyright  2008, Emelyanov A.V. <nav_soft@mail.ru>"
#property link      "nav_soft@mail.ru"
#property indicator_separate_window
#property indicator_buffers 5
#import "HighPass.dll"
   void ViewAnsFilter();
   bool TestDllFilter();
   bool AdaptiveHighFilter(double& nInVector[], int nSizeVector, double nSizeWind, double dAmplit);
   void MakeBuffFilter(int nSize);
   void DestrBuffFilter();
#import
//----  
extern int       TypeSignalMA     = 2;             //   
extern int       PeriodSignal     = 6;             //   
extern int       TypePriceChanel  = PRICE_TYPICAL; //   
extern int       PowChanel        = 1;             //  
extern double    KstdChanel       = 2.0;           //   
extern int       PeriodChanel     = 300;           //  
extern double    ZoneChanel       = 0.5;           //   
extern double    SizeWind         = 300.0;         //     
extern double    Amplit           = 0.05;          //   ""   
//----  
double ExtMapBuffer1[];                 //  IRC
double ExtMapBuffer2[];                 //  
double fx[],sqh[],sql[];                // , .  bool Regress(...)
//----  
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{//: 100%.
  string short_name;
  //----"" DLL
  TestDllFilter();
  //----  : 
  SetIndexBuffer(0, ExtMapBuffer1);
  SetIndexBuffer(1, ExtMapBuffer2);
  SetIndexBuffer(2, fx);                //  
  SetIndexBuffer(3, sqh);               //   
  SetIndexBuffer(4, sql);               //   
  SetIndexEmptyValue(2, 0.0);
  SetIndexEmptyValue(3, 0.0);
  SetIndexEmptyValue(4, 0.0);
  //----  : 
  SetIndexStyle(0, DRAW_HISTOGRAM, STYLE_SOLID, 1, Blue);
  SetIndexStyle(1, DRAW_LINE, STYLE_DOT, 1, Red);
  SetIndexStyle(2, DRAW_NONE);
  SetIndexStyle(3, DRAW_NONE);//SetIndexStyle(3, DRAW_LINE, STYLE_DASH, 1, Gray);
  SetIndexStyle(4, DRAW_NONE);//SetIndexStyle(4, DRAW_LINE, STYLE_DASH, 1, Gray);
  //----  /
  short_name = "Adaptiv Filter: IRC("+ PeriodChanel + "/" + PowChanel + "), ";
  switch(TypeSignalMA)
  {
   case 1 : short_name = short_name + "EMA(" + PeriodSignal + ") " ; break;
   case 2 : short_name = short_name + "SMMA(" + PeriodSignal + ") "; break;
   case 3 : short_name = short_name + "LWMA(" + PeriodSignal + ") "; break;
   //case 4 : short_name = short_name + "GMA("; break;
   default :
    TypeSignalMA = 0;
    short_name = short_name + "SMA(";
  }
  IndicatorShortName(short_name);
  SetIndexLabel( 0, "IRC");
  SetIndexLabel( 1, "MA");
  SetIndexLabel( 2, NULL);
  SetIndexLabel( 3, NULL);
  SetIndexLabel( 4, NULL); 
  //---- 
  SetLevelValue(0, ZoneChanel);
  SetLevelValue(1, -ZoneChanel);
  SetLevelValue(2, 1.0);
  SetLevelValue(3, -1.0);
  SetLevelValue(4, 0.0);
  SetLevelStyle(STYLE_DOT, 1, Gray);  
  //----./
  IndicatorDigits(MarketInfo(Symbol(), MODE_DIGITS));
  SetIndexDrawBegin(0, PeriodChanel-1); 
  return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{//: 100%.
 int pos;                               // 
//----      
 if(Bars<=PeriodChanel) return(0);
 pos = PeriodChanel;
 Regress(PowChanel, PeriodChanel, KstdChanel, 0);
 while(pos >= 0)
 {                                      // 
  ExtMapBuffer1[pos] =  iMA(NULL, 0, 2, 0, MODE_EMA, TypePriceChanel, pos);
  if(ExtMapBuffer1[pos] > fx[pos])
  {                                     //  
   ExtMapBuffer1[pos] = (ExtMapBuffer1[pos] - fx[pos])/(sqh[pos] - fx[pos]);
  }else
   {
    if(ExtMapBuffer1[pos] < fx[pos])
    {                                   //  
     ExtMapBuffer1[pos] = (fx[pos] - ExtMapBuffer1[pos])/(fx[pos] - sql[pos]);
     ExtMapBuffer1[pos] = - ExtMapBuffer1[pos];// !
    }else
     {
      ExtMapBuffer1[pos] = 0;
     }
   }
  ExtMapBuffer2[pos] =  iMA(NULL, 0, PeriodSignal, 0, TypeSignalMA, TypePriceChanel, pos);
  //ExtMapBuffer2[pos] = iCustom( Symbol(), 0, "MA+", TypeSignalMA, PeriodSignal, 0, 0, pos);
  if(ExtMapBuffer2[pos] > fx[pos])
  {                                     //  
   ExtMapBuffer2[pos] = (ExtMapBuffer2[pos] - fx[pos])/(sqh[pos] - fx[pos]);
  }else
   {
    if(ExtMapBuffer2[pos] < fx[pos])
    {                                   //  
     ExtMapBuffer2[pos] = ( fx[pos] - ExtMapBuffer2[pos])/(fx[pos] - sql[pos]);
     ExtMapBuffer2[pos] = - ExtMapBuffer2[pos];// !
    }else
     {
      ExtMapBuffer2[pos] = 0;
     }
   }
  pos--; 
 } 
 //------------------------------------------------------------------------------------------------------
 //----   ----------------------------------------------------------------------------
 double dTemp[1000];
 for(int id = 0 ; id<PeriodChanel; id++)
 {
  dTemp[id] = ExtMapBuffer1[id];
 }
 AdaptiveHighFilter(dTemp, PeriodChanel, SizeWind, Amplit);
 for(int id1 = 0 ; id1<PeriodChanel; id1++)
 {
  ExtMapBuffer1[id1] = dTemp[id1];
 } 
 //------------------------------------------------------------------------------------------------------
 for(int id2 = 0 ; id2<PeriodChanel; id2++)
 {
  dTemp[id2] = ExtMapBuffer2[id2];
 }
 AdaptiveHighFilter(dTemp, PeriodChanel, SizeWind, Amplit);
 for(int id12 = 0 ; id12<PeriodChanel; id12++)
 {
  ExtMapBuffer2[id12] = dTemp[id12];
 } 
 //------------------------------------------------------------------------------------------------------
 //------------------------------------------------------------------------------------------------------
 return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int deinit()
{
 DestrBuffFilter();
 return(0);
}
//+-----------------------------------------------------------------------------------------------------+
//|  2.                                                                       |
//| :  100%                                                                              |
//+-----------------------------------------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                        |
//|__________________________________________________________________|
//|  :                                           |
//| double fx[], sqh[], sql[]            ,  |
//|__________________________________________________________________|
//|  :                                                    |
//| int degree    -                                  |
//| int bars      -  -                           |
//| double kstd   -                           |
//| int shift     -                 |
//|__________________________________________________________________|
//|  :                                                   |
//| bool out      -    :                       |
//|         true  -                                         |
//|         false -                              |
//+------------------------------------------------------------------+
bool Regress(int degree, int bars, double kstd, int shift)
{//: 100%.
  //-------- 
  double ai[10,10],b[10],x[10],sx[20];  //. . 
  double sum;                           //.  (. .)
  int ii, jj, kk;                       //.  
  int nn, ll;                           //.  , /. .
  //----
  sx[1]=bars+1;                         
  nn = degree+1;
  //----sx----
  for(jj=1; jj<=nn*2-2; jj++)           //  -   jj  1  nn*2-2 
  {
    sum=0;
    for(ii=0;ii<=bars;ii++)
    {
       sum+=MathPow(ii,jj);
    }
    sx[jj+1]=sum;
  }  
  //----syx----
  for(jj=1;jj<=nn;jj++)
  {
    sum=0.00000;
    for(ii=0;ii<=bars;ii++)
    {
       if(jj==1) sum+=Close[ii];
       else sum+=Close[ii]*MathPow(ii, jj-1);
    }
    b[jj]=sum;
  } 
  //----Matrix----
  for(jj=1;jj<=nn;jj++)
  {
    for(ii=1; ii<=nn; ii++)
    {
       kk=ii+jj-1;
       ai[ii,jj]=sx[kk];
    }
  }  
  //----Gauss----
  for(kk=1; kk<=nn-1; kk++)
  {
    ll=0;
    sum=0;
    for(ii=kk; ii<=nn; ii++)
    {
       if(MathAbs(ai[ii,kk])>sum)
       {
          sum=MathAbs(ai[ii,kk]);
          ll=ii;
       }
    }
    if(ll==0) return(false);   
    if (ll!=kk)
    {
       for(jj=1; jj<=nn; jj++)
       {
          sum=ai[kk,jj];
          ai[kk,jj]=ai[ll,jj];
          ai[ll,jj]=sum;
       }
       sum=b[kk];
       b[kk]=b[ll];
       b[ll]=sum;
    }  
    for(ii=kk+1;ii<=nn;ii++)
    {
       sum=ai[ii,kk]/ai[kk,kk];
       for(jj=1;jj<=nn;jj++)
       {
          if(jj==kk) ai[ii,jj]=0;
          else ai[ii,jj]=ai[ii,jj]-sum*ai[kk,jj];
       }
       b[ii]=b[ii]-sum*b[kk];
    }
  }  
  x[nn]=b[nn]/ai[nn,nn];
  for(ii=nn-1;ii>=1;ii--)
  {
    sum=0;
    for(jj=1;jj<=nn-ii;jj++)
    {
       sum=sum+ai[ii,ii+jj]*x[ii+jj];
       x[ii]=(1/ai[ii,ii])*(b[ii]-sum);
    }
  } 
  //----
  for(ii=0;ii<=bars;ii++)
  {
    sum=0;
    for(kk=1;kk<=degree;kk++)
    {
       sum+=x[kk+1]*MathPow(ii,kk);
    }
    fx[ii]=x[1]+sum;
  } 
  //----Std----
  sum = 0.0;
  for(ii=0;ii<=bars;ii++)
  {
    sum += MathPow(Close[ii]-fx[ii],2);
  }
  sum = MathSqrt(sum/(bars+1))*kstd;
  for(ii=0;ii<=bars;ii++)
  {
    sqh[ii]=fx[ii] + sum;
    sql[ii]=fx[ii] - sum;
  }
  //----
  return(true);
}
//+------------------------------------------------------------------+

