//---------------------------------------------------------------------------
//  : "DLL-:    . ,  |
//                                  METATRADER 4"                |
// :               0.0.0.1                                            |
//  :    , 2009               |
//   IBM PC:  PENTIUM IV, CELERON M; RAM 256 Mb                  |
//   :      MATLAB R2007a, METATRADER 4                        |
//===========================================================================
//|                |                                    |
//===========================================================================
//|  TestDllFilter()         |                               |
//---------------------------------------------------------------------------
//|  AdaptiveHighFilter(..)  |                                |
//---------------------------------------------------------------------------
//|  ViewAnsFilter()         |             |
//===========================================================================
//   :     21  2009                          |
//   :      2009                          |
//  :                                                     |
//  :                                                  |
/*---------------------------------------------------------------------------
**  + *.lib + *.def:
** libeng.lib
** libmx.lib
** libmex.lib
** libmwservices.lib
** libfixedpoint.lib
** libmat.lib
** libut.lib
** mclcom.lib
** mclcommain.lib
** mclmcr.lib
** mclmcrrt.lib
** mclxlmain.lib
** HighPass.def
*/
#define WIN32_LEAN_AND_MEAN  // Exclude rarely-used stuff from Windows headers
#include <windows.h>
#include <stdio.h>
#include <memory.h>
#include <conio.h>
#include "engine.h"
/*---------------------------------------------------------------------------
**  DLL
*/
extern "C" __declspec(dllexport) bool __stdcall AdaptiveHighFilter(double *nInVector, int nSizeIn, double nSizeWind, double dAmplit);
extern "C" __declspec(dllexport) void __stdcall ViewAnsFilter();
extern "C" __declspec(dllexport) bool __stdcall TestDllFilter();
extern "C" __declspec(dllexport) void __stdcall MakeBuffFilter(int nSize);
extern "C" __declspec(dllexport) void __stdcall DestrBuffFilter();
void StartVirtualEngineMatlab();
void StopedVirtualEngineMatlab();
/*---------------------------------------------------------------------------
**  ,  
*/
#define BUFSIZE 256
Engine  *pEng;
mxArray *mxVectorIn;
mxArray *mxVectorOut;
mxArray *mxVector1;
int nSizeVectorIn;
int nSizeVectorOut;
//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{//: 100%.
    /*
    **   
    */
    switch(reason)
    {
        case DLL_PROCESS_ATTACH:
            /*
            **  
  	    **  / MATLAB engine
	    */
            StartVirtualEngineMatlab();
            break;

        case DLL_PROCESS_DETACH:
            /*
            **  
            **  / MatLab engine
            */
  	    StopedVirtualEngineMatlab();
            break;
    }
    return TRUE;
}
//---------------------------------------------------------------------------
bool __stdcall TestDllFilter()
{//: 100%.    DLL,    "" :-)
 /*
 **  /
 */
 if(pEng == NULL) return false;
 return true;
}
//---------------------------------------------------------------------------
void StartVirtualEngineMatlab()
{//: 100%.  /
 /*
 **  /
 */
 if ((pEng = engOpen(NULL)) == NULL)
 {
  MessageBoxA(NULL, (LPSTR)"Can't start MATLAB engine!",
     	      (LPSTR) "MatLab Engine: ERROR!", MB_OK|MB_ICONSTOP);
  return;                 //   /
 };
 nSizeVectorIn     =    0;   //   ()
 nSizeVectorOut    =    0;   ///
 mxVectorIn        = NULL;   //   
 mxVectorOut       = NULL;   ///
 mxVector1         = NULL;   ///
 //
 return;
}
//---------------------------------------------------------------------------
void StopedVirtualEngineMatlab()
{//: 100%.  /
 /*
 **  /
 */
 engClose(pEng);
 DestrBuffFilter();
 //
 return;
}
//---------------------------------------------------------------------------
void __stdcall ViewAnsFilter()
{//: 100%.    
 if((mxVectorIn == NULL)||(mxVectorOut == NULL)) return;
 /*
 **     MATLAB
 */
 engEvalString(pEng, "plot(Y, 'DisplayName', 'Y', 'YDataSource', 'Y'); hold all; plot(X, 'DisplayName', 'X', 'YDataSource', 'Y'); hold off; figure(gcf)");
 //
 return;
}
//---------------------------------------------------------------------------
void __stdcall MakeBuffFilter(int nSize)
{//: 100%. 
 /*
 **    
 */
 if((mxVectorIn != NULL)||(mxVectorOut != NULL)||(mxVector1 != NULL))
 {
  DestrBuffFilter();
 };
 /*
 **   
 */
 mxVectorIn  = mxCreateDoubleMatrix(1, nSize, mxREAL);// -
 mxVectorOut = mxCreateDoubleMatrix(1, nSize, mxREAL);// -
 mxVector1   = mxCreateDoubleMatrix(1, 1, mxREAL);// -
 return;
}
//---------------------------------------------------------------------------
void __stdcall DestrBuffFilter()
{//: 100%. 
 if((mxVectorIn != NULL)||(mxVectorOut != NULL)||(mxVector1 != NULL))
 {//      .
  mxDestroyArray(mxVectorIn);
  mxDestroyArray(mxVectorOut);
  mxDestroyArray(mxVector1);
  mxVectorIn  = NULL;   //   
  mxVectorOut = NULL;   ///
  mxVector1   = NULL;   ///
 };
 return;
}
//---------------------------------------------------------------------------
bool __stdcall AdaptiveHighFilter(double *nInVector, int nSizeIn, double nSizeWind, double dAmplit)
{//: 00%.     , : MarciPass.m
 /*
 **   
 */
 MakeBuffFilter(nSizeIn);
 /*
 **   /
 */
 if(pEng == NULL) return false;
 /*
 **     /
 */
 if((nInVector == NULL)||(nSizeIn < 1)) return NULL;
 nSizeVectorIn  = nSizeIn;              //   
 nSizeVectorOut = nSizeIn;              ///
 /*
 **    
 **   X    MATLAB
 */
 memcpy((char *)mxGetPr(mxVectorIn), (char *)nInVector, (nSizeVectorIn)*8);
 engPutVariable(pEng, "X", mxVectorIn);
 /*
 **   Y    MATLAB
 */
 engPutVariable(pEng, "Y", mxVectorOut);
 /*
 **   A    MATLAB
 */
 memcpy((char *)mxGetPr(mxVector1), (char *)&nSizeWind, 8);
 engPutVariable(pEng, "A", mxVector1);
 /*
 **   B    MATLAB
 */
 memcpy((char *)mxGetPr(mxVector1), (char *)&dAmplit, 8);
 engPutVariable(pEng, "B", mxVector1);
 /*
 **      MATLAB
 */
 engEvalString(pEng, "Y = MarciPass(X, A, B)");
 /*
 **      MATLAB
 */
 mxVectorOut = engGetVariable(pEng, "Y");
 /*
 **     /
 */
 memcpy((char *)nInVector, (char *)mxGetPr(mxVectorOut), (nSizeVectorIn)*8);
 //
 return true;
}
//---------------------------------------------------------------------------
