//+------------------------------------------------------------------+
//|                                                   SignalClas.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <My\Cmlp-.mqh>
//+------------------------------------------------------------------+
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on Regularized Classification Tuned Network. |
//| Type=SignalAdvanced                                              |
//| Name=Clas                                                        |
//| ShortName=Clas                                                   |
//| Class=CSignalClas                                                |
//| Page=signal_clas                                                 |
//| Parameter=TrainSet,int,65,Training Set Size                      |
//| Parameter=Epochs,int,5,Epochs                                    |
//| Parameter=LearningRate,double,0.0005,Learning Rate               |
//| Parameter=InitialWeight,double,0.005,Default Weight              |
//| Parameter=InitialBias,double,0.0,Default Bias                    |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalClas.                                               |
//| Purpose: Class of Regularized Classification Tuned Network.      |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
#define  __MLP_INPUTS 3
#define  __MLP_HIDDEN 6
#define  __MLP_OUTPUTS 3
int      __MLP_ARCH[3] // network arch

=
{  __MLP_INPUTS, __MLP_HIDDEN, __MLP_OUTPUTS
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalClas   : public CExpertSignal
{
protected:
   int                           m_train_set;                       //
   int                           m_epochs;                              // Epochs
   double                        m_learning_rate;                       // Epsilon

   Elearning                     m_learning_type;

   double                        m_train_deposit;
   double                        m_train_criteria;
   
   Eregularize                   m_regularization;
   ENUM_MATRIX_NORM              m_norm;
   double                        m_lambda;

   ENUM_ACTIVATION_FUNCTION      m_activation;
   ENUM_LOSS_FUNCTION            m_loss;

   double                        m_initial_weight;
   double                        m_initial_bias;

   Slearning                     m_learning;
   Smlp                          m_mlp;

public:
                     CSignalClas(void);
                    ~CSignalClas(void);

   //--- methods of setting adjustable parameters
   void                          TrainSet(int value)
   {  m_train_set = value;
   }
   void                          Epochs(int value)
   {  m_epochs = value;
   }
   void                          LearningRate(double value)
   {  m_learning_rate = value;
   }
   void                          LearningType(Elearning value)
   {  m_learning_type = value;
   }


   void                          ActivationType(ENUM_ACTIVATION_FUNCTION value)
   {  m_activation = value;
   }
   void                          LossType(ENUM_LOSS_FUNCTION value)
   {  m_loss = value;
   }
   void                          InitialWeight(double value)
   {  m_initial_weight = value;
   }
   void                          InitialBias(double value)
   {  m_initial_bias = value;
   }
   
   void                          RegularizationType(Eregularize value)
   {  m_regularization = value;
   }
   void                          RegularizationNorm(ENUM_MATRIX_NORM value)
   {  m_norm = value;
   }
   void                          RegularizationLambda(double value)
   {  m_lambda = value;
   }
   
   //--- method of verification of arch
   virtual bool      ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool      InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int       LongCondition(void);
   virtual int       ShortCondition(void);

protected:
   void                          GetOutput(vector &Output);
   void                          SetOutput();

   Cmlp                          *MLP;
};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalClas::CSignalClas(void) :    m_train_set(260),
   m_epochs(30),
   m_learning_rate(0.0005),
   m_learning_type(LEARNING_FIXED),
   m_activation(AF_SOFTMAX),
   m_loss(LOSS_CCE),
   m_initial_weight(0.005),
   m_initial_bias(0.0),
   m_regularization(REGULARIZE_L1),
   m_norm(MATRIX_NORM_NUCLEAR),
   m_lambda(1.0)

{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_SPREAD + USE_SERIES_TIME;
   ArrayResize(m_mlp.arch, ArraySize(__MLP_ARCH));
   for(int i = 0; i < ArraySize(__MLP_ARCH); i++)
   {  m_mlp.arch[i] = __MLP_ARCH[i];
   }
   m_mlp.initial_weight = m_initial_weight;
   m_mlp.initial_bias = m_initial_bias;
   m_mlp.loss = m_loss;
   m_mlp.activation = m_activation;
   m_mlp.regularization = m_regularization;
   m_mlp.regularization_norm = m_norm;
   m_mlp.regularization_lambda = m_lambda;
//
   MLP = new Cmlp(m_mlp);
//
   m_learning.epochs = m_epochs;
   m_learning.initial_rate = m_learning_rate;
   m_learning.rate = m_learning_rate;
   m_learning.type = m_learning_type;
   m_train_deposit = AccountInfoDouble(ACCOUNT_BALANCE);
   m_train_criteria = 0.0;
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalClas::~CSignalClas(void)
{  delete MLP;
}
//+------------------------------------------------------------------+
//| Validation arch protected data.                              |
//+------------------------------------------------------------------+
bool CSignalClas::ValidationSettings(void)
{  if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   if(m_epochs < 1)
   {  printf(__FUNCSIG__ + " epochs size should at least be 1! ");
      return(false);
   }
   if(m_learning_rate < 0.0)
   {  printf(__FUNCSIG__ + " learning rate should be greater than 0.0! ");
      return(false);
   }
   if(!MLP.validated)
   {  printf(__FUNCSIG__ + " invalid network arch. ");
      printf(__FUNCSIG__ +
             " invalid network arch! Settings size is: %i, Max layer size is: %i, Min layer size is: %i, and activation is %s ",
             ArraySize(m_mlp.arch), m_mlp.arch[ArrayMaximum(m_mlp.arch)], m_mlp.arch[ArrayMinimum(m_mlp.arch)], EnumToString(m_mlp.activation)
            );
      return(false);
   }
//read best weights
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalClas::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalClas::LongCondition(void)
{  int result = 0;
   vector _out;
   GetOutput(_out);
   m_close.Refresh(-1);
   if(_out[2] > _out[1] && _out[2] > _out[0])
   {  result = int(round(100.0 * _out[2]));
   }
//printf(__FUNCSIG__ + " output is: %.5f,  and result is: %i", _out[2],  result);return(0);
   return(result);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalClas::ShortCondition(void)
{  int result = 0;
   vector _out;
   GetOutput(_out);
   m_close.Refresh(-1);
   if(_out[0] > _out[1] && _out[0] > _out[2])
   {  result = int(round(100.0 * _out[0]));
   }
//printf(__FUNCSIG__ + " output is: %.5f,  and result is: %i", _out[0],  result);return(0);
   return(result);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CSignalClas::GetOutput(vector &Output)
{  m_learning.rate = m_learning_rate;
   for(int i = m_epochs; i >= 1; i--)
   {  MLP.LearningType(m_learning, i);
      for(int ii = m_train_set; ii >= 0; ii--)
      {  vector _in, _in_data;
         if
         (
            _in_data.Init(__MLP_INPUTS + 1) &&
            _in_data.CopyRates(m_symbol.Name(), m_period, 8, ii + 1, __MLP_INPUTS + 1) &&
            _in_data.Size() == __MLP_INPUTS + 1
         )
         {  _in.Init(__MLP_INPUTS);
            for(int i = 0; i < __MLP_INPUTS; i++)
            {  double _type = _in_data[__MLP_INPUTS - i] - _in_data[__MLP_INPUTS - i - 1];
               _in[i] = (_type < 0.0 ? 0 : (_type > 0.0 ? 2 : 1));
            }
            MLP.Set(_in);
            MLP.Forward();
            if(ii > 0)
            {  vector _target, _target_data;
               if
               (
                  _target_data.Init(2) &&
                  _target_data.CopyRates(m_symbol.Name(), m_period, 8, ii, 2) &&
                  _target_data.Size() == 2
               )
               {  _target.Init(__MLP_OUTPUTS);
                  _target.Fill(0.0);//one-hot-encoding
                  double _type = _target_data[0] - _in_data[1];
                  int _index = (_type < 0.0 ? 0 : (_type > 0.0 ? 2 : 1));
                  _target[_index] = 1.0;//one-hot-encoding
                  MLP.Get(_target);
                  MLP.Backward(m_learning, i);
               }
            }
            Output = MLP.output;
         }
      }
   }
}
//+------------------------------------------------------------------+
