//+------------------------------------------------------------------+
//|                                                TestUtilities.mqh |
//|                                  Copyright 2023, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#include<Math\Stat\Math.mqh>
//+------------------------------------------------------------------+
//| Constant and trend used in regression model                      |
//+------------------------------------------------------------------+

enum ENUM_TREND
  {
   TREND_NONE=0,
   TREND_CONST_ONLY,
   TREND_LINEAR_ONLY,
   TREND_LINEAR_CONST,
   TREND_QUAD_LINEAR_CONST
  };
//+------------------------------------------------------------------+
//| Options for how to handle existing constants                     |
//+------------------------------------------------------------------+

enum ENUM_HAS_CONST
  {
   HAS_CONST_RAISE=0,
   HAS_CONST_SKIP,
   HAS_CONST_ADD
  };
//+------------------------------------------------------------------+
//|helper function : adds selected trend and\or constant             |
//+------------------------------------------------------------------+
bool addtrend(matrix &in,matrix &out,ENUM_TREND trend=TREND_CONST_ONLY, bool prepend=false, ENUM_HAS_CONST has_const=HAS_CONST_SKIP)
  {
//---
   ulong trendorder=0;
//---
   if(trend==TREND_NONE)
      return out.Copy(in);
//---
   if(trend==TREND_CONST_ONLY)
      trendorder = 0;
   else
      if(trend==TREND_LINEAR_CONST || trend==TREND_LINEAR_ONLY)
         trendorder = 1;
      else
         if(trend==TREND_QUAD_LINEAR_CONST)
            trendorder = 2;
//---
   ulong nobs = in.Rows();
//---
   vector tvector,temp;
//---
   if(!tvector.Resize(nobs) || !temp.Resize(nobs))
     {
      Print(__FUNCTION__," ",__LINE__," Resize Error ", ::GetLastError());
      return false;
     }
//---
   double sequence[];
//---
   if(!MathSequence(1,nobs,1,sequence) || !tvector.Assign(sequence))
     {
      Print(__FUNCTION__," ",__LINE__," Error ", ::GetLastError());
      return false;
     }
//---
   matrix trendmat;
//---
   if(!trendmat.Resize(tvector.Size(),(trend==TREND_LINEAR_ONLY)?1:trendorder+1))
     {
      Print(__FUNCTION__," ",__LINE__," Resize Error ", ::GetLastError());
      return false;
     }
//---
   for(ulong i = 0; i<trendmat.Cols(); i++)
     {
      temp = MathPow(tvector,(trend==TREND_LINEAR_ONLY)?double(i+1):double(i));
      if(!trendmat.Col(temp,i))
        {
         Print(__FUNCTION__," ",__LINE__," Matrix Assign Error ", ::GetLastError());
         return false;
        }
     }
//---
   vector ptp = in.Ptp(0);
//---
   if(!ptp.Min())
     {
      if(has_const==HAS_CONST_RAISE)
        {
         Print("Input matrix contains one or more constant columns");
         return false;
        }
      if(has_const==HAS_CONST_SKIP)
        {
         matrix vsplitted[];

         ulong parts[] = {1,trendmat.Cols()-1};

         trendmat.Vsplit(parts,vsplitted);

         if(!trendmat.Copy(vsplitted[1]))
           {
            Print(__FUNCTION__," ",__LINE__," Resize Error ", ::GetLastError());
            return false;
           }
        }
     }
//---
   int order = (prepend)?1:-1;
//---
   if(!out.Resize(trendmat.Rows(),trendmat.Cols()+in.Cols()))
     {
      Print(__FUNCTION__," ",__LINE__," Resize Error ", ::GetLastError());
      return false;
     }
//---
   ulong j = 0;
   matrix mtemp;
//---
   if(prepend)
      mtemp.Copy(trendmat);
   else
      mtemp.Copy(in);
//---
   for(j = 0; j<mtemp.Cols(); j++)
     {
      vector col = mtemp.Col(j);

      if(!out.Col(col,j))
        {
         Print(__FUNCTION__," ",__LINE__," Matrix Assign Error ", ::GetLastError());
         return false;
        }

     }
//---
   ulong minus = j;
//---
   if(prepend)
      mtemp.Copy(in);
   else
      mtemp.Copy(trendmat);
//---
   for(; j<out.Cols(); j++)
     {
      vector col = mtemp.Col(j-minus);

      if(!out.Col(col,j))
        {
         Print(__FUNCTION__," ",__LINE__," Matrix Assign Error ", ::GetLastError());
         return false;
        }

     }
//---
   return true;
//---
  }
