//+------------------------------------------------------------------+
//|                                                      NewsTrading |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                            https://www.mql5.com/en/users/kaaiblo |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|TimeVariables class                                               |
//+------------------------------------------------------------------+
class CTimeVariables
  {
private:
   //---Array to store candlestick times
   datetime          CandleTime[2000];
public:
                     CTimeVariables(void);
   //---Set Array index time
   void              SetTime(uint index,datetime time);
   //---Get Array index time
   datetime          GetTime(uint index);
  };

//+------------------------------------------------------------------+
//|Constructor                                                       |
//+------------------------------------------------------------------+
CTimeVariables::CTimeVariables()
  {
   for(uint i=0; i<CandleTime.Size(); i++)
     {
      CandleTime[i]=D'1970.01.01';
     }
  }

//+------------------------------------------------------------------+
//|Set Array index time                                              |
//+------------------------------------------------------------------+
void CTimeVariables::SetTime(uint index,datetime time)
  {
   if(index>=0&&index<CandleTime.Size())
     {
      CandleTime[index] = time;
     }
  }

//+------------------------------------------------------------------+
//|Get Array index time                                              |
//+------------------------------------------------------------------+
datetime CTimeVariables::GetTime(uint index)
  {
   return (index>=0&&index<CandleTime.Size())?CandleTime[index]:datetime(0);
  }
//+------------------------------------------------------------------+
