/*
// Created by Starlight (extesy@y&&ex.ru). Don't remove this line even if you do conversion to EL,MQL etc!
/---- 
          
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+ 
//|                                                        JVEL1.mq4 |
//|                           Copyright  1998,       Jurik Research |
//|                                          http://www.jurikres.com | 
//|    MQL4 JVEL1: Copyright  2006,                Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers  2
//----   
#property indicator_color1  Gray
#property indicator_color2  Yellow
//----    
#property indicator_style1 0
#property indicator_style2 4
//----    
#property indicator_level1  0.0
#property indicator_levelcolor MediumBlue
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int Depth=10;           //   
extern int Sign.Length=12;     //    
extern int Sign.Phase =100;    //   ,    -100 ... +100,     ;
extern int Input_Price_Customs = 4;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
//----     
double jrc01, jrc04, jrc05, jrc06, jrc07, jrc08, jrc09, trend, JVEL1, Resalt;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JVEL1 initialization function                                    |
//+------------------------------------------------------------------+ 
int init()
  {
//----   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
//---- 2      
   SetIndexBuffer(0,Ind_Buffer1);
   SetIndexBuffer(1,Ind_Buffer2);
//----   ,      
   SetIndexEmptyValue(0,0); 
   SetIndexEmptyValue(1,0);
//----        
   SetIndexLabel(0,"JVELaux"  );  
   SetIndexLabel(3,"Signal"  );    
   IndicatorShortName("JVELaux1( Depth="+Depth+"Input_Price_Customs="+Input_Price_Customs+")"); 
//----    (    )     
   IndicatorDigits(0);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
  if (JJMASeriesResize(1)!=1)return(-1);
//----       
   JJMASeriesAlert (0,"Depth",Depth);
   JJMASeriesAlert (0,"Sign.Length",Sign.Length);
   JJMASeriesAlert (1,"Sign.Phase", Sign.Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----     Depth
   if(Depth<1)Depth=1; 
//----  
   jrc04 = Depth + 1.0;
   jrc05 = jrc04 * (jrc04+1.0)/2.0;
   jrc06 = jrc05 * (2*jrc04+1.0)/3.0;
   jrc07 = jrc05 * jrc05 * jrc05 - jrc06 * jrc06; 
//----  
return(0);
  }
//+------------------------------------------------------------------+ 
//| JVEL1 iteration function                                         |
//+------------------------------------------------------------------+ 
int start()
{
//----       
if(Bars-1<=Depth)return(0);  
//----+        
int reset,limit,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0)counted_bars--;
//----     ,        
limit=Bars-counted_bars-1; MaxBar=Bars-1-Depth;
//----      ,         
//----  
if (limit>MaxBar)
 {
  limit=MaxBar; 
  for(int ttt=Bars-1;ttt>MaxBar;ttt--)
   {
    Ind_Buffer1[ttt]=0.0; 
    Ind_Buffer2[ttt]=0.0; 
   }
 }

//----+  
for(int bar=limit; bar>=0; bar--)
  {
    jrc08 = 0.0;
    jrc09 = 0.0;
    for(int jj=0; jj<=Depth; jj++)
      {
       //----+    PriceSeries     jrc01
       jrc01=PriceSeries(Input_Price_Customs, bar+jj);    
       //----+ 
       jrc08 = jrc08 + jrc01 * (jrc04 - jj);
       jrc09 = jrc09 + jrc01 * (jrc04 - jj) * (jrc04 - jj);
      }
    JVEL1 = (jrc09*jrc05 - jrc08*jrc06) / jrc07; 
    JVEL1 = JVEL1/Point;
    Ind_Buffer1[bar]=JVEL1;
    //----+    (    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0))
    Resalt=JJMASeries(0,0,MaxBar,limit,Sign.Phase,Sign.Length,JVEL1,bar,reset);
    //----+       
     if(reset!=0)return(-1);
     Ind_Buffer2[bar]=Resalt; 
  }  
return(0);
//----    
}

//+---------------------------------------------------------------------------------------+

