/*
          
INDICATOR_COUNTED.mqh    
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\

          
          , 
    RSI.      
         .
,          ,  
   MACD
//---- 
Relative   Strenght  Index  (RSI)
   -     , 
      0  100.    
  RSI      ,    
 ,  RSI      
.              
  .      RSI      
   ,                '
'(failure    swing).              
      .      RSI 
 :
1.          RSI     70, 
  -  30,       
   .
2.      RSI     - 
  '    '    ,    
       .
3.      (      )
  ,   RSI     ()
     ().
4.        RSI   
   ,    .
5.         ,  , 
       (),    
      ()      RSI.      
      RSI.
*/
//+------------------------------------------------------------------+ 
//|                                                         JRSX.mq4 |
//|                JRSX: Copyright  2005,            Jurik Research |
//|                                          http://www.jurikres.com | 
//|     MQL4 JRSX: Copyright  2006,                Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers  1
//----  
#property indicator_color1  BlueViolet
//----    
#property indicator_level1  0.5
#property indicator_level2 -0.5
#property indicator_level3  0.0
#property indicator_levelcolor MediumBlue
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int  JRSX.Length = 8;  //   
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer1[];
//----   
int    r,w,k,time2,Tnew;
//----     
double v8,v10,v14,v18,v20,v0C,v1C,v8A;   
double F28,F30,F38,F40,F48;  
double F50,F58,F60,F68,F70,F78,F80,JRSX; 
double f0,f28,f30,f38,f40,f48,f50,f58,f60,f68,f70,f78,f80,Kg,Hg;
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JRSX initialization function                                     |
//+------------------------------------------------------------------+ 
int init()
  {
//----   
   SetIndexStyle(0,DRAW_LINE);
//---- 1 Q     
   SetIndexBuffer(0,Ind_Buffer1);
//----   ,      
   SetIndexEmptyValue(0,0); 
//----        
   SetIndexLabel(0,"JRSX");
   IndicatorShortName("JRSX(JRSX.Length="+JRSX.Length+", Input_Price_Customs="+Input_Price_Customs+")");
//----    (    )      
   IndicatorDigits(0);
//----       
   PriceSeriesAlert(Input_Price_Customs); 
   if(JRSX.Length<1){Alert(" JRSX.Length     1"
                                + "    "+JRSX.Length+ "   1");}
//----   ,        
   SetIndexDrawBegin(0,JRSX.Length+1);
//----     JRSX.Length
   if(JRSX.Length<1)JRSX.Length=1; 
//----      
   if (JRSX.Length-1>=5) w=JRSX.Length-1; else w=5; Kg=3/(JRSX.Length+2.0); Hg=1.0-Kg;
//----  
return(0);
  }
//+------------------------------------------------------------------+ 
//| JRSX iteration function                                          |
//+------------------------------------------------------------------+ 
int start()
{
//----+        
int limit,bar,reset,MaxBar,MaxBarJ,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-2; limit=Bars-counted_bars-1; 
if (limit>MaxBar){limit=MaxBar;Ind_Buffer1[limit]=0.0;}
//----+ 
//+---    +===================================+
Tnew=Time[limit+1];
if (limit<MaxBar)
if (Tnew==time2)
 {
  f28=F28; f30=F30; f38=F38; f40=F40; f48=F48; f50=F50;     
  f58=F58; f60=F60; f68=F68; f70=F70; f78=F78; f80=F80;
 }
else 
 {
  if (Tnew>time2)
       Print("  !!! Tnew>time2");
  else Print("  !!! Tnew<time2");
  Print("      !");
  return(-1);  
 }
//+--- +======================================================================+
bar=limit;
while (bar>=0)
{
//+---    +====+ 
if (bar==1)
 {
  if(((limit==1)&&(time2==Time[2]))||(limit>1))
    {
     F28=f28; F30=f30; F38=f38; F40=f40; 
     F48=f48; F50=f50; F58=f58; F60=f60; 
     F68=f68; F70=f70; F78=f78; F80=f80;
     time2=Time[bar];
    }
 }
//+---+====================================+     
//+-------------------+
if (r==0){r=1; k=0;}
else
{
//++++++++++++++++++++
if (r>=w) r=w+1; else r=r+1;
//----+     PriceSeries      v8
v8 = PriceSeries(Input_Price_Customs, bar)-PriceSeries(Input_Price_Customs, bar+1);
//----+  
v8A=MathAbs(v8);
//----  V14 ------
f28 = Hg  * f28 + Kg  *  v8;
f30 = Kg  * f28 + Hg  * f30;
v0C = 1.5 * f28 - 0.5 * f30;
f38 = Hg  * f38 + Kg  * v0C;
f40 = Kg  * f38 + Hg  * f40;
v10 = 1.5 * f38 - 0.5 * f40;
f48 = Hg  * f48 + Kg  * v10;
f50 = Kg  * f48 + Hg  * f50;
v14 = 1.5 * f48 - 0.5 * f50;
//----  V20 ------
f58 = Hg  * f58 + Kg  * v8A;
f60 = Kg  * f58 + Hg  * f60;
v18 = 1.5 * f58 - 0.5 * f60;
f68 = Hg  * f68 + Kg  * v18;
f70 = Kg  * f68 + Hg  * f70;
v1C = 1.5 * f68 - 0.5 * f70;
f78 = Hg  * f78 + Kg  * v1C;
f80 = Kg  * f78 + Hg  * f80;
v20 = 1.5 * f78 - 0.5 * f80;
//-------wwwwwwwwww---------
if ((r <= w) && (v8!= 0)) k = 1;
if ((r == w) && (k == 0)) r = 0;
}//++++++++++++++++++++

if ((r>w)&&(v20>0.0000000001))
{
JRSX=v14/v20;
if(JRSX> 1)JRSX= 1;
if(JRSX<-1)JRSX=-1;
}
else JRSX=0;

Ind_Buffer1[bar]=JRSX; 

//----+
bar--;
}
//----    
return(0);
}
//+--------------------------------------------------------------------------------+





