/*
          
JJMASeries.mqh 
JurXSeries.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                       JMACDX.mq4 | 
//|                    JMACD: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2
//----   
#property indicator_color1  Gray
#property indicator_color2  Red
//----   
#property indicator_width1 3
//----    
#property indicator_style2 4
//----    
#property indicator_level1 0.0
#property indicator_levelcolor Blue 
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int FastJurX=6;    //    JurX
extern int SlowJurX=13;   //    JurX
extern int SignalJMA=12;  //    JMA
extern int JMACD_Phase  = 100; // ,    -100 ... +100,    x  JMACD 
extern int Signal_Phase = 100; // ,    -100 ... +100,    x    
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_buffer1[];
double Ind_buffer2[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   JurXSeries
//----+   JurXSeriesResize
//----+   JurXSeriesAlert 
//----+   JurX_ErrDescr  
#include <JurXSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JMACDX initialization function                                   |
//+------------------------------------------------------------------+ 
int init()
  {
//----   
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexStyle(1,DRAW_LINE);
//---- 4     
if(!SetIndexBuffer(0,Ind_buffer1)&& 
   !SetIndexBuffer(1,Ind_buffer2))
   Print("    !");
   //----   ,      
   SetIndexEmptyValue(0,0.0);  
   SetIndexEmptyValue(1,0.0); 
//----        
   IndicatorShortName("JMACDX("+FastJurX+","+SlowJurX+","+SignalJMA+")");
   SetIndexLabel(0,"JMACDX");
   SetIndexLabel(1,"Signal");
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
   if (JJMASeriesResize(1)!=1)return(-1);
//----+      JurXSeries, nJurXnumber=2(    JurXSeries)
   if (JurXSeriesResize(2)!=2)return(-1);
//----       
   JurXSeriesAlert (0,"FastJurX",FastJurX);
   JurXSeriesAlert (0,"SlowJurX",SlowJurX);
   JJMASeriesAlert (0,"SignalJMA",SignalJMA);
   JJMASeriesAlert (1,"Signal_Phase", Signal_Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----  
   return(0);
  }
//+------------------------------------------------------------------+ 
//| JMACDX iteration function                                        |
//+------------------------------------------------------------------+ 
int start()
  {
   //----+      
   double F.JurX,S.JurX,JMACDX,Series,trend,Signal; 
   //----+        
   int reset,limit,MaxBar,MaxBarS,counted_bars=IndicatorCounted();
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----     ,        
   limit=Bars-counted_bars-1; MaxBar=Bars-1; MaxBarS=MaxBar-3*SlowJurX;
   
   //----+     JMACD
   for(int bar=limit; bar>=0; bar--)
    {
     //----+    PriceSeries     Series
     Series=PriceSeries(Input_Price_Customs, bar);  
       
     //----+     JurXSeries   0, 1.  nJurXPhase  nJurXLength      (nJurXdin=0)
     F.JurX=JurXSeries(0,0,MaxBar,limit,FastJurX,Series,bar,reset);
     //----+       
     if(reset!=0)return(-1);
     //+---------------------------------------------------------------------+
     S.JurX=JurXSeries(1,0,MaxBar,limit,SlowJurX,Series,bar,reset);
     //----+       
     if(reset!=0)return(-1); 
     //+---------------------------------------------------------------------+
     //----+   JMACDX
     JMACDX=F.JurX-S.JurX;
     if(bar>MaxBarS)JMACDX = 0;
     Ind_buffer1[bar]=JMACDX;   
     //----+    JJMASeries   2, (nJMA.din=0,     nJMA.MaxBar   3*SlowJurX  . .   ) 
     Signal=JJMASeries(0,0,MaxBarS,limit,Signal_Phase,SignalJMA,JMACDX,bar,reset);
     //----+       
     if(reset!=0)return(-1);
     Ind_buffer2[bar]=Signal; 
   }
//----    
   return(0);
  } 

//+------------------------------------------------------------------------------------+