/*
          
JJMASeries.mqh 
 PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                        JMACD.mq4 |  
//|                    JMACD: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 2
//----   
#property indicator_color1  Gray
#property indicator_color2  Red
//----   
#property indicator_width1 3
//----    
#property indicator_style2 4
//----    
#property indicator_level1 0.0
#property indicator_levelcolor Blue 
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int FastJMA=12;   //    JMA
extern int SlowJMA=26;   //    JMA
extern int SignalJMA=9;  //    JMA
extern int JMACD_Phase  = 100; // ,    -100 ... +100,    x  JMACD 
extern int Signal_Phase = 100; // ,    -100 ... +100,    x    
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_buffer1[];
double Ind_buffer2[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JMACD initialization function                                    |
//+------------------------------------------------------------------+ 
int init()
  {
//----   
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexStyle(1,DRAW_LINE);
//---- 2     
   if(!SetIndexBuffer(0,Ind_buffer1)&&!SetIndexBuffer(1,Ind_buffer2))
      {Print("    !");return(-1);}
   //----   ,      
   SetIndexEmptyValue(0,0.0);  
   SetIndexEmptyValue(1,0.0); 
//----        
   IndicatorShortName("JMACD("+FastJMA+","+SlowJMA+","+SignalJMA+")");
   SetIndexLabel(0,"JMACD");
   SetIndexLabel(1,"Signal");
   //----    (    )        
   IndicatorDigits(0);
//----+      JJMASeries, nJMAnumber=3(    JJMASeries)
   if (JJMASeriesResize(3)!=3)return(-1);
//----       
   JJMASeriesAlert (0,"FastJMA",FastJMA);
   JJMASeriesAlert (0,"SlowJMA",SlowJMA);
   JJMASeriesAlert (0,"SignalJMA",SignalJMA);
   JJMASeriesAlert (1,"JMACD_Phase", JMACD_Phase);
   JJMASeriesAlert (1,"Signal_Phase", Signal_Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----  
   return(0);
  }
//+------------------------------------------------------------------+ 
//| JMACD iteration function                                         |
//+------------------------------------------------------------------+ 
int start()
  {
   //----       
   double F.JMA,S.JMA,JMACD,Series,Signal;
   //----+        
   int reset,limit,MaxBar,MaxBarS,counted_bars=IndicatorCounted();
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----     ,        
   limit=Bars-counted_bars-1; MaxBar=Bars-1; MaxBarS=MaxBar-30;
   
   //----+     JMACD
   for(int bar=limit; bar>=0; bar--)
    {
     //----+    PriceSeries     Series
     Series=PriceSeries(Input_Price_Customs, bar);  
       
     //----+     JJMASeries   0, 1.  nJMA.Phase  nJMA.Length      (nJMA.din=0)
     F.JMA=JJMASeries(0,0,MaxBar,limit,JMACD_Phase,FastJMA,Series,bar,reset);
     //----+       
     if(reset!=0)return(-1); 
     
     S.JMA=JJMASeries(1,0,MaxBar,limit,JMACD_Phase,SlowJMA,Series,bar,reset);
     //----+       
     if(reset!=0)return(-1); 
     
     //----+   JMACD
     JMACD=F.JMA-S.JMA;
     //----+    JMACD    
     JMACD = JMACD/Point;
     Ind_buffer1[bar]=JMACD;     
     //----+    JJMASeries   2, (nJMA.din=0,     nJMA.MaxBar   30  . .   JMA ) 
     Signal=JJMASeries(2,0,MaxBarS,limit,Signal_Phase,SignalJMA,JMACD,bar,reset);
     //----+       
     if(reset!=0)return(-1);
     Ind_buffer2[bar]=Signal; 
   }
//----    
   return(0);
  } 

//+------------------------------------------------------------------------------+


