/*
          

JurXSeries.mqh 
JJMASeries.mqh  
PriceSeries.mqh 

  (): MetaTrader\experts\include\

Heiken Ashi#.mq4

  (): MetaTrader\indicators\

          
          , 
    RSI.      
         .
//---- 
Relative   Strenght  Index  (RSI)
   -     , 
      0  100.    
  RSI      ,    
 ,  RSI      
.              
  .      RSI      
   ,                '
'(failure    swing).              
      .      RSI 
 :
1.          RSI     70, 
  -  30,       
   .
2.      RSI     - 
  '    '    ,    
       .
3.      (      )
  ,   RSI     ()
     ().
4.        RSI   
   ,    .
5.         ,  , 
       (),    
      ()      RSI.      
      RSI.
*/
//+------------------------------------------------------------------+ 
//|                                                        JJRSX.mq4 |
//|    MQL4 JJRSX: Copyright  2006,                Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers  1
//----  
#property indicator_color1  BlueViolet
//----    
#property indicator_level1  0.5
#property indicator_level2 -0.5
#property indicator_level3  0.0
#property indicator_levelcolor MediumBlue
#property indicator_levelstyle 4
//----    --------------------------------------------------------------------------------------------------+
extern int  Length = 8;  //  JurX  
extern int  Smooth = 3;  //  JJMA   
extern int  Phase = 100; // ,    -100 ... +100,    x  
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//----   
int    w;  
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   JurXSeries
//----+   JurXSeriesResize
//----+   JurXSeriesAlert 
//----+   JurX_ErrDescr  
#include <JurXSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JRSX initialization function                                     |
//+------------------------------------------------------------------+ 
int init()
  {
//----   
   SetIndexStyle(0,DRAW_LINE);
//---- 1      
   SetIndexBuffer(0,Ind_Buffer);
//----   ,      
   SetIndexEmptyValue(0,0); 
//----        
   SetIndexLabel(0,"JRSX");
   IndicatorShortName("JRSX(Length="+Length+", Input_Price_Customs="+Input_Price_Customs+")");
//----    (    )      
   IndicatorDigits(2);
//----+      JurXSeries, nJurXnumber=2(    JurXSeries)
   if (JurXSeriesResize(2)!=2)return(-1);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
   if (JJMASeriesResize(1)!=1)return(-1);
//----       
   JurXSeriesAlert (0,"Length",Length);
   JJMASeriesAlert (0,"Smooth",Smooth);
   JJMASeriesAlert (1,"Phase",Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----   ,        
   SetIndexDrawBegin(0,2*Length+31);
//----     Length
   if(Length<1)Length=1; 
//----      
   if (Length>5) w=Length-1; else w=5;
//----  
return(0);
  }
//+------------------------------------------------------------------+ 
//| JRSX iteration function                                          |
//+------------------------------------------------------------------+ 
int start()
{
//----      
double dPrice,dPriceA,UPJRSX,DNJRSX,JRSX,JJRSX; 
//----+        
int bar,limit,reset,MaxBar,MaxBarJ,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-2; MaxBarJ=MaxBar-w-1; limit=Bars-counted_bars-1; 

//+---  
	if (limit>=MaxBar)
	 {
	  limit=MaxBar;
	  for(bar=Bars-1;bar>=MaxBar;bar--)Ind_Buffer[bar]=0.0;
	 }
	 
for(bar=limit;bar>=0;bar--)
  {
   //----+     PriceSeries      dPrice
   dPrice = PriceSeries(Input_Price_Customs, bar)-PriceSeries(Input_Price_Customs, bar+1);
   //----+  
   dPriceA=MathAbs(dPrice);
   //----+     JurXSeries   0  1.  nJJurXLength  t    (nJurXdin=0),       
   UPJRSX=JurXSeries(0,0,MaxBar,limit,Length,dPrice, bar,reset); if(reset!=0)return(-1);
   DNJRSX=JurXSeries(1,0,MaxBar,limit,Length,dPriceA,bar,reset); if(reset!=0)return(-1); 
   //----+
   if (bar>MaxBar-w)JRSX=0;else if (DNJRSX!=0){JRSX=UPJRSX/DNJRSX;if(JRSX>1)JRSX=1;if(JRSX<-1)JRSX=-1;}else JRSX=0;
   //+----------------------------------------------------------------------------+ 
   //----+     JJMASeries   0. 
   //----+  nJMA.Phase  nJMA.Length      (nJMA.din=0)
   //+----------------------------------------------------------------------------+   
   JJRSX=JJMASeries(0,0,MaxBarJ,limit,Phase,Smooth,JRSX,bar,reset);
   //----+       
   if(reset!=0)return(-1);
   //+----------------------------------------------------------------------------+  
   Ind_Buffer[bar]=JJRSX;  
} 
//----    
return(0);
}
//+-------------------------------------------------------------------------+



