/*
            
JJMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\

            
PriceSeries.mqh, 
JJMASeries.mqh
  (): MetaTrader\experts\include\

          
          , 
    RSI.      
         .
,          ,  
   MACD
//---- 
Relative   Strenght  Index  (RSI)
   -     , 
      0  100.    
  RSI      ,    
 ,  RSI      
.              
  .      RSI      
   ,                '
'(failure    swing).              
      .      RSI 
 :
1.          RSI     70, 
  -  30,       
   .
2.      RSI     - 
  '    '    ,    
       .
3.      (      )
  ,   RSI     ()
     ().
4.        RSI   
   ,    .
5.         ,  , 
       (),    
      ()      RSI.      
      RSI.
*/
//+------------------------------------------------------------------+  
//|                                                      3c_JRSX.mq4 |
//|   MQL4+3color: Copyright  2006,                Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers  4
//----  
#property indicator_color1  BlueViolet
#property indicator_color2  Magenta
#property indicator_color3  Gray
#property indicator_color4  Lime
//----   
#property indicator_width1 3
#property indicator_width2 3
#property indicator_width3 3
//----    
#property indicator_style4 4
//----    
#property indicator_level1  0.5
#property indicator_level2 -0.5
#property indicator_level3  0.0
#property indicator_levelcolor MediumBlue
#property indicator_levelstyle 4
//----    --------------------------------------------------------+
extern int  JRSX.Length = 8;  //   
extern int  Sign.Length = 15; //    
extern int  Sign.Phase  = 100; //   ,    -100 ... +100,     ;
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
//+------------------------------------------------------------------+   
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//| JRSX initialization function                                     |
//+------------------------------------------------------------------+  
int init()
  {
//----   
   SetIndexStyle(0,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(1,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(2,DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexStyle(3,DRAW_LINE);
//---- 4      
   SetIndexBuffer(0,Ind_Buffer1);
   SetIndexBuffer(1,Ind_Buffer2);
   SetIndexBuffer(2,Ind_Buffer3);
   SetIndexBuffer(3,Ind_Buffer4);
//----   ,      
   SetIndexEmptyValue(0,0); 
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,0);
   SetIndexEmptyValue(3,0);
//----        
   SetIndexLabel(0,"Up_Trend");
   SetIndexLabel(1,"Down_Trend");
   SetIndexLabel(2,"Straight_Trend");
   SetIndexLabel(3,"Signal");  
   IndicatorShortName("JRSX(JRSX.Length="+JRSX.Length+", Input_Price_Customs="+Input_Price_Customs+")");
//----    (    )      
   IndicatorDigits(0);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
   if (JJMASeriesResize(1)!=1)return(-1);
//----       
   JJMASeriesAlert (0,"Sign.Length",Sign.Length);
   JJMASeriesAlert (1,"Sign.Phase", Sign.Phase);
//----     JRSX.Length
if(JRSX.Length<1)JRSX.Length=1; 
//----      
int w; if (JRSX.Length-1>=5) w=JRSX.Length-1; else w=5; 
//----   ,        
   SetIndexDrawBegin(0,w+2);
   SetIndexDrawBegin(1,w+2);
   SetIndexDrawBegin(2,w+2);  
   SetIndexDrawBegin(3,w+2+30); 
//----  
return(0);
  }
//+------------------------------------------------------------------+ 
//| JRSX iteration function                                          |
//+------------------------------------------------------------------+  
int start()
  {
	//----+        
	double JRSX,trend,Signal; 
	//----+        
	int bar,reset,limit,MaxBar,MaxBarJ,counted_bars=IndicatorCounted();
	//----    
	if (counted_bars<0)return(-1);
	//----       
	//---- (    counted_bars  JJMASeries   !!!)
	if (counted_bars>0) counted_bars--;
	//----     ,        
	MaxBar=Bars-2; MaxBarJ=MaxBar-JRSX.Length; 
	limit=Bars-counted_bars-1; 
	
	if (limit>MaxBar)
	 {
	  limit=MaxBar;
	  Ind_Buffer1[Bars-1]=0.0;
	  Ind_Buffer2[Bars-1]=0.0;
	  Ind_Buffer3[Bars-1]=0.0;
	 }
	//----+    
	for(bar=limit;bar>=0;bar--)
 	 {
		JRSX=iCustom( NULL,0,"JRSX",JRSX.Length,Input_Price_Customs,0,bar);
		//---- +SSSSSSSSSSSSSSSS <<<    >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
		trend=JRSX-Ind_Buffer1[bar+1]-Ind_Buffer2[bar+1]-Ind_Buffer3[bar+1];     
		if(trend>0)     {Ind_Buffer1[bar]=JRSX; Ind_Buffer2[bar]=0;    Ind_Buffer3[bar]=0;}
		else{if(trend<0){Ind_Buffer1[bar]=0;    Ind_Buffer2[bar]=JRSX; Ind_Buffer3[bar]=0;}
		else            {Ind_Buffer1[bar]=0;    Ind_Buffer2[bar]=0;    Ind_Buffer3[bar]=JRSX;}}    
		//---- +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
		
		//----+    (    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0))
		Signal=JJMASeries(0,0,MaxBarJ,limit,Sign.Phase,Sign.Length,JRSX,bar,reset);
		//----+       
		if(reset!=0)return(-1);
		Ind_Buffer4[bar]=Signal;
		//----+
	 } 
	//----    
	return(0);
  }
//+-------------------------------------------------------------------------------+





