/*
          

JurXSeries.mqh, 
PriceSeries.mqh,  
  (): MetaTrader\experts\include\

Heiken Ashi#.mq4
  (): MetaTrader\indicators\

             
JRSX.            
 JMA ,       .
*/
//+------------------------------------------------------------------+  
//|                                                         JurX.mq4 | 
//|          JurXSeries MQL4: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Yellow
//----    --------------------------------------------------------------------------------------------------+
extern int Length  = 5; //     
extern int Shift   = 0; // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//----      
double Price,JurX,Error;
//+------------------------------------------------------------------+   
//----+   JurXSeries
//----+   JurXSeriesResize
//----+   JurXSeriesAlert 
//----+   JurX_ErrDescr  
#include <JurXSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JurX indicator initialization function                           | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1     
SetIndexBuffer(0,Ind_Buffer);
//----     
SetIndexShift (0, Shift); 
//----   ,      
SetIndexEmptyValue(0,0); 
//----        
IndicatorShortName ("JurX( Length="+Length+", Shift="+Shift+")"); 
SetIndexLabel (0, "JurX"); 
//----     
IndicatorDigits(Digits);
//----+       JurXSeries, nJurXnumber=2(   )
if (JurXSeriesResize(2)!=2)return(-1);
//----       
JurXSeriesAlert  (0,"Length",Length  ); 
PriceSeriesAlert(Input_Price_Customs);
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JurX iteration function                                          | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----        
if (Bars-1<Length+1)return(0);
//----+        
int reset,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       (    counted_bars  JurXSeries   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1; MaxBar=Bars-1; 

//----+     
for(int bar=limit;bar>=0;bar--)
 {
  //----+    PriceSeries     Series
  Price=PriceSeries(Input_Price_Customs,bar);
  //----+     JurXSeries   0.  nJJurXLength  t    (nJurXdin=0)
  JurX=JurXSeries(0,0,MaxBar,limit,Length,Price,bar,reset); 
  //----+       
  if(reset!=0)return(-1);  
  //----+      JurX
  //----+     JurXSeries   1.  nJJurXLength  t    (nJurXdin=0)
  Error=JurXSeries(1,0,MaxBar,limit,Length,100,bar,reset); 
  //----+       
  if(reset!=0)return(-1); 
  if(Error==0)Error=1;
  Ind_Buffer[bar]=JurX*100/Error;                 
 }
//----    
return(0); 
} 
//+-----------------------------------------------------------------+

