/*
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
//Version  July 1, 2006                                              |
Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru        |
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
*/
//+------------------------------------------------------------------+ 
//|                                                       JVIDYA.mg4 |
//|                                Copyright  2000 Tushar S. Chande |
//|                                                                  |
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2000 Tushar S. Chande"
#property link ""
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Red 
//----    --------------------------------------------------------------------------------------------------+
extern int VIDYA_period = 9;  // 
extern int JMA_Smooth   = 6;   //  JMA  
extern int JMA_Phase    = 100; // ,    -100 ... +100,     ; 
extern int Shift        = 0;      // c     
extern int Input_Price_Customs = 0;// ,      
//(0-Price, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Price, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Price.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+   
//| JVIDYA initialization function                                   |
//+------------------------------------------------------------------+  
int init()
{
//----   
SetIndexStyle(0,DRAW_LINE);
//---- 1     
SetIndexBuffer(0,Ind_Buffer);
//----   ,      
SetIndexEmptyValue(0,0.0);
//----        
IndicatorShortName("JVIDYA");
//----   ,       
SetIndexDrawBegin(0,VIDYA_period+30); 
//----     
IndicatorDigits(Digits);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1); 
//----       
JJMASeriesAlert (0,"VIDYA_period",VIDYA_period);
JJMASeriesAlert (0,"JMA_Smooth",JMA_Smooth);
JJMASeriesAlert (1,"JMA_Phase", JMA_Phase);
PriceSeriesAlert(Input_Price_Customs);
//----     
SetIndexShift (0, Shift); 
//----  
return(0);
}
//+------------------------------------------------------------------+  
//| JVIDYA iteration function                                        |
//+------------------------------------------------------------------+  
int start()
{ 
//----        
if (Bars-1<VIDYA_period+31)return(0);
//----     
static int time2;static double VIDYA;
double UpSum,DnSum,Up,Dn,JVIDYA,Price,Price0,Price1,AbsCMO,SC,Vidya;
//----+        
int bar,limit,MaxBar,reset,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar = Bars-1-VIDYA_period;
//----     ,         
limit=Bars-counted_bars-1;
//----  
if(limit>=MaxBar)
  {
    limit=MaxBar;
    Vidya=PriceSeries(Input_Price_Customs, MaxBar);
    for(bar = Bars-1; bar >= MaxBar; bar--)Ind_Buffer[bar] = 0;    
  }
//+---    +======+
int Tnew=Time[limit+1];
if (limit<MaxBar)
  if (Tnew==time2)Vidya=VIDYA;
  else 
   {
    if (Tnew>time2)Print("  . Tnew>time2");
              else Print("  . Tnew<time2");
    Print("      ");
    return(-1);  
   }
//+--- +==========================================+
  
//----   ר 
for (bar=limit;bar>=0;bar--) 
 {
 //+---    +====+ 
   if (bar==1)
     if(((limit==1)&&(time2==Time[2]))||(limit>1))
       {
         time2=Time [2];
         VIDYA=Vidya;
       }
  //+---+====================================+     
  UpSum=0; 
  DnSum=0; 
  //---
  for (int iii=VIDYA_period;iii>=0;iii--) 
   {
     Up = 0; 
     Dn = 0; 
     Price0=PriceSeries(Input_Price_Customs, bar+iii);
     Price1=PriceSeries(Input_Price_Customs, bar+iii+1);
     if (Price0 > Price1)Up = Price0-Price1; 
     if (Price0 < Price1)Dn = MathAbs(Price0-Price1); 
     UpSum +=  Up; 
     DnSum +=  Dn; 
   } 
   //---
  if (UpSum+DnSum >0)AbsCMO=MathAbs((UpSum-DnSum)/(UpSum+DnSum));  
  Price0=PriceSeries(Input_Price_Customs, bar);
  Vidya=AbsCMO*Price0+(1-AbsCMO)*Vidya; 
  //----+ JMA   ,  nJMA.MaxBar     nf
  //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
  JVIDYA=JJMASeries(0,0,MaxBar,limit,JMA_Phase,JMA_Smooth,Vidya,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  //----
  Ind_Buffer[bar] = JVIDYA; 
 }
//----   
return(0);
}
//+------------------------------------------------------+

