/*
  ParMA,       

          
JJMASeries.mqh 
ParMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+ 
//|                                                       JParMA.mq4 |
//|                    JParMA & ParMA CODE:Copyright  2006, alexjou |
//|                    Indicator: Copyright  2006, Nikolay Kositsin |
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window
//----   
#property indicator_buffers 1
//----   
#property indicator_color1 Red
//----    --------------------------------------------------------------------------------------------------+
extern int MA_Period  = 8; //  ParMA
extern int Length = 3;   //   
extern int Phase  = 100; // ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double IndBuffer[];
//----     
double JResalt, Price, Resalt;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   ParMAMASeries 
//----+   ParMASeriesResize 
//----+   ParMASeriesAlert 
//----+   ParMA_ErrDescr 
#include <ParMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JParMA initialization function                                   |
//+------------------------------------------------------------------+ 
int init()
 {
  //----     
  IndicatorDigits(Digits);
  //----    
  SetIndexStyle(0, DRAW_LINE);
  //---- 1     
  SetIndexBuffer(0, IndBuffer);
  //----     
  SetIndexShift (0, Shift); 
  //----   ,      
  SetIndexEmptyValue(0, 0.0); 
  //----         
  IndicatorShortName ("JParMA( Length="+Length+", Phase="+Phase+", Shift="+Shift+")");   
  SetIndexLabel(0, "JParMA Line");
  //----   ,       
  SetIndexDrawBegin(0, MA_Period);
  //----+      JJMASeries, nJMAnumber=1(    JJMASeries)
  if (JJMASeriesResize(1)!=1)return(-1);
  //----+      ParMASeries, nParMAnumber=1(    ParMASeries)
  if (ParMASeriesResize(1)!=1)return(-1);
  //----       
  JJMASeriesAlert (0,"Length",Length);
  JJMASeriesAlert (1,"Phase", Phase );
  ParMASeriesAlert(0,"MA_Period",MA_Period);
  PriceSeriesAlert(Input_Price_Customs);
  return(0);
 }
//+------------------------------------------------------------------+ 
//| JParMA iteration function                                        |
//+------------------------------------------------------------------+ 
int start()
 {
 //----       
if (Bars-1<MA_Period)return(0);
//----+        
int reset,MaxBar,MaxBarP,bar,Limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-1;
MaxBarP=MaxBar-MA_Period;
Limit=Bars-counted_bars-1; 

//----  
for (bar=Limit; bar>=0; bar--)
   { 
    //----+ 
     Price=PriceSeries(Input_Price_Customs,bar);
     //----+   
     //----+    ParMASeries   0
     Resalt=ParMASeries(0,MaxBar,Limit,MA_Period,Price,bar,reset); 
     //----+       
     if(reset!=0)return(-1);
     //----+ JMA   ,  nJMA.MaxBar   MA_Period 
     //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
     JResalt=JJMASeries(0,0,MaxBarP,Limit,Phase,Length,Resalt,bar,reset);
     //----+       
     if(reset!=0)return(-1);
     IndBuffer[bar]=JResalt;
   }
 //----
  return(0);
 }
 
//+---------------------------------------------------------------------+

