/*
          
JLiteSeries.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                        JLite.mq4 | 
//|                            Copyright  2006,    Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Red  
//----    -----------------------------------------------------------------------------------------------------+
extern int Length = 5;   //     
extern int Phase  = 100; //   ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- ----------------------------------------------------------------------------------------------------------------------------------+
//----  
double JLite[];
//----      
double Temp_Series,Resalt;
//+------------------------------------------------------------------+  
//----+   JLiteSeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
#include <JLiteSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JLite indicator initialization function                          | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1     
SetIndexBuffer(0,JLite);
//----     
SetIndexShift (0, Shift); 
//----   ,      
SetIndexEmptyValue(0,0.0);    
//----         
IndicatorShortName ("JLite( Length="+Length+", Phase="+Phase+",  Shift="+Shift+")"); 
SetIndexLabel (0, "JLite"); 
//----     
IndicatorDigits(Digits);
//----       
JJMASeriesAlert (0,"Length",Length);
JJMASeriesAlert (1,"Phase", Phase);
PriceSeriesAlert(Input_Price_Customs);
//----+      JLiteSeries, nJMAnumber=1(    JLiteSeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JLite iteration function                                         | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----        
if (Bars-1<31)return(0);
//----+        
int reset,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1; int limit=MaxBar-counted_bars;

//----+     
for(int bar=limit;bar>=0;bar--)
  {
    //----+    PriceSeries     Series
    Temp_Series=PriceSeries(Input_Price_Customs, bar);
    //----+    JLiteSeries   0.  nJLitePhase  nJLiteLength      (nJLitedin=0)
    Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,Temp_Series,bar,reset);
    //----+       
    if(reset!=0)return(-1);
    JLite[bar]=Resalt;
  }
//----    
return(0); 
} 

//+-----------------------------------------------------------+

