/*
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
//Version  July 1, 2006                                              |
Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru        |
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
*/
//+------------------------------------------------------------------+ 
//|                                                        JLSMA.mg4 |
//|                             Copyright  2005 dwt5 and adoleh2000 |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2005 dwt5 and adoleh2000 "
#property link "http://www.metaquotes.net/"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Red 
//----    --------------------------------------------------------------------------------------------------+
extern int LSMA_period = 10;
extern int JMA_Lenght  = 6;   //   
extern int JMA_Phase   = 100; // ,    -100 ... +100,     ; 
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+   
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JLSMA initialization function                                    |
//+------------------------------------------------------------------+  
int init()
{
//----   
SetIndexStyle(0,DRAW_LINE);
//---- 1     
SetIndexBuffer(0,Ind_Buffer);
//----   ,      
SetIndexEmptyValue(0,0.0);
//----        
IndicatorShortName("Trigger Line");
//----   ,       
SetIndexDrawBegin(0,LSMA_period); 
//----     
IndicatorDigits(Digits);
//----+      JJMASeries, nJMAnumber=2(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----       
JJMASeriesAlert (0,"LSMA_period",LSMA_period);
JJMASeriesAlert (0,"JMA_Lenght",JMA_Lenght);
JJMASeriesAlert (1,"JMA_Phase", JMA_Phase);
PriceSeriesAlert(Input_Price_Customs);
//----  
return(0);
}
//+------------------------------------------------------------------+  
//| JLSMA iteration function                                         |
//+------------------------------------------------------------------+  
int start()
{
//----        
if (Bars-1<LSMA_period+31)return(0);
//----       
double LSMA,Sum,JLSMA,Price;
//----+        
int bar,limit,MaxBar,reset,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar = Bars-LSMA_period;
//----     ,         
limit=Bars-counted_bars-1;
//----  
if(limit>=MaxBar)
  {
    limit=MaxBar;
    for(bar = Bars-1; bar >= MaxBar; bar--)Ind_Buffer[bar] = 0; 
  }
//----   ר 
for(bar = limit; bar >= 0; bar--) 
  { 
    Sum = 0; 
    for(int iii = 1; iii <= LSMA_period ; iii++) 
      {  
        Price=PriceSeries(Input_Price_Customs, bar+LSMA_period-iii);
        Sum+= ( iii - (LSMA_period + 1.0)/3)*Price; 
      }
    //----
    LSMA = Sum*6/(LSMA_period*(LSMA_period+1.0));    
    //----+ JMA   ,  nJMA.MaxBar     nf
    //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
    JLSMA=JJMASeries(0,0,MaxBar,limit,JMA_Phase,JMA_Lenght,LSMA,bar,reset);
    //----+       
    if(reset!=0)return(-1);
    //----
    Ind_Buffer[bar] = JLSMA; 
  }
//----   
return(0);
}
//+---------------------------------------------------+

