/*
  LRMA,    

          
JJMASeries.mqh 
LRMASeries.mqh 
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+ 
//|                                                        JLRMA.mq4 |
//|                             LRMA CODE: Copyright  2006, alexjou |
//|                    Indicator: Copyright  2006, Nikolay Kositsin |
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window
//----   
#property indicator_buffers 1
//----   
#property indicator_color1 MediumOrchid
//----    --------------------------------------------------------------------------------------------------+
extern int MA_Period  = 8; //  LRMA
extern int Length = 3;   //   
extern int Phase  = 100; // ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double IndBuffer[];
//----     
double JResalt, Price, Resalt;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   LRMAMASeries 
//----+   LRMASeriesResize 
//----+   LRMASeriesAlert 
//----+   LRMA_ErrDescr 
#include <LRMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JLRMA initialization function                                    |
//+------------------------------------------------------------------+ 
int init()
 {
  //----     
  IndicatorDigits(Digits);
  //----    
  SetIndexStyle(0, DRAW_LINE);
  //---- 1     
  SetIndexBuffer(0, IndBuffer);
  //----     
  SetIndexShift (0, Shift); 
  //----   ,      
  SetIndexEmptyValue(0, 0.0); 
  //----         
  IndicatorShortName ("JLRMA( Length="+Length+", Phase="+Phase+", Shift="+Shift+")");   
  SetIndexLabel(0, "JLRMA Line");
  //----   ,       
  SetIndexDrawBegin(0, MA_Period);
  //----+      JJMASeries, nJMAnumber=1(    JJMASeries)
  if (JJMASeriesResize(1)!=1)return(-1);
  //----+      LRMASeries, nLRMAnumber=1(    LRMASeries)
  if (LRMASeriesResize(1)!=1)return(-1);
  //----       
  JJMASeriesAlert (0,"Length",Length);
  JJMASeriesAlert (1,"Phase", Phase );
  LRMASeriesAlert(0,"MA_Period",MA_Period);
  PriceSeriesAlert(Input_Price_Customs);
  return(0);
 }
//+------------------------------------------------------------------+ 
//| JLRMA iteration function                                         |
//+------------------------------------------------------------------+ 
int start()
 {
 //----       
if (Bars-1<MA_Period)return(0);
//----+        
int reset,MaxBar,MaxBarL,bar,Limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-1;
MaxBarL=MaxBar-MA_Period;
Limit=Bars-counted_bars-1; 
//----  
for (bar=Limit; bar>=0; bar--)
   { 
    //----+ 
     Price=PriceSeries(Input_Price_Customs,bar);
     //----+   
     //----+    LRMASeries   0
     Resalt=LRMASeries(0,MaxBar,Limit,MA_Period,Price,bar,reset); 
     //----+       
     if(reset!=0)return(-1);
     //----+ JMA   ,  nJMA.MaxBar   MA_Period 
     //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
     JResalt=JJMASeries(0,0,MaxBarL,Limit,Phase,Length,Resalt,bar,reset);
     //----+       
     if(reset!=0)return(-1);
     IndBuffer[bar]=JResalt;
   }
 //----
  return(0);
 }
//+----------------------------------------------------+

