/*
          
JurXSeries.mqh, 
JJMASeries.mqh, 
PriceSeries.mqh,  
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
             
JRSX.            
 JMA ,       .

*/
//+------------------------------------------------------------------+ 
//|                                                        JJurX.mq4 | 
//|                           Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Gold
//----    --------------------------------------------------------------------------------------------------+
extern int JurX_Length  = 5; //  JurX  
extern int JJMA_Length  = 4; //  JJMA  
extern int JJMA_Phase   = -100;//  JJMA ,    -100 ... +100,     ; 
extern int Shift        = 0;      // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Ind_Buffer[];
//----      
double Price,JurX,JJurX,Error;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   JurXSeries
//----+   JurXSeriesResize
//----+   JurXSeriesAlert 
//----+   JurX_ErrDescr  
#include <JurXSeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JJurX indicator initialization function                          | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1     
SetIndexBuffer(0,Ind_Buffer);
//----     
SetIndexShift (0, Shift); 
//----   ,      
SetIndexEmptyValue(0,0); 
//----         
IndicatorShortName ("JJurX( JurX_Length="+JurX_Length+", Shift="+Shift+")"); 
SetIndexLabel (0, "JJurX"); 
//----     
IndicatorDigits(Digits);
//----+      JurXSeries, nJurXnumber=2(    JurXSeries)
if (JurXSeriesResize(2)!=2)return(-1);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----         
JurXSeriesAlert(0,"JurX_Length",JurX_Length); 
JJMASeriesAlert(0,"JJMA_Length",JJMA_Length); 
JJMASeriesAlert(1,"JJMA_Phase",JJMA_Phase); 
PriceSeriesAlert(Input_Price_Customs);
//----  
return(0); 
} 
//+------------------------------------------------------------------+ 
//| JJurX iteration function                                         | 
//+------------------------------------------------------------------+ 
int start() 
{ 
//----        
if (Bars-1<JurX_Length+32)return(0);
//----+        
int reset,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       (    counted_bars  JurXSeries   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1; MaxBar=Bars-1; 

//----+     
for(int bar=limit;bar>=0;bar--)
 {
  //----+    PriceSeries     Series
  Price=PriceSeries(Input_Price_Customs,bar);
  //----+     JurXSeries   0.  nJJurX.Length  t    (nJurXdin=0)
  JurX=JurXSeries(0,0,MaxBar,limit,JurX_Length,Price,bar,reset); 
  //----+       
  if(reset!=0)return(-1); 
  //----+      JurX
  //----+     JurXSeries   1.  nJJurX.Length  t    (nJurXdin=0)
  Error=JurXSeries(1,0,MaxBar,limit,JurX_Length,100,bar,reset); 
  //----+       
  if(reset!=0)return(-1);
  if(Error==0)Error=1;
  JurX*=100/Error;
  //----+    JJMASeries   0.  nJMA.Phase  nJMA.Length      (nJMA.din=0)
  JJurX=JJMASeries(0,0,MaxBar,limit,JJMA_Phase,JJMA_Length,JurX,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  Ind_Buffer[bar]=JJurX;                 
 }
//----    
return(0); 
} 
//+-------------------------------------------------------------------------+

