/*
          
JJMASeries.mqh  
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                       JFRAMA.mq4 | 
//|                           Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----  
#property indicator_color1 Red  
//----    --------------------------------------------------------------------------------------------------+
extern int FRAMA_Period = 10;   //  FRAMA
extern int Smooth = 10;   //     
extern int Smooth_Phase = 100;   // ,    -100 ... +100,     ;
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;/*  ,      
(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.) */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double FRAMA[];
double Ind_Buffer[];
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+   
//| JFRAMA indicator initialization function                         | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1     
IndicatorBuffers(2);
SetIndexBuffer(0,Ind_Buffer);
SetIndexBuffer(1,FRAMA);
//----     
SetIndexShift (0, Shift); 
//----   ,      
SetIndexEmptyValue(0,0.0);    
//----         
IndicatorShortName ("FRAMA( FRAMA_Period="+FRAMA_Period+",  Shift="+Shift+")"); 
SetIndexLabel (0, "FRAMA"); 
//----
IndicatorDigits(Digits);
//----       
PriceSeriesAlert(Input_Price_Customs);
JJMASeriesAlert (0,"Smooth",Smooth);
JJMASeriesAlert (1,"Smooth_Phase",Smooth_Phase);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
if (JJMASeriesResize(1)!=1)return(-1);
//----   ,      
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JFRAMA iteration function                                        | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----        
if (Bars-1<FRAMA_Period+1)return(0);

double N1,N2,N3,HH,LL,Max,Min,Dimen,alpha,Filt,Filt1,Price,Resalt;
//----+        
int reset,bar,limit,iii,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1-FRAMA_Period; limit=MaxBar-counted_bars;
//----  
if (limit>=MaxBar)
 {
  limit=MaxBar;
  Filt1=PriceSeries(Input_Price_Customs,MaxBar);
  FRAMA[bar]=0;
  Ind_Buffer[bar]=0;
 }
else Filt=FRAMA[limit+1];

//----+     
for(bar=limit;bar>=0;bar--)
 {
  //----
  HH = High[bar+FRAMA_Period]; 
  LL = Low [bar+FRAMA_Period]; 
  for(iii = FRAMA_Period; iii>FRAMA_Period / 2; iii--)
   { 
    if (High[bar+iii] > HH) HH = High[bar+iii]; 
    if (Low [bar+iii] < LL) LL = Low [bar+iii];
   } 
  N1 = (HH - LL) / (FRAMA_Period / 2);
  //---- 
  HH = High[bar+FRAMA_Period / 2]; 
  LL = Low [bar+FRAMA_Period / 2]; 
  for(iii = FRAMA_Period / 2; iii >= 0; iii--)
   {
    if (High[bar+iii] > HH) HH = High[bar+iii]; 
    if (Low [bar+iii] < LL) LL = Low [bar+iii];
   } 
  N2 = (HH - LL) / (FRAMA_Period / 2); 
  //----
  Max=High[iHighest(NULL, 0, MODE_HIGH, FRAMA_Period, bar)];
  Min=Low [iLowest (NULL, 0, MODE_LOW,  FRAMA_Period, bar)];
  N3 = (Max - Min) / FRAMA_Period;   
  if ((N1 > 0)&&(N2 > 0)&&(N3 > 0)) Dimen = (MathLog( N1 + N2) - MathLog( N3)) / MathLog( 2); 
  alpha = MathExp(- 4.6*( Dimen - 1)); 
  if (alpha < 0.01)alpha = 0.01; 
  if (alpha > 1   )alpha = 1; 
  //----
  Price=PriceSeries(Input_Price_Customs,bar);
  Filt = alpha* Price + (1 - alpha)* Filt; 
  FRAMA[bar]=Filt;
  //----+ JMA   
  //----+    JJMASeries   0,  nJMA.Phase  nJMAFRAMA_Period      (nJMA.din=0)
  Resalt=JJMASeries(0,0,MaxBar,limit,Smooth_Phase,Smooth,Filt,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
//----    
return(0); 
} 

//+----------------------------------------------------+

