//   1.07.2006   
/*
          
JMASeries.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\
*/
//+------------------------------------------------------------------+ 
//|                                                         JAMA.mq4 | 
//|                         JAMA: Copyright  2006, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link      "farria@mail.redcom.ru"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1
//----     
#property indicator_color1 Red
//----    --------------------------------------------------------------------------------------------------+
extern int          period_AMA = 10;// AMA
extern int               nfast = 3; //     AMA
extern int               nslow = 30;//     AMA
extern double                G = 1.0;// ,     
extern int              Length = 5; //   
extern int               Phase = 0; // ,    -100 ... +100,     ; 
extern int             Shift   = 0; // c     
extern int Input_Price_Customs = 0; // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double JkAMAbuffer[];
//----+     
double dSC,slowSC,fastSC,Resalt;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+   
//| JAMA initialization function                                     |
//+------------------------------------------------------------------+ 
int init()
  {
//----    
   SetIndexStyle (0,DRAW_LINE); 
//---- 1     
   SetIndexBuffer(0,JkAMAbuffer); 
//----       
   JJMASeriesAlert (0,"Length",Length);
   JJMASeriesAlert (1,"Phase", Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
   if (JJMASeriesResize(1)!=1)return(-1);
//----   ,      
   SetIndexEmptyValue(0,0.0); 
//----     
   IndicatorDigits(Digits);
//----     
   SetIndexShift (0, Shift); 
//----         
   IndicatorShortName ("JAMA( period_AMA="+period_AMA+", G="+G+", Length="+Length+")"); 
   SetIndexLabel (0, "JAMA");  
//----  
   slowSC=(2.0 /(nslow+1));
   fastSC=(2.0 /(nfast+1)); 
   dSC=fastSC-slowSC; 
//----
   return(0);
  }
//+------------------------------------------------------------------+ 
//| JAMA iteration function                                          |
//+------------------------------------------------------------------+ 
int start()
  {
  //----       
if (Bars<period_AMA+2)return(0);
//----+     
double noise,AMA,signal,ER,ERSC,SSC,Resalt;
//----+        
int limit,reset,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-period_AMA-2;
bar=Bars-counted_bars-1; 
//----  
if (bar>MaxBar)
      {
       for (int ii=bar; ii>MaxBar;ii--)JkAMAbuffer[ii]=0.0;
       bar=MaxBar;
       AMA=PriceSeries(Input_Price_Customs,bar + 1);
      }
else AMA=JkAMAbuffer[bar+1];
limit=bar;
//----  
while (bar>=0)
     {
      noise=Point/100000;
      for(int jj=0;jj<period_AMA;jj++)
                noise=noise+MathAbs(PriceSeries(Input_Price_Customs,bar+jj)-PriceSeries(Input_Price_Customs,bar+jj+1));
      signal=MathAbs(PriceSeries(Input_Price_Customs,bar)-PriceSeries(Input_Price_Customs,bar+period_AMA));
      ER =signal/noise;
      ERSC=ER*dSC;
      SSC=ERSC+slowSC;
      AMA=AMA+(MathPow(SSC,G)*(Close[bar]-AMA));
      //----+ JMA   
      //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
      Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,AMA,bar,reset);
      //----+       
      if(reset!=0)return(-1);
      JkAMAbuffer[bar]=Resalt;
      bar--;
     }
//----
   return(0);
  }
//+--------------------------------------------------------------+

