//   1.07.2006   
/*
          
JMASeries.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                        AMAJ2.mq4 | 
//|                             Copyright  2006,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1
//----     
#property indicator_color1 Red
//----    --------------------------------------------------------------------------------------------------+
extern int          AMA_Period = 7;// AMA
extern int               nfast = 3; //     AMA
extern int               nslow = 30;//     AMA
extern double                G = 2.0;// 
extern int               Phase = 0; // ,    -100 ... +100,     ; 
extern int Input_Price_Customs = 0; // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double JkAMAbuffer[];
int period_Swing;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| AMAJ2 initialization function                                    |
//+------------------------------------------------------------------+ 
int init()
  {
//----     
   IndicatorDigits(Digits);
//----    
   SetIndexStyle(0,DRAW_LINE);
//---- 1     
   SetIndexBuffer(0,JkAMAbuffer); 
//----       
   JJMASeriesAlert (0,"AMA_Period",AMA_Period);
   JJMASeriesAlert (1,"Phase", Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----+      JJMASeries, nJMAnumber=3(    JJMASeries)
   if (JJMASeriesResize(3)!=3)return(-1);
//----   ,      
   SetIndexEmptyValue(0,0.0); 
//----  
   period_Swing=nslow-nfast;
//----
   return(0);
  }
//+------------------------------------------------------------------+ 
//| AMAJ2 iteration function                                         |
//+------------------------------------------------------------------+ 
int start()
  {
  //----       
if (Bars<AMA_Period+nslow)return(0);
double noise,AMA,signal,ER,NR,NRG,Price,Resalt;
//----+        
int limit,reset,MaxBar1,MaxBar2,MaxBar3,bar,Length,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar1=Bars-AMA_Period-nslow;
MaxBar2=MaxBar1-30;
MaxBar3=MaxBar2-30;
bar=Bars-counted_bars-1; 
if(limit>MaxBar1)limit=MaxBar1;
limit=bar;
//----  
while (bar>=0)
     {
      //----     ER
      noise=Point/100000;
      for(int jj=0;jj<AMA_Period;jj++)
                noise=noise+MathAbs(PriceSeries(Input_Price_Customs,bar+jj)-PriceSeries(Input_Price_Customs,bar+jj+1));
      signal=MathAbs(PriceSeries(Input_Price_Customs,bar)-PriceSeries(Input_Price_Customs,bar+AMA_Period));
      ER=signal/noise;
      ER=JJMASeries(0,0,MaxBar1,limit,100,10,ER,bar,reset);
      //----   
      NR=1-ER;
      NRG=MathPow(NR, G); 
      Length=nfast+NRG*period_Swing;
      //---- 
      Price=PriceSeries(Input_Price_Customs,bar);
      //----+    JJMASeries   0,  nJMA.Length     (nJMA.din=1)
      Resalt=JJMASeries(1,1,MaxBar2,limit,Phase,Length,Price,bar,reset);
      //----+       
      if(reset!=0)return(-1);
       //----+    JJMASeries   0,  nJMA.Length     (nJMA.din=1)
      Resalt=JJMASeries(2,1,MaxBar3,limit,Phase,Length, Resalt,bar,reset);
      //----+       
      if(reset!=0)return(-1);
      JkAMAbuffer[bar]=Resalt;
      bar--;
     }
//----
   return(0);
  }
//+--------------------------------------------------------------------------+

