//   1.07.2006   
/*
          
JMASeries.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                         AMAJ.mq4 | 
//|                             Copyright  2006,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1
//----     
#property indicator_color1 Red
//----    --------------------------------------------------------------------------------------------------+
extern int          AMA_Period = 10;// AMA
extern int               nfast = 3; //     AMA
extern int               nslow = 16;//     AMA
extern double                G = 0.7;// ,      
extern int               Phase = 0; // ,    -100 ... +100,     ; 
extern int Input_Price_Customs = 0; // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double JkAMAbuffer[];
int period_Swing;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JAMA initialization function                                     |
//+------------------------------------------------------------------+ 
int init()
 {
//----     
   IndicatorDigits(Digits);
//----    
   SetIndexStyle(0, DRAW_LINE);
//---- 1     
   SetIndexBuffer(0,JkAMAbuffer); 
//----       
   JJMASeriesAlert (0,"AMA_Period",AMA_Period);
   JJMASeriesAlert (1,"Phase", Phase);
   PriceSeriesAlert(Input_Price_Customs);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
   if (JJMASeriesResize(1)!=1)return(-1);
//----   ,      
   SetIndexEmptyValue(0,0.0); 
//----   ,       
   SetIndexDrawBegin(0, AMA_Period+30);
//----  
   period_Swing=nslow-nfast;
//----
   return(0);
  }
//+------------------------------------------------------------------+ 
//| JAMA iteration function                                          |
//+------------------------------------------------------------------+ 
int start()
  {
  //----       
if (Bars<AMA_Period+nfast)return(0);
double noise,AMA,signal,ER,NR,NRG,Price,Resalt;
//----+        
int limit,reset,MaxBar,bar,Length,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-AMA_Period-nfast;
bar=Bars-counted_bars-1; 
if(limit>MaxBar)limit=MaxBar;
limit=bar;
//----  
while (bar>=0)
     {
      //----     ER
      noise=Point/100000;
      for(int jj=0;jj<AMA_Period;jj++)
                noise=noise+MathAbs(PriceSeries(Input_Price_Customs,bar+jj)-PriceSeries(Input_Price_Customs,bar+jj+1));
      signal=MathAbs(PriceSeries(Input_Price_Customs,bar)-PriceSeries(Input_Price_Customs,bar+AMA_Period));
      ER=signal/noise;
      //----   
      NR=1-ER;
      NRG=MathPow(NR, G); 
      Length=nslow+NRG*period_Swing;
      //---- 
      Price=PriceSeries(Input_Price_Customs,bar);
      //----+    JJMASeries   0,  nJMA.Length     (nJMA.din=1)
      Resalt=JJMASeries(0,1,MaxBar,limit,Phase,Length,Price,bar,reset);
      //----+       
      if(reset!=0)return(-1);
      JkAMAbuffer[bar]=Resalt;
      bar--;
     }
//----
   return(0);
  }
//+-----------------------------------------------------+

