/*
          
JJMASeries.mqh 
 PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                                J2JMA_Channel.mq4 | 
//|                           Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Red
#property indicator_color2 Gray
#property indicator_color3 Gray
//----   
#property indicator_style1 0
#property indicator_style2 4
#property indicator_style3 4
//----    --------------------------------------------------------------------------------------------------+
extern int  Channel_width = 100; //    
extern int        Length1 = 3;   //    
extern int        Phase1  = 100; // ,    -100 ... +100,        
extern int        Length2 = 3;   //    
extern int        Phase2  = 100; // ,    -100 ... +100,         
extern int         Shift  = 0;   // c     
extern int Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double J2JMA[];
double UpperBuffer[];
double LowerBuffer[];
//----     
double Half_Width;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+   
//| J2JMA_Channel initialization function                            |
//+------------------------------------------------------------------+ 
int init() 
{ 
//----    
SetIndexStyle (0,DRAW_LINE);
SetIndexStyle (1,DRAW_LINE);
SetIndexStyle (2,DRAW_LINE); 
//---- 3     
SetIndexBuffer(0,J2JMA);  
SetIndexBuffer(1,UpperBuffer); 
SetIndexBuffer(2,LowerBuffer);
//----   ,      
SetIndexEmptyValue(0,0.0);  
SetIndexEmptyValue(1,0.0); 
SetIndexEmptyValue(2,0.0); 
//----    
SetIndexShift (0, Shift); 
SetIndexShift (1, Shift); 
SetIndexShift (2, Shift); 
//----+      JJMASeries, nJMAnumber=2(    JJMASeries)
if (JJMASeriesResize(2)!=2)return(-1);
//----       
JJMASeriesAlert (0,"Length1",Length1);
JJMASeriesAlert (0,"Length2",Length2);
JJMASeriesAlert (1,"Phase1", Phase1 );
JJMASeriesAlert (1,"Phase1", Phase1 );
JJMASeriesAlert (1,"Phase2", Phase2 );
JJMASeriesAlert (1,"Phase2", Phase2 );
PriceSeriesAlert(Input_Price_Customs);
//----   ,       
int draw_begin=50; 
SetIndexDrawBegin(0,draw_begin);
SetIndexDrawBegin(1,draw_begin);
SetIndexDrawBegin(2,draw_begin); 
//----    
Half_Width = Channel_width*Point/2;
//----     
IndicatorDigits(Digits);
//----  
return(0); 
}
//+------------------------------------------------------------------+ 
//| J2JMA_Channel iteration function                                 |
//+------------------------------------------------------------------+  
int start() 
{ 
//----       
if(Bars-1<=30+30) return(0);
//----+      
double Series,Resalt,Price,JSeries,JJSeries;
//----+        
int reset,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1; int limit=MaxBar-counted_bars;

//----+     
for(int bar=limit;bar>=0;bar--)
  {
    //----+    PriceSeries     Series
    Price=PriceSeries(Input_Price_Customs, bar);
    //----+    JJMASeries   0.  nJMA.Phase  nJMA.Length      (nJMA.din=0)
    JSeries=JJMASeries(0,0,MaxBar,limit,Phase1,Length1,Price,bar,reset);
    //----+       
    if(reset!=0)return(-1);
    //----+    JJMASeries   1.  nJMA.Phase  nJMA.Length      (nJMA.din=0)
    JJSeries=JJMASeries(1,0,MaxBar,limit,Phase2,Length2,JSeries,bar,reset);
    //----+       
    if(reset!=0)return(-1);
    
    J2JMA[bar]=JJSeries;
   //----+  
   UpperBuffer[bar]=JJSeries+Half_Width;     
   LowerBuffer[bar]=JJSeries-Half_Width;
   //----            
  }
return(0); 
} 
//+-------------------------------------------------------+