/*
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
//Version  July 1, 2006                                              |
Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru        |
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
*/ 
//+------------------------------------------------------------------+
//|                                            PriceChannel_Stop.mq4 | 
//|                           Copyright  2005, TrendLaboratory Ltd. | 
//|                                       E-mail: igorad2004@list.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2005, TrendLaboratory Ltd." 
#property link "E-mail: igorad2004@list.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 6 
//----  
#property indicator_color1 Yellow 
#property indicator_color2 Magenta
#property indicator_color3 Lime 
#property indicator_color4 Red 
#property indicator_color5 Lime 
#property indicator_color6 Red  
//----   
#property indicator_width1 0
#property indicator_width2 0
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width5 0
#property indicator_width6 0
//----    + 
extern int ChannelPeriod=5; 
extern double       Risk=0.10; 
extern bool       Signal=true;
extern bool        Line =true; 
//---- +
//----  
double UpTrendBuffer  []; 
double DownTrendBuffer[]; 
double UpTrendSignal  []; 
double DownTrendSignal[]; 
double UpTrendLine    []; 
double DownTrendLine  [];  
//+------------------------------------------------------------------+
//| PriceChannel_Stop initialization function                        | 
//+------------------------------------------------------------------+
int init() 
{ 
string short_name; 
//---- 6     
SetIndexBuffer(0,UpTrendBuffer); 
SetIndexBuffer(1,DownTrendBuffer); 
SetIndexBuffer(2,UpTrendSignal); 
SetIndexBuffer(3,DownTrendSignal); 
SetIndexBuffer(4,UpTrendLine); 
SetIndexBuffer(5,DownTrendLine); 
//----   
SetIndexStyle(0,DRAW_ARROW); 
SetIndexStyle(1,DRAW_ARROW); 
SetIndexStyle(2,DRAW_ARROW); 
SetIndexStyle(3,DRAW_ARROW); 
SetIndexStyle(4,DRAW_LINE); 
SetIndexStyle(5,DRAW_LINE); 
SetIndexArrow(0,159); 
SetIndexArrow(1,159); 
SetIndexArrow(2,108); 
SetIndexArrow(3,108); 
//----   ,      
SetIndexEmptyValue(0,0.0);
SetIndexEmptyValue(1,0.0);
SetIndexEmptyValue(2,0.0);
SetIndexEmptyValue(3,0.0);
SetIndexEmptyValue(4,0.0);
SetIndexEmptyValue(5,0.0);
//----        
short_name="PriceChannel_Stop_v1("+ChannelPeriod+")"; 
IndicatorShortName(short_name); 
SetIndexLabel(0,"UpTrend Stop"); 
SetIndexLabel(1,"DownTrend Stop"); 
SetIndexLabel(2,"UpTrend Signal"); 
SetIndexLabel(3,"DownTrend Signal"); 
SetIndexLabel(4,"UpTrend Line"); 
SetIndexLabel(5,"DownTrend Line"); 
//----   ,       
SetIndexDrawBegin(0,ChannelPeriod); 
SetIndexDrawBegin(1,ChannelPeriod); 
SetIndexDrawBegin(2,ChannelPeriod); 
SetIndexDrawBegin(3,ChannelPeriod); 
SetIndexDrawBegin(4,ChannelPeriod); 
SetIndexDrawBegin(5,ChannelPeriod); 
//----    (    )      
IndicatorDigits(Digits);
//----  
return(0); 
}
//+------------------------------------------------------------------+
//| PriceChannel_Stop                                                | 
//+------------------------------------------------------------------+
int start() 
{ 
//----       
if (Bars-1<ChannelPeriod+1)return(0);
//----+     
double bsmax[1],bsmin[1],high,low,price,dprice; 
//----     
static int time2,TREND;static double BSMAX,BSMIN;
//----+        
int trend,MaxBar,bar,limit,ii,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-1-ChannelPeriod-1;
limit=Bars-counted_bars-1; 
//----  
if (limit>MaxBar)
      {
       for (bar=limit;bar>=MaxBar;bar--) 
        { 
         UpTrendBuffer  [bar]=0.0; 
         DownTrendBuffer[bar]=0.0; 
         UpTrendSignal  [bar]=0.0; 
         DownTrendSignal[bar]=0.0; 
         UpTrendLine    [bar]=0.0; 
         DownTrendLine  [bar]=0.0; 
        } 
       limit=MaxBar;
      }
//----     
if(ArrayResize(bsmax,limit+2)!=limit+2)return(-1);
if(ArrayResize(bsmin,limit+2)!=limit+2)return(-1);
//----      
for (bar=limit;bar>=0;bar--) 
  { 
   high=High[bar]; 
   low =Low [bar]; 
   ii=bar-1+ChannelPeriod; 
   while(ii>=bar) 
    { 
     price=High[ii]; 
     if(high<price)high=price; 
     price=Low[ii]; 
     if(low>price) low=price; 
     ii--; 
    } 
  dprice=(high-low)*Risk;
  bsmax[bar]=high-dprice; 
  bsmin[bar]=low +dprice;
 }
//----
int Tnew=Time[limit+1];
//+---    +======+
if (limit<MaxBar)
  if (Tnew==time2)
   {
     bsmax[limit+1]=BSMAX;
     bsmin[limit+1]=BSMIN;
     trend=TREND;
   } 
  else 
   {
    if (Tnew>time2)Print("  . Tnew>time2");
              else Print("  . Tnew<time2");
    Print("      ");
    return(-1); 
   }
//+--- +==========================================+

//----    
for (bar=limit;bar>=0;bar--) 
 { 
  //+---    +====+ 
   if (bar==1)
    {
     if(((limit==1)&&(time2==Time[2]))||(limit>1))
       {
         time2=Time [2];
         BSMAX=bsmax[2]; 
         BSMIN=bsmin[2];
         TREND=trend;
       }
    }
  //+---+====================================+     
   //----
   UpTrendBuffer  [bar]=0.0; 
   DownTrendBuffer[bar]=0.0; 
   UpTrendSignal  [bar]=0.0; 
   DownTrendSignal[bar]=0.0; 
   UpTrendLine    [bar]=0.0; 
   DownTrendLine  [bar]=0.0; 
   //----
  if (Close[bar]>bsmax[bar+1])trend= 1; 
  if (Close[bar]<bsmin[bar+1])trend=-1; 
  //----
  if(trend>0 && bsmin[bar]<bsmin[bar+1]) bsmin[bar]=bsmin[bar+1]; 
  if(trend<0 && bsmax[bar]>bsmax[bar+1]) bsmax[bar]=bsmax[bar+1]; 
  //---- +++
  if (trend>0) 
   { 
     price=bsmin[bar];
    if (Signal==true && DownTrendBuffer[bar+1]>0) 
     { 
      UpTrendSignal[bar]=price; 
      if(Line==true) UpTrendLine[bar]=price; 
     } 
    else 
     { 
      UpTrendBuffer[bar]=price; 
      if(Line==true) UpTrendLine[bar]=price; 
     }
  }  
 //---- +++
 if (trend<0) 
  { 
   price=bsmax[bar];
   if (Signal==true && UpTrendBuffer[bar+1]>0) 
    { 
     DownTrendSignal[bar]=price;
     if(Line==true) DownTrendLine[bar]=price; 
    } 
   else 
    { 
     DownTrendBuffer[bar]=price;
     if(Line==true) DownTrendLine[bar]=price;
    } 
  } 
  //---- +++
 } 
//----
return(0); 
}
//+------------------------------------------------------------------+

