//   17.06.2006   
/*
          
INDICATOR_COUNTED.mqh
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\
*/
//+------------------------------------------------------------------+
//|                                                          KAMA.mq4|
//|                                                                  |
//|                                            GOODMAN & Mstera  AF |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, by GOODMAN & Mstera  AF "
#property link      ""
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----     
#property indicator_color1 Gray
#property indicator_color2 Lime
#property indicator_color3 Red
//----   
#property indicator_width1 4
#property indicator_width2 2
#property indicator_width3 2
//----    --------------------------------------------------------------------------------------------------+
extern int      AMA_period = 10;
extern int   Filter_period = 5;
extern int           nfast = 2;
extern int           nslow = 30;
extern double            G = 1.2;
extern int              Kf = 10;
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double kAMAbuffer     [];
double DAMAbuffer     [];
double UpTrendSignal  []; 
double DownTrendSignal[]; 
//----
double dSC,slowSC,fastSC;
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| KAMA initialization function                                     |
//+------------------------------------------------------------------+
int init()
  {
//----   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_ARROW); 
   SetIndexStyle(2,DRAW_ARROW);      
   SetIndexArrow(1,159); 
   SetIndexArrow(2,159); 
//---- 4     
   IndicatorBuffers(4); 
   SetIndexBuffer(0,kAMAbuffer); 
   SetIndexBuffer(1,UpTrendSignal); 
   SetIndexBuffer(2,DownTrendSignal); 
   SetIndexBuffer(3,DAMAbuffer);  
//----   ,      
   SetIndexEmptyValue(0,0.0); 
   SetIndexEmptyValue(1,0.0); 
   SetIndexEmptyValue(2,0.0);   
//----        
   PriceSeriesAlert(Input_Price_Customs);
//----    
   slowSC=(2.0 /(nslow+1));
   fastSC=(2.0 /(nfast+1)); 
   dSC=fastSC-slowSC; 
//----    (    )      
IndicatorDigits(Digits);
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| AMA iteration function                                           |
//+------------------------------------------------------------------+
int start()
  {
  //----       
if (Bars<nslow+2)return(0);
//----+     
double noise,AMA,AMA1,signal,ER,ERSC,SSC,Resalt,price0,price1,Filter,lowestAMA,highestAMA;
//----+        
int highestbar,lowestbar,limit,MaxBar,MaxBarF,bar,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-nslow-2;
MaxBarF=MaxBar-Filter_period-1;
limit=Bars-counted_bars-1; 
//----  
if (limit>=MaxBar)
      {
       for (int ii=Bars-1; ii>MaxBar;ii--)kAMAbuffer[ii]=0.0;
       limit=MaxBar;
       AMA1=PriceSeries(Input_Price_Customs,limit + 1);
      }
else AMA1=kAMAbuffer[limit+1];
//----    AMA
for (bar=limit;bar>=0;bar--)
     {
      noise=Point/100000;
      for(int jj=0;jj<AMA_period;jj++)
         {
          price0=PriceSeries(Input_Price_Customs,bar+jj+0);
          price1=PriceSeries(Input_Price_Customs,bar+jj+1);
          noise=noise+MathAbs(price0-price1);
         }
      price0=PriceSeries(Input_Price_Customs,bar);
      price1=PriceSeries(Input_Price_Customs,bar+AMA_period);                         
      signal=MathAbs(price0-price1);
      ER =signal/noise;
      ERSC=ER*dSC;
      SSC=ERSC+slowSC;
      AMA=AMA1+(MathPow(SSC,G)*(Close[bar]-AMA1));
      kAMAbuffer[bar]=AMA;  
      DAMAbuffer[bar]=AMA-AMA1;  
      AMA1=AMA;
     }
//----

if (Bars<nslow+2+Filter_period)return(0);    
if (limit>MaxBarF)
      {
       limit=MaxBarF;
       for (bar=Bars-1; bar>MaxBarF;bar--)
        {
         UpTrendSignal[bar]=0;
         DownTrendSignal[bar]=0;
        }
      }
//----          
for (bar=limit;bar>=0;bar--)
    {  
      UpTrendSignal[bar]=0;
      DownTrendSignal[bar]=0;  
      Filter=0.01*Kf*iStdDevOnArray(DAMAbuffer,0,Filter_period,0,MODE_EMA,bar);
      lowestbar =ArrayMinimum(kAMAbuffer, Filter_period, bar); 
      highestbar=ArrayMaximum(kAMAbuffer, Filter_period, bar); 
      lowestAMA=kAMAbuffer[lowestbar];
      highestAMA=kAMAbuffer[highestbar];
      AMA=kAMAbuffer[bar];
      if (AMA-lowestAMA >Filter)UpTrendSignal[bar]=AMA;
      if (highestAMA-AMA>Filter)DownTrendSignal[bar]=AMA;
    }   
//----
   return(0);
  }
//+----------------------------------------------------------+

