//+------------------------------------------------------------------+
//|                                            FractalChannel_v1.mq4 |
//|                           Copyright  2005, TrendLaboratory Ltd. |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "E-mail: igorad2004@list.ru"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Lime 
#property indicator_color2 Red
#property indicator_color3 Aqua
//----   
#property indicator_style1 4
#property indicator_style2 4
#property indicator_style3 4
//----    
extern int    ChannelType=1;
extern double Margins=0;
extern double Advance=0;
extern int    OpenClose=0;
//----  
double UpBuffer[];
double DnBuffer[];
double MdBuffer[];
//----      
double	Low0,Low1,Low2,Low3,Low4,Low5,Low6;
double   High0,High1,High2,High3,High4,High5,High6,v1,v2,smax,smin;			
//+------------------------------------------------------------------+
//| FractalChannel_v1 initialization function                        | 
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//----    
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
//---- 3     . 
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   SetIndexBuffer(2,MdBuffer);
//----        .
   short_name="Fractal Channel("+ChannelType+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"Up Channel");
   SetIndexLabel(1,"Down Channel");
   SetIndexLabel(2,"Middle Channel");
//----   ,       
   SetIndexDrawBegin(0,2*ChannelType);
   SetIndexDrawBegin(1,2*ChannelType);
   SetIndexDrawBegin(2,2*ChannelType);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| FractalChannel_v1  iteration function                            | 
//+------------------------------------------------------------------+
int start()
{

//----       
if(Bars-1<2*ChannelType) return(0);
//----+        
int bar,MaxBar,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  JJMASeries   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;MaxBar=Bars-1-2*ChannelType;if (limit>MaxBar)limit=MaxBar;

for (bar=limit;bar>=0;bar--)	
	{
	v1=-1;
	v2=-1;
	
	High0=High[bar];
	High1=High[bar+1];
	High2=High[bar+2];
	High3=High[bar+3];
	High4=High[bar+4];
	High5=High[bar+5];
	High6=High[bar+6];
	
	Low0=Low[bar];
	Low1=Low[bar+1];
	Low2=Low[bar+2];
	Low3=Low[bar+3];
	Low4=Low[bar+4];
	Low5=Low[bar+5];
	Low6=Low[bar+6];
	
	if (OpenClose>0) 
	{
	High0=MathMax(Close[bar],Open[bar]);
	High1=MathMax(Close[bar+1],Open[bar+1]);
	High2=MathMax(Close[bar+2],Open[bar+2]);
	High3=MathMax(Close[bar+3],Open[bar+3]);
	High4=MathMax(Close[bar+4],Open[bar+4]);
	High5=MathMax(Close[bar+5],Open[bar+5]);
	High6=MathMax(Close[bar+6],Open[bar+6]);
	
	Low0=MathMin(Close[bar],Open[bar]);
	Low1=MathMin(Close[bar+1],Open[bar+1]);
	Low2=MathMin(Close[bar+2],Open[bar+2]);
	Low3=MathMin(Close[bar+3],Open[bar+3]);
	Low4=MathMin(Close[bar+4],Open[bar+4]);
	Low5=MathMin(Close[bar+5],Open[bar+5]);
	Low6=MathMin(Close[bar+6],Open[bar+6]);
	}
	
	
	
	if (ChannelType==1)  
	{		
	if (High2<=High1 && High0<High1) v1=High1;
	if (Low2>=Low1 && Low0>Low1) v2=Low1;
	}	
	
	if (ChannelType==2) 
	{	
	if (High4<=High2 && High3<=High2 && High0<High2 && High1<High2) 
	v1=High2;
	if (Low4>=Low2 && Low3>=Low2 && Low0>Low2 && Low1>Low2)  
	v2=Low2;
	}
	
	if (ChannelType==3)
	{	
	if (High6<=High3 && High5<=High3 && High4<=High3 && 
	High0<High3 && High1<High3 && High2<High3) 
	v1=High3;
	if (Low6>=Low3 && Low5>=Low3 && Low4>=Low3 && 
	Low0>Low3 && Low1>Low3 && Low2>Low3) 
	v2=Low3;
	}
			
	if ( v1>0 ) smax=v1; 
	if (High0>smax) smax=High0;
	
	if ( v2>0 ) smin=v2; 
	if (Low0<smin) smin=Low0;
	
	if (bar==Bars-1-2*ChannelType) {smin=Low0;smax=High0;}
	
	UpBuffer[bar]=smax-(smax-smin)*Margins;
	DnBuffer[bar]=smin+(smax-smin)*Margins;
	MdBuffer[bar]=(UpBuffer[bar]+DnBuffer[bar])/2;
	}
return(0);
}
//+-------------------------------------------------------------------------+