/*
          
PriceSeries.mqh 
GetDigVelue.mqh
  (): MetaTrader\experts\include\
*/
//+------------------------------------------------------------------+
//|                                            DigBollingerBands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Lime
#property indicator_color2 Gray
#property indicator_color3 Red
//----   Bollinger Bands
#property indicator_style1 4
#property indicator_style2 4
#property indicator_style3 4
//----    --------------------------------------------------------------------------------------------------+
extern int        Bands_Period = 200; //    J2Bollinger Bands
extern double Bands_Deviations = 2.0; //  
extern int           MA_method = 0;   //  
extern int             MA_Step = 6; // ,          
extern int          Bands_Step = 6; // ,           
extern int         Bands_Shift = 0;   // c     
extern int Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double UpperBuffer[];
double LowerBuffer[];
double MovingBuffer[];
double VelueBuffer[];
//----      
double MA_Norma,Bands_Norma;
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//----+   GetDigVelue
#include <GetDigVelue.mqh>
//+------------------------------------------------------------------+ 
//| DigBollingerBands initialization function                        | 
//+------------------------------------------------------------------+
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexStyle(1,DRAW_LINE);
//---- 4     
   IndicatorBuffers(4); 
   SetIndexBuffer(0,UpperBuffer );  
   SetIndexBuffer(1,MovingBuffer);
   SetIndexBuffer(2,LowerBuffer );
   SetIndexBuffer(3,VelueBuffer);
//----   ,       
   int drawbegin=Bands_Period+Bands_Shift; 
   SetIndexDrawBegin(0,drawbegin);
   SetIndexDrawBegin(1,drawbegin);
   SetIndexDrawBegin(2,drawbegin);
//----      
   SetIndexShift (0, Bands_Shift); 
   SetIndexShift (1, Bands_Shift); 
   SetIndexShift (2, Bands_Shift); 
//----        . 
   IndicatorShortName ("Bollinger Bands( Period="+Bands_Period+", Deviations="+Bands_Deviations+")"); 
   SetIndexLabel (0, "Upper Bands, Deviations=+"+Bands_Deviations+""); 
   SetIndexLabel (2, "Lower Bands, Deviations=-"+Bands_Deviations+""); 
   string JMoving;
   switch(MA_method)
           {
            case  0: JMoving="JSMA"; break;
            case  1: JMoving="JEMA"; break;
            case  2: JMoving="JSSMA";break;
            case  3: JMoving="JLWMA";break;
            default: JMoving="JSMA";
           }
    SetIndexLabel (1, "JMoving Avereges "+JMoving+" ("+Bands_Period+")");
//----          
//----        ======================================================================================+ 
if(Bands_Period<1)   {Alert(" Bands_Period     1 "+ "    " +Bands_Period+ "    1");}//////////|
if(MA_method<0)      {Alert(" MA_method    0  3"   + "    " +MA_method+ "   0");}////////////////|
if(MA_method>3)      {Alert(" MA_method    0  3"   + "    " +MA_method+ "   0");}////////////////|
PriceSeriesAlert(Input_Price_Customs);//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////|
//+========================================================================================================================================================+ 
//----     Bands_Period
if(Bands_Period<1)Bands_Period=1; 
//----  
MA_Norma=MA_Step*Point;
Bands_Norma=Bands_Step*Point;
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//| DigBollingerBands iteration function                             | 
//+------------------------------------------------------------------+
int start()
  {
//----       
if(Bars<=Bands_Period) return(0);
//----+     
double sum,midline,Velue,priceswing,deviation;
//----+        
int bar,kk,MaxBarBB,limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
limit=Bars-counted_bars-1; MaxBarBB=Bars-1-Bands_Period;
//----+              
for(bar=limit;bar>=0;bar--)VelueBuffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
if (limit>MaxBarBB)limit=MaxBarBB;

for(bar=limit;bar>=0;bar--)
     {
      //----+    Moving Avereges
      midline=iMAOnArray(VelueBuffer,0,Bands_Period,0,MA_method, bar);
      MovingBuffer[bar]=GetDigVelue(MA_Norma,midline);
      
      //---- ר Bollinger Bands
      sum=0.0;
      kk=bar+Bands_Period-1;
      while(kk>=bar)
        {
         priceswing=PriceSeries(Input_Price_Customs,kk)-midline;
         sum+=priceswing*priceswing;
         kk--;
        }
      deviation=Bands_Deviations*MathSqrt(sum/Bands_Period);
      //----
      UpperBuffer[bar]=GetDigVelue(Bands_Norma,midline+deviation);
      //----
      LowerBuffer[bar]=GetDigVelue(Bands_Norma,midline-deviation);
      //----
    }
//----
   return(0);
  }
//+-----------------------------------------------------------+

