//+------------------------------------------------------------------+  
//|                                              Aroon_Oscilator.mq4 | 
//|                             Copyright  2006,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property  indicator_separate_window
//----   
#property  indicator_buffers 4
#property  indicator_color1  BlueViolet
#property  indicator_color2  Blue
#property  indicator_color3  Red
#property  indicator_color4  LightSlateGray
//----    
extern int Aroon_Period=10;
extern int Filter=50;
//---- +--------------------------+
//----  
double ind_buffer1[];
double ind_buffer2[];
double ind_buffer3[];
double ArOscBuffer[];
//+------------------------------------------------------------------+ 
//| Aroon_Oscilator initialization function                          |
//+------------------------------------------------------------------+ 
int init()
  {
   //----   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID);
   //----    
   SetLevelStyle(4,0,Gold);
   SetLevelValue(0,0);
   //----    (    )     
   IndicatorDigits(0);
   //----   ,       
   SetIndexDrawBegin(0,Aroon_Period+1);
   SetIndexDrawBegin(1,Aroon_Period+1);
   SetIndexDrawBegin(2,Aroon_Period+1);
   SetIndexDrawBegin(3,Aroon_Period+1);
   //---- 4     
   if
    (
     !SetIndexBuffer(0,ArOscBuffer)&& 
     !SetIndexBuffer(1,ind_buffer1)&& 
     !SetIndexBuffer(2,ind_buffer2)&& 
     !SetIndexBuffer(3,ind_buffer3)
    )
    {
     Print("   !");
     return(0);
    }
   //----        
   IndicatorShortName("Aroon Osc(Aroon_Period="+Aroon_Period+", Filter="+Filter+")");
   SetIndexLabel(0,"Aroon Osc");
   SetIndexLabel(1,"UP_Trend");
   SetIndexLabel(2,"DOWN_Trend");
   SetIndexLabel(3,"Flat");
   //----    Aroon_Period
   if(Aroon_Period<1) Aroon_Period=1;
   //----  
   return(0);
  }
//+------------------------------------------------------------------+ 
//| Aroon_Oscilator iteration function                               |
//+------------------------------------------------------------------+ 
int start()
  {
   int MaxBar=Bars-Aroon_Period-1;
   //----       
   if (MaxBar<0)return(0);
   //----+     
   double ArOsc;
   //----+         
   int limit,bar,highest,lowest,counted_bars=IndicatorCounted();  
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----     ,        
   limit=Bars-counted_bars-1; 
   //----     
   if(limit>MaxBar)
     {
      limit=MaxBar;
      for(bar=Bars-1;bar>=MaxBar;bar--) 
       {
        ArOscBuffer[bar]=0.0;
        ind_buffer1[bar]=0.0;
        ind_buffer2[bar]=0.0;
        ind_buffer3[bar]=0.0;
       }
     } 
   //----    
   for( bar=limit; bar>=0; bar--)
   {
  	   highest = Highest(NULL,0,MODE_HIGH,Aroon_Period,bar);  
  	   lowest  = Lowest (NULL,0,MODE_LOW, Aroon_Period,bar);	
      //----
  	   ArOscBuffer[bar]= 100*(lowest-highest)/Aroon_Period;		
      //----
      ind_buffer1[bar]=0.0;
      ind_buffer2[bar]=0.0;
      ind_buffer3[bar]=0.0;
      //----    
      ArOsc=ArOscBuffer[bar];
      //----
      if(ArOsc> Filter)ind_buffer1[bar]=ArOsc; else
      if(ArOsc<-Filter)ind_buffer2[bar]=ArOsc; else
      ind_buffer3[bar]=ArOsc; 
   }
   //---- done
   return(0);
  }
//+------------------------------------------------------------+ 