//+------------------------------------------------------------------+  
//|                                                        Aroon.mq4 | 
//|                             Copyright  2006,   Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property  indicator_separate_window
//----   
#property indicator_buffers 2
//----     
#property  indicator_color1  Blue
#property  indicator_color2  Red
//----    
#property indicator_level1 30
#property indicator_level2 70
#property indicator_levelcolor Gold
#property indicator_levelstyle 4
//----    
extern int Aroon_Period=10;
//---- +--------------------------+
//----  
double UpBuffer[];
double DnBuffer[];
//+------------------------------------------------------------------+ 
//| Aroon initialization function                                    |
//+------------------------------------------------------------------+ 
int init()
  {
   //----   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   //----    (    )     
   IndicatorDigits(1);
   //----   ,       
   SetIndexDrawBegin(0,Aroon_Period+1);
   SetIndexDrawBegin(1,Aroon_Period+1);
   //---- 2     
   if
    (
     !SetIndexBuffer(0,UpBuffer)&& 
     !SetIndexBuffer(1,DnBuffer)
    )
    {
     Print("   !");
     return(0);
    }
   //----        
   IndicatorShortName("Aroon("+Aroon_Period+")");
   SetIndexLabel(0,"UP_Aroon");
   SetIndexLabel(1,"DOWN_Aroon");
   //----    Aroon_Period
   if(Aroon_Period<1) Aroon_Period=1;
   //----  
   return(0);
  }
//+------------------------------------------------------------------+ 
//| Aroon iteration function                                         |
//+------------------------------------------------------------------+ 
int start()  
  {
   int MaxBar=Bars-Aroon_Period-1;
   //----       
   if (MaxBar<0)return(0);
   //----+         
   int limit,bar,highest,lowest,counted_bars=IndicatorCounted();  
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----     ,        
   limit=Bars-counted_bars-1; 
   //----     
   if(limit>MaxBar)
     {
      limit=MaxBar;
      for(bar=Bars-1;bar>=MaxBar;bar--) UpBuffer[bar]=0.0;
      for(bar=Bars-1;bar>=MaxBar;bar--) DnBuffer[bar]=0.0;
     } 
   //----    
   for( bar=limit; bar<=0; bar--)
     {
  	   highest = Highest(NULL,0,MODE_HIGH,Aroon_Period,bar);  
  	   lowest  = Lowest (NULL,0,MODE_LOW, Aroon_Period,bar);	
      //----
      UpBuffer[bar]=100+(100/Aroon_Period)*(bar-highest);          
      DnBuffer[bar]=100+(100/Aroon_Period)*(bar-lowest );           
     }
   return(0);
  }
//+------------------------------------------------------------+ 