//++
//|                                                   Aroon Horn.mq4 |
//|                                                tonyc2a@yahoo.com |
//++
#property copyright "tonyc2a@yahoo.com"
#property link      "mailto:tonyc2a@yahoo.com"
//----     
#property  indicator_separate_window
//----   
#property indicator_buffers 2
//----     
#property  indicator_color1  Blue
#property  indicator_color2  Red
//----    
#property indicator_level1 30
#property indicator_level2 70
#property indicator_levelcolor Gold
#property indicator_levelstyle 4
//----   
extern int Aroon_Period=10;
//----  
double UpBuffer[];
double DnBuffer[];
//++
//| Aroon Horn initialization function                               |
//++
int init()
  {
   //----   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   //----    (    )     
   //IndicatorDigits(1);
   //----   ,       
   SetIndexDrawBegin(0,Aroon_Period+1);
   SetIndexDrawBegin(1,Aroon_Period+1);
   //---- 2     
   SetIndexBuffer(0,UpBuffer);
   SetIndexBuffer(1,DnBuffer);
   //----        
   IndicatorShortName("Aroon("+Aroon_Period+")");
   SetIndexLabel(0,"UP_Aroon");
   SetIndexLabel(1,"DOWN_Aroon");
   //----    Aroon_Period
   if(Aroon_Period<1) Aroon_Period=1;
   //----  
   return(0);
  }
//++
//| Aroon Horn iteration function                                    |
//++
int start()
  {
   //----     ,        
   int MaxBar=Bars-Aroon_Period-1; 
   //----       
   if (MaxBar<0)return(0);
   //----+ 
   double HighestBar,LowestBar,aroonUp,aroonDn;
   //----+         
   int limit,bar,counted_bars=IndicatorCounted();  
   //----    
   if (counted_bars<0)return(-1);
   //----      
   if (counted_bars>0) counted_bars--;
   //----     ,        
   limit=Bars-counted_bars-1; 
   //----     
   if(limit>MaxBar)
     {
      limit=MaxBar;
      for(bar=Bars-1;bar>=MaxBar;bar--) UpBuffer[bar]=0.0;
      for(bar=Bars-1;bar>=MaxBar;bar--) DnBuffer[bar]=0.0;
     } 
   //----    
   for( bar=limit; bar>=0; bar--)
    {
      HighestBar = iHighest(NULL,0,MODE_HIGH,Aroon_Period-1,bar);
      LowestBar  = iLowest (NULL,0,MODE_LOW, Aroon_Period-1,bar);
      //----
      aroonUp = 100.0 - ((HighestBar - bar) / Aroon_Period) * 100.0;
      aroonDn = 100.0 - ((LowestBar  - bar) / Aroon_Period) * 100.0;  
      //----
      if(aroonUp == 0.0) { aroonUp = 0.0000001; }
      if(aroonDn == 0.0) { aroonDn = 0.0000001; }
      //----
      UpBuffer[bar]=aroonUp;
      DnBuffer[bar]=aroonDn;  
    }   
//----
   return(0);
  }
//+------------------------------------------------------------------+