//   1.07.2006   
/*
          
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\
*/
//+------------------------------------------------------------------+
//|                                                           AMA.mq4|
//|                                                                  |
//|                                            GOODMAN & Mstera  AF |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, by GOODMAN & Mstera  AF "
#property link      ""
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1
//----     
#property indicator_color1 Red
//---- input parameters
//----    --------------------------------------------------------------------------------------------------+
extern int   periodAMA = 9; // AMA
extern int       nfast = 2; //  
extern int       nslow = 30; //  
extern double        G = 2.0; // ,     
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//---- buffers
double kAMAbuffer[];
//----+      
double dSC,slowSC,fastSC;
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//|  AMA initialization function                                     |
//+------------------------------------------------------------------+
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE);
//---- 1     
   SetIndexBuffer(0,kAMAbuffer); 
//----        
   PriceSeriesAlert(Input_Price_Customs);
//----   
   slowSC=(2.0 /(nslow+1));
   fastSC=(2.0 /(nfast+1)); 
   dSC=fastSC-slowSC; 
//----     
   IndicatorDigits(Digits);
//----        
   IndicatorShortName ("AMA( periodAMA="+periodAMA+")"); 
   SetIndexLabel (0, "AMA");
//----  
   return(0);
  }
//+------------------------------------------------------------------+
//|  AMA iteration function                                          |
//+------------------------------------------------------------------+
int start()
  {
  //----       
if (Bars<periodAMA+2)return(0);
//----+      
double noise,AMA,signal,ER,ERSC,SSC,price0,price1;
//----+        
int reset,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-periodAMA-2;
bar=Bars-counted_bars-1; 
//----  
if (bar>MaxBar)
      {
       for (int ii=bar; ii>MaxBar;ii--)kAMAbuffer[ii]=0.0;
       bar=MaxBar;
       AMA=PriceSeries(Input_Price_Customs,bar + 1);
      }
else AMA=kAMAbuffer[bar+1];
//----  
while (bar>=0)
     {
      noise=Point/100000;
      for(int jj=0;jj<periodAMA;jj++)
                {
                 price0=PriceSeries(Input_Price_Customs,bar+jj+0);
                 price1=PriceSeries(Input_Price_Customs,bar+jj+1);
                 noise=noise+MathAbs(price0-price1);
                }
      price0=PriceSeries(Input_Price_Customs,bar);
      price1=PriceSeries(Input_Price_Customs,bar+periodAMA);                         
      signal=MathAbs(price0-price1);
      ER =signal/noise;
      ERSC=ER*dSC;
      SSC=ERSC+slowSC;
      AMA=AMA+(MathPow(SSC,G)*(price0-AMA));  
      kAMAbuffer[bar]=AMA;
      bar--;
     }
//----
   return(0);
  }
//+-----------------------------------------------------+

