//Version  July 1, 2006
//+------------------------------------------------------------------+
//|                                                 iPriceSeries.mqh |
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
//  iPriceSeries()      /    niPriceSeries.Bar 
//    iPriceSeries.Input_Price_Customs:
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-iTrendFollow, 10-0.5*iTrendFollow,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close,
// : minuse = iPriceSeries("GBPJPY",240,Input_Price_Customs, bar) - iPriceSeries("GBPJPY",240,Input_Price_Customs, bar+1);
// ;  Momentum = iPriceSeries("GBPJPY",240,Input_Price_Customs, bar) - iPriceSeries("GBPJPY",240,Input_Price_Customs, bar+Momentum_Period); 
  
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//++++++++++++++++++++++++++++++++++++ <<< iPriceSeries >>> ++++++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

double PriceSeries(string siPriceSeries.symbol, int niPriceSeries.timeframe,int niPriceSeries.Input_Price_Customs, int niPriceSeries.Bar)
{
double diPriceSeries; 
switch(iPriceSeries.Input_Price_Customs) 
{
case  0: diPriceSeries = iClose(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case  1: diPriceSeries = iOpen (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case  2: diPriceSeries = iHigh (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case  3: diPriceSeries = iLow  (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case  4: diPriceSeries =(iHigh (siPriceSeries.symbol,nPriceSeries+iLow  (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar))/2;break;
case  5: diPriceSeries =(iClose(siPriceSeries.symbol,nPriceSeries+iHigh (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar)+iLow(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar))/3;break;
case  6: diPriceSeries =(iOpen (siPriceSeries.symbol,nPriceSeries+iHigh (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar)+iLow(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar)+iClose(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar))/4;break;
case  7: diPriceSeries =(iOpen (siPriceSeries.symbol,nPriceSeries+iClose(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar))/2;break;
case  8: diPriceSeries =(iClose(siPriceSeries.symbol,nPriceSeries+iHigh (siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar)+iLow(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar)+iClose(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar))/4;break;
case  9: diPriceSeries = iTrendFollow00(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case 10: diPriceSeries = iTrendFollow01(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);break;
case 11: diPriceSeries = iCustom(siPriceSeries.symbol,niPriceSeries.timeframe,"Heiken Ashi#",0,niPriceSeries.Bar);break;
case 12: diPriceSeries = iCustom(siPriceSeries.symbol,niPriceSeries.timeframe,"Heiken Ashi#",1,niPriceSeries.Bar);break;
case 13: diPriceSeries = iCustom(siPriceSeries.symbol,niPriceSeries.timeframe,"Heiken Ashi#",2,niPriceSeries.Bar);break;
case 14: diPriceSeries = iCustom(siPriceSeries.symbol,niPriceSeries.timeframe,"Heiken Ashi#",3,niPriceSeries.Bar);break;

default: diPriceSeries = iClose(siPriceSeries.symbol,niPriceSeries.timeframe,niPriceSeries.Bar);
}
return(diPriceSeries);
}
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
//----+ ---------------------------------------------------------------------------------------------------+
//----+   iTrendFollow00.  case 9 -------------------------------------------------------+
double iTrendFollow00(string siTrendFollow00.symbol, int niTrendFollow00.timeframe,int niTrendFollow00.Bar)
{
double diTrendFollow00;
double diTrendFollow00.high= iHigh (siTrendFollow00.symbol,niTrendFollow00.timeframe,niTrendFollow00.Bar);
double diTrendFollow00.low=  iLow  (siTrendFollow00.symbol,niTrendFollow00.timeframe,niTrendFollow00.Bar);
double diTrendFollow00.open= iOpen (siTrendFollow00.symbol,niTrendFollow00.timeframe,niTrendFollow00.Bar);
double diTrendFollow00.close=iClose(siTrendFollow00.symbol,niTrendFollow00.timeframe,niTrendFollow00.Bar);

if(diTrendFollow00.close>diTrendFollow00.open)diTrendFollow00 = diTrendFollow00.high;
else
{
if(diTrendFollow00.close<diTrendFollow00.open)diTrendFollow00 = diTrendFollow00.low;
                                         else diTrendFollow00 = diTrendFollow00.close;
}
return(diTrendFollow00);
//----+ ---------------------------------------------------------------------------------------------------+
//----+   iTrendFollow01.  case 10 ------------------------------------------------------+
double iTrendFollow01(string siTrendFollow01.symbol, int niTrendFollow01.timeframe,int niTrendFollow01.Bar)
{
double diTrendFollow01;
double diTrendFollow01.high= iHigh (siTrendFollow01.symbol,niTrendFollow01.timeframe,niTrendFollow01.Bar);
double diTrendFollow01.low=  iLow  (siTrendFollow01.symbol,niTrendFollow01.timeframe,niTrendFollow01.Bar);
double diTrendFollow01.open= iOpen (siTrendFollow01.symbol,niTrendFollow01.timeframe,niTrendFollow01.Bar);
double diTrendFollow01.close=iClose(siTrendFollow01.symbol,niTrendFollow01.timeframe,niTrendFollow01.Bar);

if(diTrendFollow01.close>diTrendFollow01.open)
                         diTrendFollow01 =(diTrendFollow01.high+diTrendFollow01.close)/2;
else
 {
if(diTrendFollow01.close<diTrendFollow01.open)
                         diTrendFollow01 = (diTrendFollow01.low+diTrendFollow01.close)/2;
                    else diTrendFollow01 =  diTrendFollow01.close;
 }
return(diTrendFollow01);
}
//----+ ---------------------------------------------------------------------------------------------------+
//----+   PriceSeriesAlert -------------------------------------------------------+
//  PriceSeriesAlert()             |
// iPriceSeries.Input_Price_Customs    PriceSeries().                       |
//----+ -----------------------------------------------------------------------------------------+
void PriceSeriesAlert(int nPriceSeriesAlert.IPC)
 {
  if(nPriceSeriesAlert.IPC< 0)
          Alert(" Input_Price_Customs      0" 
                    + "    "+nPriceSeriesAlert.IPC+ "   0");
  if(nPriceSeriesAlert.IPC>14)
          Alert(" Input_Price_Customs     14" 
                    + "    "+nPriceSeriesAlert.IPC+ "   0");
 }
//----+ ----------------------------------------------------------------------------------------+