/*
//+------------------------------------------------------------------+ 
//|                                              TrendSignalSupr.mqh | 
//|              TrendSignal: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
##property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 2 
//----  
#property indicator_color1 Magenta
#property indicator_color2 Yellow
*/
//----    ----------------------------------------+
extern int Swing   = 10; //  c   
extern int Shift   = 0; // c      
//---- ---------------------------------------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Vel_Buffer [];
//----
double SWING;
//+------------------------------------------------------------------+ 
//| TrendSignal indicator initialization function                    | 
//+------------------------------------------------------------------+ 
int init() 
{ 
//----    
SetIndexStyle(0,DRAW_ARROW); 
SetIndexStyle(1,DRAW_ARROW); 
SetIndexArrow(0, Simbol1);
SetIndexArrow(1, Simbol2);
//---- 3     
IndicatorBuffers(3);
SetIndexBuffer(0,Ind_Buffer1);
SetIndexBuffer(1,Ind_Buffer2); 
SetIndexBuffer(2,Vel_Buffer); 
//----   
SetIndexShift (0, Shift); 
SetIndexShift (1, Shift); 
//----   ,      
SetIndexEmptyValue(0,EmptyValue); 
SetIndexEmptyValue(1,EmptyValue); 
//----   ,        
int drow_begin=COUNT_begin()+Shift+2;  
SetIndexDrawBegin(0,drow_begin);
SetIndexDrawBegin(1,drow_begin); 
//----        
IndicatorShortName(""+Label+""+"TrendSigmnal");
SetIndexLabel(0,"Up_Trend");
SetIndexLabel(1,"Up_Trend");
//----
IndicatorDigits(digits());
//----  
SWING=Swing*Point;
//----  
return(0); 
} 

//+------------------------------------------------------------------+ 
//| TrendSigmnal iteration function                                  | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----+       
double trend1,trend0,JurX,Error,Price;
//----+        
int reset,MaxBar,limit,bar,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,        
limit=Bars-counted_bars-1; 
MaxBar=Bars-1-COUNT_begin()-2;           
//----      
for(bar=limit; bar>=0; bar--)Vel_Buffer[bar]=INDICATOR(bar);

//----+  
if (limit>MaxBar)   
 {
  for(bar=MaxBar;bar>=MaxBar;bar--)
   {
    Ind_Buffer1[bar]=0;
    Ind_Buffer2[bar]=0;
   }
  limit=MaxBar;
 }  
//----+     
for(bar=limit;bar>=0;bar--)
 { 
 
  Ind_Buffer1[bar]=0;
  Ind_Buffer2[bar]=0; 
   
  trend1=Vel_Buffer[bar+1]-Vel_Buffer[bar+2];
  trend0=Vel_Buffer[bar+0]-Vel_Buffer[bar+1];
  
  if      ((trend1>=0)&&(trend0<0))Ind_Buffer1[bar]=High[bar]+SWING;
  else if ((trend1<=0)&&(trend0>0))Ind_Buffer2[bar]=Low [bar]-SWING;   
 }

//----    
return(0); 
} 
//+------------------------------------------------------------------------+


