//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                               T3Series1(Exp).mqh |
//|                                T3 code: Copyright  1998, Tilson |
//|            MQL4T3Series1: Copyright  2006,     Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  T3Series1() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    T3Series1()          T3      ,   
         .      (): MetaTrader\experts\include\
    ,      nT31.bar ,  nT31.MaxBar-3*nT31.Period,   T3Series1  
    !   ! , ,        -  
    !      T3Series1        
  ,    .    T3Series1()     
      ,                !  
        T3Series1(),       
  nT31....    dT31....        T3Series1()    ,     .
    T3Series1()          ,    
     ,             T3Series1() 
      (nT31.number). 
  
  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nT31.number    -      T3Series1(). (0, 1, 2, 3 ......)
  nT31.din       - ,    nT31.Period   . 0 -   , 
                      - .
  nT31.MaxBar    -   ,        (nT31.bar).   
                   Bars-1-period;  "period" -      ,       dT31.series  
                   ; 
  nT31.limit     -                , 
  nT31.Curvature -     0 ... +100,     ; 
  nT31.Period    -  
  dT31.series    -   ,      T3Series1();
  nT31.bar       -    ,         
                   !            nT31.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  T3Series1()    -   T3.               nT31.bar    nT31.MaxBar-nT31.Length    
                   T3MASeries()   !!!
  nT31.reset     - ,       ,    0,           
                   , 0,        .           ,   
                   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+
  
          T3Series1()          ),    
        ,              T3Series1() 
      T3Series1Resize()      : T3Series1Resize(MaxT3.number+1); 
      nT31.number(MaxT3.number)         T3Series1(),    
  ,   nT31.number. 

  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
             ,        . 
      T3Series1()           \MetaTrader\EXPERTS\LOGS\. ,    
  T3Series1()    ,   ,  MQL4 ,         
    .     T3Series1()   T3Series1()  MQL4 ,  
                    .       
  T3Series1()  nT31.number              nJT3Resize.Size    
              .        
      nT31.limit.          init()    
          T3Series1(),      T3Series1Resize()      
          .      T3Series1()   
            nT31.bar,        
  .  ,            
    ,      T3Series1()          ,      
    .        T3Series1        
        .           
    ,              init().  
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+


//----+   T3Series1 
#include <T3Series1.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1      (    T3Series1()     !!!)
SetIndexBuffer(0,Ind_Buffer);
//----+      T3Series1, nT31.number=1(    T3Series1)
if(T3Series1Resize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    T3Series1   0    Ind_Buffer[], 
  // nT31.Curvature  nT31.Length      (nT31.din=0)
  double Resalt=T3Series1(0,0,MaxBar,limit,Curvature,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 
  */
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< T3Series1 >>> +++++++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double dT31.e1[1],dT31.e2[1],dT31.e3[1],dT31.e4[1],dT31.e5[1],dT31.e6[1];
double dT31.c1[1],dT31.c2[1],dT31.c3[1],dT31.c4[1],dT31.w1[1],dT31.w2[1];
double dT31.n[1],dT31.b2[1],dT31.b3[1],dT31.T3;
int    nT31.Error,nT31.num,nT31.size,nT31.Resize,nT31.Test[1];
//----++ <<<   T3Series1() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double T3Series1
 (
  int nT31.number,    int nT31.din,     int    nT31.MaxBar,      int nT31.limit,
  int nT31.Curvature, int nT31.Period,  double dT31.series,      int nT31.bar,    int& nT31.reset
 )
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nT31.num=nT31.number;

nT31.reset=1;
//=====+ <<<    >>> ==============================================================================+
if (nT31.bar==nT31.limit)
 {
  //----++     T3Series1()
  if(nT31.Resize<1)
   {
    Print("T3Series1 number ="+nT31.num+
         ".         T3Series1Resize()");
    if(nT31.Resize==0)
       Print("T3Series1 number ="+nT31.num+
                ".      T3Series1Resize()   ");
         
    return(0.0);
   }
  //----++       ,   T3Series1()
  nT31.Error=GetLastError();
  if(nT31.Error>4000)
    {
      Print("T3Series1 number ="+nT31.num+
            ".  ,     T3Series1() number = "
                                                                 +nT31.num+" !!!");
      Print("T3Series1 number ="+nT31.num+ ". ",T3_ErrDescr1(nT31.Error));  
    }

  //----++       nT31.number  nT31Resize.Size
  nT31.size=ArraySize(dT31.e1);
  if (nT31.size< nT31.num) 
   {
    Print("T3Series1 number ="+nT31.num+
              ". !!!     nT31.number="
                                                        +nT31.num+"  T3Series1()");
    Print("T3Series1 number ="+nT31.num+
            ".       nT31Resize.Size="
                                                 +nT31.size+"  T3Series1Resize()");
    return(0.0);
   }
 }
//----++ +--------------------------------------------------------------------------------------------------------+

if (nT31.bar>nT31.MaxBar){nT31.reset=0;return(0.0);}
if((nT31.bar==nT31.MaxBar)||(nT31.din!=0))
  {
   //----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   nT31.Test[nT31.num]=1;
   double dT31.b=nT31.Curvature/100.0;
   dT31.b2[nT31.num]=dT31.b*dT31.b;
   dT31.b3[nT31.num]=dT31.b2[nT31.num]*dT31.b;
   dT31.c1[nT31.num]=-dT31.b3[nT31.num];
   dT31.c2[nT31.num]=(3*(dT31.b2[nT31.num]+dT31.b3[nT31.num]));
   dT31.c3[nT31.num]=-3*(2*dT31.b2[nT31.num]+dT31.b+dT31.b3[nT31.num]);
   dT31.c4[nT31.num]=(1+3*dT31.b+dT31.b3[nT31.num]+3*dT31.b2[nT31.num]);
   if (nT31.Period<1) nT31.Period=1;
   dT31.n [nT31.num] = 1 + 0.5*(nT31.Period-1);
   dT31.w1[nT31.num] = 2 / (dT31.n[nT31.num] + 1);
   dT31.w2[nT31.num] = 1 - dT31.w1[nT31.num];
   //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
if (nT31.Period<1)nT31.Period=1;

//----++        nT31.bar
if((nT31.limit>=nT31.MaxBar)&&(nT31.bar==0)&&(nT31.din==0))
      if((nT31.MaxBar>nT31.Period*3)&&(nT31.Test[nT31.num]==0))
                        Print("T3Series1 number ="+nT31.num+
                        ". !!!      nT31.bar   !!!"); 

//---- <<<  dT31.T3 >>> --------------------------------------------------------------------+
dT31.e1[nT31.num] = dT31.w1[nT31.num]*dT31.series       + dT31.w2[nT31.num]*dT31.e1[nT31.num];
dT31.e2[nT31.num] = dT31.w1[nT31.num]*dT31.e1[nT31.num] + dT31.w2[nT31.num]*dT31.e2[nT31.num];
dT31.e3[nT31.num] = dT31.w1[nT31.num]*dT31.e2[nT31.num] + dT31.w2[nT31.num]*dT31.e3[nT31.num];
dT31.e4[nT31.num] = dT31.w1[nT31.num]*dT31.e3[nT31.num] + dT31.w2[nT31.num]*dT31.e4[nT31.num];
dT31.e5[nT31.num] = dT31.w1[nT31.num]*dT31.e4[nT31.num] + dT31.w2[nT31.num]*dT31.e5[nT31.num];
dT31.e6[nT31.num] = dT31.w1[nT31.num]*dT31.e5[nT31.num] + dT31.w2[nT31.num]*dT31.e6[nT31.num];
//----  
dT31.T3 = dT31.c1[nT31.num]*dT31.e6[nT31.num] 
                      + dT31.c2[nT31.num]*dT31.e5[nT31.num] 
                                     + dT31.c3[nT31.num]*dT31.e4[nT31.num] 
                                                   + dT31.c4[nT31.num]*dT31.e3[nT31.num];
//---- -----------------------------------------------------------------------------------------------+

//----++         T3Series1()
nT31.Error=GetLastError();
if(nT31.Error>4000)
  {
    Print("T3Series1 number ="+nT31.num+".    T3Series1()  !!!");
    Print("T3Series1 number ="+nT31.num+ ". ",T3_ErrDescr1(nT31.Error));  
    return(0.0);
  }
nT31.reset=0;
if (nT31.bar<nT31.MaxBar-nT31.Period*3)return(nT31.T3);else return(0.0);
//----     T3.Series 
}
//---- ---------------------------------------------------------------------------------------------------------+


//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// T3Series1Resize -                | 
//  T3Series1.  : T3Series1Resize(5);  5 -        | 
// T3Series1   .      T3Series1Resize        |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int T3Series1Resize(int nT31Resize.Size)
 {
//----+
  if(nT31Resize.Size<1)
   {
    Print("T3Series1Resize: !!!  nT31Resize.Size     !!!");
    nT31.Resize=-1;  
    return(0);
   }
  //----+    
  int nT31Resize.reset,nT31Resize.cycle;
  //--+
  while(nT31Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSS+
    if(ArrayResize(dT31.e1,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.e2,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.e3,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.e4,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.e5,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.e6,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.n,   nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.c1,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.c2,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.c3,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.c4,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.w1,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.w2,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.b2,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(dT31.b3,  nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    if(ArrayResize(nT31.Test,nT31Resize.Size)==0){nT31Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nT31Resize.cycle=1;
   }
  //--+
  if(nT31Resize.reset==-1)
   {
    Print("T3Series1Resize: !!!        T3Series1().");
    int nT31Resize.Error=GetLastError();
    if(nT31Resize.Error>4000)Print("T3Series1Resize: ",T3_ErrDescr1(nT31Resize.Error));       
    nT31.Resize=-2;
    return(0);
   }
  else  
   {
    Print("T3Series1Resize: T3Series1 Size = "+nT31Resize.Size+"");
    nT31.Resize=nT31Resize.Size;
    return(nT31Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
T3Series1Alert -               |
 T3Series1.                                                                                |
  --------------------------    --------------------------                        |
T3Series1Alert.Number                                                                             |
T3Series1Alert.ExternVar      nT31.Length                    |
T3Series1Alert.name     nT31.Phase,  T3Series1Alert.Number=1           |
  --------------------------    -----------------------                        |
  int init()                                                                                      |
//----                                                                                            |
 -                                                     |
                                                                                                  |
//----                                     |                                                                                                                  
T3Series1Alert(0,"Length1",Length1);                                                              |
T3Series1Alert(0,"Length2",Length2);                                                              |
//----                                                                     |
return(0);                                                                                        |
}                                                                                                 |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void T3Series1Alert
 (
  int T3Series1Alert.Number, string T3Series1Alert.name, int T3Series1Alert.ExternVar
 )
 {
  //----        ==========================+ 
  if(T3Series1Alert.Number==0)if(T3Series1Alert.ExternVar<1)
          {Alert(" "+T3Series1Alert.name+"     1" 
   
     + "    " +T3Series1Alert.ExternVar+ "    1"  );}
   /*  
  if(T3Series1Alert.Number==1)
   {
    if(T3Series1Alert.ExternVar<-100)
          {Alert(" "+T3Series1Alert.name+"    -100  +100" 
          + "    "+T3Series1Alert.ExternVar+  "   -100");}
    if(T3Series1Alert.ExternVar> 100)
          {Alert(" "+T3Series1Alert.name+"    -100  +100" 
          + "    "+T3_ErrDescr1Alert.ExternVar+  "    100");}
   }
   */
 }
//--+ -------------------------------------------------------------------------------------------+


//     01.12.2006  
//+------------------------------------------------------------------+
//|                                       T3_ErrDescr1_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string T3_ErrDescr1(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

