//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                               T3Series0(Exp).mqh |
//|                                T3 code: Copyright  1998, Tilson |
//|            MQL4T3Series0: Copyright  2006,     Nikolay Kositsin |
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  T3Series0() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    T3Series0()          T3      ,   
         .      (): MetaTrader\experts\include\
    ,      nT30.bar ,  nT30.MaxBar-3*nT30.Period,   T3Series0  
    !   ! , ,        -  
    !      T3Series0        
  ,    .    T3Series0()     
      ,                !  
        T3Series0(),       
  nT30....    dT30....        T3Series0()    ,    .
    T3Series0()          ,    
     ,             T3Series0() 
      (nT30.number). 
  
  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nT30.number    -      T3Series0(). (0, 1, 2, 3 ......)
  nT30.din       - ,    nT30.Period   . 0 -   , 
                      - .
  nT30.MaxBar    -   ,        (nT30.bar).   
                   Bars-1-period;  "period" -      ,       dT30.series  
                   ; 
  nT30.limit     -                , 
  nT30.Curvature -     0 ... +100,     ; 
  nT30.Period    -  
  dT30.series    -   ,      T3Series0();
  nT30.bar       -    ,         
                   .           nT30.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  T3Series0()    -   T3.               nT30.bar    nT30.MaxBar-nT30.Length    
                   T3MASeries()   !!!
  nT30.reset     - ,       ,    0,           
                   , 0,        .           ,   
                   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+
  
          T3Series0()          ),    
        ,              T3Series0() 
      T3Series0Resize()      : T3Series0Resize(MaxT3.number+1); 
      nT30.number(MaxT3.number)         T3Series0(),    
  ,   nT30.number. 

  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
             ,        . 
      T3Series0()           \MetaTrader\EXPERTS\LOGS\. ,    
  T3Series0()    ,   ,  MQL4 ,         
    .     T3Series0()   T3Series0()  MQL4 ,  
                    .       
  T3Series0()  nT30.number              nJT3Resize.Size    
              .        
      nT30.limit.          init()    
          T3Series0(),      T3Series0Resize()      
          .      T3Series0()   
            nT30.bar,        
  .  ,            
    ,      T3Series0()          ,      
    .        T3Series0        
        .           
    ,              init().  
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+


//----+   T3Series0 
#include <T3Series0.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1      (    T3Series0()     !!!)
SetIndexBuffer(0,Ind_Buffer);
//----+      T3Series0, nT30.number=1(    T3Series0)
if(T3Series0Resize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    T3Series0   0    Ind_Buffer[], 
  // nT30.Curvature  nT30.Length      (nT30.din=0)
  double Resalt=T3Series0(0,0,MaxBar,limit,Curvature,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 
  */
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< T3Series0 >>> +++++++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double dT30.e1[1],dT30.e2[1],dT30.e3[1],dT30.e4[1],dT30.e5[1],dT30.e6[1];
double dT30.E1[1],dT30.E2[1],dT30.E3[1],dT30.E4[1],dT30.E5[1],dT30.E6[1];
double dT30.c1[1],dT30.c2[1],dT30.c3[1],dT30.c4[1],dT30.w1[1],dT30.w2[1];
double dT30.n[1],dT30.b2[1],dT30.b3[1],dT30.T3;
int    nT30.TIME[1],nT30.Error,nT30.num,nT30.Tnew,nT30.Old,nT30.size,nT30.Resize,nT30.Test[1];
//----++ <<<   T3Series0() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double T3Series0
 (
  int nT30.number,    int nT30.din,     int    nT30.MaxBar,      int nT30.limit,
  int nT30.Curvature, int nT30.Period,  double dT30.series,      int nT30.bar,    int& nT30.reset
 )
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nT30.num=nT30.number;

nT30.reset=1;
//=====+ <<<    >>> ==============================================================================+
if (nT30.bar==nT30.limit)
 {
  //----++     T3Series0()
  if(nT30.Resize<1)
   {
    Print("T3Series0 number ="+nT30.num+
         ".         T3Series0Resize()");
    if(nT30.Resize==0)
       Print("T3Series0 number ="+nT30.num+
                ".      T3Series0Resize()   ");
         
    return(0.0);
   }
  //----++       ,   T3Series0()
  nT30.Error=GetLastError();
  if(nT30.Error>4000)
    {
      Print("T3Series0 number ="+nT30.num+
            ".  ,     T3Series0() number = "
                                                                 +nT30.num+" !!!");
      Print("T3Series0 number ="+nT30.num+ ". ",T3_ErrDescr0(nT30.Error));  
    }

  //----++       nT30.number  nT30Resize.Size
  nT30.size=ArraySize(dT30.e1);
  if (nT30.size< nT30.num) 
   {
    Print("T3Series0 number ="+nT30.num+
              ". !!!     nT30.number="
                                                        +nT30.num+"  T3Series0()");
    Print("T3Series0 number ="+nT30.num+
            ".       nT30Resize.Size="
                                                 +nT30.size+"  T3Series0Resize()");
    return(0.0);
   }
 }
//----++ +--------------------------------------------------------------------------------------------------------+

if (nT30.bar>nT30.MaxBar){nT30.reset=0;return(0.0);}
if((nT30.bar==nT30.MaxBar)||(nT30.din!=0))
  {
   //----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSS+
   nT30.Test[nT30.num]=1;
   double dT30.b=nT30.Curvature/100.0;
   dT30.b2[nT30.num]=dT30.b*dT30.b;
   dT30.b3[nT30.num]=dT30.b2[nT30.num]*dT30.b;
   dT30.c1[nT30.num]=-dT30.b3[nT30.num];
   dT30.c2[nT30.num]=(3*(dT30.b2[nT30.num]+dT30.b3[nT30.num]));
   dT30.c3[nT30.num]=-3*(2*dT30.b2[nT30.num]+dT30.b+dT30.b3[nT30.num]);
   dT30.c4[nT30.num]=(1+3*dT30.b+dT30.b3[nT30.num]+3*dT30.b2[nT30.num]);
   if (nT30.Period<1) nT30.Period=1;
   dT30.n [nT30.num] = 1 + 0.5*(nT30.Period-1);
   dT30.w1[nT30.num] = 2 / (dT30.n[nT30.num] + 1);
   dT30.w2[nT30.num] = 1 - dT30.w1[nT30.num];
   //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
if (nT30.Period<1)nT30.Period=1;

//----++        nT30.bar
if((nT30.limit>=nT30.MaxBar)&&(nT30.bar==0)&&(nT30.din==0))
      if((nT30.MaxBar>nT30.Period*3)&&(nT30.Test[nT30.num]==0))
                        Print("T3Series0 number ="+nT30.num+
                        ". !!!      nT30.bar   !!!"); 

if((nT30.bar==nT30.limit)&&(nT30.limit<nT30.MaxBar))          
  {
   //----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   nT30.Tnew=Time[nT30.limit+1];
   nT30.Old=nT30.TIME[nT30.num];
   //--+   
   if(nT30.Tnew==nT30.Old)
    {
     dT30.e1[nT30.num]=dT30.E1[nT30.num]; dT30.e2[nT30.num]=dT30.E2[nT30.num]; 
     dT30.e3[nT30.num]=dT30.E3[nT30.num]; dT30.e4[nT30.num]=dT30.E4[nT30.num]; 
     dT30.e5[nT30.num]=dT30.E5[nT30.num]; dT30.e6[nT30.num]=dT30.E6[nT30.num];
    }

   if(nT30.Tnew!=nT30.Old)
    {
     nT30.reset=-1;
     //--+       T3.limit  T3Series0()
     if (nT30.Tnew>nT30.Old)
       {
        Print("T3Series0 number ="+nT30.num+
                   ". !!!  nT30.limit  T3Series0()   ");
       }
     else 
       { 
        int nT30.LimitERROR=nT30.limit+1-iBarShift(NULL,0,nT30.Old,TRUE);
        Print("T3Series0 number ="+nT30.num+
            ". !!!  nT30.limit  T3Series0()     "
                                                                          +nT30.LimitERROR+"");
       }
     //--+ 
     return(0);
   }
  //----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
//+---    +SSSS+
if((nT30.bar==0)&&(nT30.limit!=0))
  {
   nT30.TIME[nT30.num]=Time[1];
   dT30.E1[nT30.num]=dT30.e1[nT30.num]; 
   dT30.E2[nT30.num]=dT30.e2[nT30.num]; 
   dT30.E3[nT30.num]=dT30.e3[nT30.num]; 
   dT30.E4[nT30.num]=dT30.e4[nT30.num]; 
   dT30.E5[nT30.num]=dT30.e5[nT30.num]; 
   dT30.E6[nT30.num]=dT30.e6[nT30.num];
  }
//+---+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//---- <<<  dT30.T3 >>> --------------------------------------------------------------------+
dT30.e1[nT30.num] = dT30.w1[nT30.num]*dT30.series       + dT30.w2[nT30.num]*dT30.e1[nT30.num];
dT30.e2[nT30.num] = dT30.w1[nT30.num]*dT30.e1[nT30.num] + dT30.w2[nT30.num]*dT30.e2[nT30.num];
dT30.e3[nT30.num] = dT30.w1[nT30.num]*dT30.e2[nT30.num] + dT30.w2[nT30.num]*dT30.e3[nT30.num];
dT30.e4[nT30.num] = dT30.w1[nT30.num]*dT30.e3[nT30.num] + dT30.w2[nT30.num]*dT30.e4[nT30.num];
dT30.e5[nT30.num] = dT30.w1[nT30.num]*dT30.e4[nT30.num] + dT30.w2[nT30.num]*dT30.e5[nT30.num];
dT30.e6[nT30.num] = dT30.w1[nT30.num]*dT30.e5[nT30.num] + dT30.w2[nT30.num]*dT30.e6[nT30.num];
//----  
dT30.T3 = dT30.c1[nT30.num]*dT30.e6[nT30.num] 
                      + dT30.c2[nT30.num]*dT30.e5[nT30.num] 
                                     + dT30.c3[nT30.num]*dT30.e4[nT30.num] 
                                                   + dT30.c4[nT30.num]*dT30.e3[nT30.num];
//---- -----------------------------------------------------------------------------------------------+

//----++         T3Series0()
nT30.Error=GetLastError();
if(nT30.Error>4000)
  {
    Print("T3Series0 number ="+nT30.num+".    T3Series0()  !!!");
    Print("T3Series0 number ="+nT30.num+ ". ",T3_ErrDescr0(nT30.Error));  
    return(0.0);
  }
nT30.reset=0;
if (nT30.bar<nT30.MaxBar-nT30.Period*3)return(dT30.T3);else return(0.0);
//----     T3.Series 
}
//---- ---------------------------------------------------------------------------------------------------------+


//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// T3Series0Resize -                | 
//  T3Series0.  : T3Series0Resize(5);  5 -        | 
// T3Series0   .      T3Series0Resize        |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int T3Series0Resize(int nT30Resize.Size)
 {
//----+
  if(nT30Resize.Size<1)
   {
    Print("T3Series0Resize: !!!  nT30Resize.Size     !!!");
    nT30.Resize=-1;  
    return(0);
   }
  //----+    
  int nT30Resize.reset,nT30Resize.cycle;
  //--+
  while(nT30Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSS+
    if(ArrayResize(dT30.e1,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.e2,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.e3,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.e4,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.e5,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.e6,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E1,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E2,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E3,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E4,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E5,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.E6,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.n,   nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.c1,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.c2,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.c3,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.c4,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.w1,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.w2,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.b2,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(dT30.b3,  nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(nT30.TIME,nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    if(ArrayResize(nT30.Test,nT30Resize.Size)==0){nT30Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nT30Resize.cycle=1;
   }
  //--+
  if(nT30Resize.reset==-1)
   {
    Print("T3Series0Resize: !!!        T3Series0().");
    int nT30Resize.Error=GetLastError();
    if(nT30Resize.Error>4000)Print("T3Series0Resize: ",T3_ErrDescr0(nT30Resize.Error));       
    nT30.Resize=-2;
    return(0);
   }
  else  
   {
    Print("T3Series0Resize: T3Series0 Size = "+nT30Resize.Size+"");
    nT30.Resize=nT30Resize.Size;
    return(nT30Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
T3Series0Alert -               |
 T3Series0.                                                                                |
  --------------------------    --------------------------                        |
T3Series0Alert.Number                                                                             |
T3Series0Alert.ExternVar      nT30.Length                    |
T3Series0Alert.name     nT30.Phase,  T3Series0Alert.Number=1           |
  --------------------------    -----------------------                        |
  int init()                                                                                      |
//----                                                                                            |
 -                                                     |
                                                                                                  |
//----                                     |                                                                                                                  
T3Series0Alert(0,"Length1",Length1);                                                              |
T3Series0Alert(0,"Length2",Length2);                                                              |
//----                                                                     |
return(0);                                                                                        |
}                                                                                                 |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void T3Series0Alert
 (
  int T3Series0Alert.Number, string T3Series0Alert.name, int T3Series0Alert.ExternVar
 )
 {
  //----        ==========================+ 
  if(T3Series0Alert.Number==0)if(T3Series0Alert.ExternVar<1)
          {Alert(" "+T3Series0Alert.name+"     1" 
   
     + "    " +T3Series0Alert.ExternVar+ "    1"  );}
   /*  
  if(T3Series0Alert.Number==1)
   {
    if(T3Series0Alert.ExternVar<-100)
          {Alert(" "+T3Series0Alert.name+"    -100  +100" 
          + "    "+T3Series0Alert.ExternVar+  "   -100");}
    if(T3Series0Alert.ExternVar> 100)
          {Alert(" "+T3Series0Alert.name+"    -100  +100" 
          + "    "+T3Series0Alert.ExternVar+  "    100");}
   }
   */
 }
//--+ -------------------------------------------------------------------------------------------+


//     01.12.2006  
//+------------------------------------------------------------------+
//|                                       T3_ErrDescr0_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string T3_ErrDescr0(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

