//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                            ParMASeries1(Exp).mqh |
//|          Parabolic approximation code: Copyright  2005, alexjou |
//|        MQL4 ParMASeries1()Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*
  
  SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  ParMASeries1() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

   ParMASeries1()         ,
                .           ():
  MetaTrader\experts\include\.      ,       nParMA1.bar  ,    nParMA1.MaxBar,    
  ParMASeries1()   !   ! , ,     
     -    !    ParMASeries1()    
          ,     .    ParMASeries1()
         ,        
       !                  ParMASeries1(),  
           nParMA1....  dParMA1....    ParMASeries1()
        ,         .    ParMASeries1()    
          ,       ,     
                    ParMASeries1()          
  (nParMA1.number). 

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nParMA1.n      -      ParMASeries1(). (0, 1, 2, 3 ......)
  nParMA1.MaxBar -  ,      (nParMA1.bar).   
                   Bars-1-period;  "period" -    ,     dParMA1.series   
                   ; 
  nParMA1.limit  -          ,
  nParMA1.Period -  .      !      
                   500.                ,           
                   dParMA1.TempBuffer[1][500].      3.
  dParMA1.series -   ,      ParMASeries1();
  nParMA1.bar    -   ,           
                   !           nParMA1.limit!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  ParMASeries1() -   dParMA1.ret_val.   nParMA1.bar   nParMA1.MaxBar-nParMA1.Length 
                    ParMASeries1()   !!!
  nParMA1.reset  - ,    ,   0 ,      ,
                   0,    .      ,   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

          ParMASeries1()  ,         0,   
        ,           ParMASeries1() 
       ParMASeries1Resize()      :  ParMASeries1Resize(MaxParMA.number+1);
     nParMA1.n(MaxParMA.number)      ParMASeries1,   
   ,   nParMA1.n. 
  
  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .      ParMASeries1()      \MetaTrader\EXPERTS\LOGS\. ,   
   ParMASeries1()  ,   ,  MQL4 ,       
        .         ParMASeries1()  ParMASeries1() MQL4
  ,            .     
    ParMASeries1() nParMA1.number       nJParMAResize.Size  
                  .       
     nParMA1.limit.      init()   
           ParMASeries1(),   ParMASeries1Resize()    
              .      ParMASeries1()
               nParMA1.bar,    
         .  ,        
        ,   ParMASeries1()       ,  
       .      ParMASeries1()  
                  .     
          ,             init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+

 
//+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< ParMASeries1()>>> +++++++++++++++++++++++++++++++++++++++++++++++++++++|
//+
*/
//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+ 
double dParMA1.TempBuffer[1][501];
int nParMA1.sum_x [1], nParMA1.sum_x2[1], nParMA1.sum_x3[1];
int nParMA1.sum_x4[1], nParMA1.Test[1], nParMA1.rangeMin;
//----++
double dParMA1.sum_y, dParMA1.sum_xy, dParMA1.sum_x2y, dParMA1.var_tmp;
double dParMA1.A, dParMA1.B, dParMA1.C, dParMA1.D, dParMA1.E, dParMA1.F; 
double dParMA1.K, dParMA1.L, dParMA1.M, dParMA1.P, dParMA1.Q, dParMA1.R; 
double dParMA1.S, dParMA1.B0, dParMA1.B1, dParMA1.B2, dParMA1.ret_val;
int    nParMA1.iii, nParMA1.loop_begin, nParMA1.Error,nParMA1.n, nParMA1.Resize; 

//----++ <<<   ParMASeries1() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double ParMASeries1
 (
  int nParMA1.number,int nParMA1.MaxBar,int nParMA1.limit,int nParMA1.period,double dParMA1.series,int nParMA1.bar,int& nParMA1.reset
  )
//----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
 
{
nParMA1.n=nParMA1.number;

nParMA1.reset=1;
//=====+ <<<    >>> ==========================================================================+
if (nParMA1.bar==nParMA1.limit)
 {
  //----++     ParMASeries1()
  if(nParMA1.Resize<1)
   {
    Print("ParMASeries1 number ="+nParMA1.n+
         ".         ParMASeries1Resize()");
    if(nParMA1.Resize==0)
       Print("ParMASeries1 number ="+nParMA1.n+
                ".      ParMASeries1Resize()   ");
         
    return(0.0);
   }
  //----++       ,   ParMASeries1()
  nParMA1.Error=GetLastError();
  if(nParMA1.Error>4000)
   {
    Print("ParMASeries1 number ="+nParMA1.n+
         ".  ,     ParMASeries1() number = "+nParMA1.n+" !!!");
    Print("ParMASeries1 number ="+nParMA1.n+ ". ",ParMA_ErrDescr1(nParMA1.Error));  
   } 
                                                   
  //----++       nParMA1.number  nParMA1Resize.Number
  if (ArraySize(nParMA1.sum_x)< nParMA1.number) 
   {
    Print("ParMASeries1 number ="+nParMA1.n+
                ". !!!     nParMA1.number  ParMASeries1()");
    Print("ParMASeries1 number ="+nParMA1.n+
         ".       nParMA1Resize.Size  ParMASeries1Resize()");
    return(0.0);
   }
 }
//----++ +====================================================================================================+ 

if (nParMA1.bar>nParMA1.MaxBar){nParMA1.reset=0;return(0.0);}

if(nParMA1.bar!=nParMA1.limit)
        for(nParMA1.iii=nParMA1.period;nParMA1.iii>=0;nParMA1.iii--)
                            dParMA1.TempBuffer[nParMA1.n][nParMA1.iii+1]=
                                       dParMA1.TempBuffer[nParMA1.n][nParMA1.iii];
                                 
dParMA1.TempBuffer[nParMA1.n][0]=dParMA1.series;

if (nParMA1.period<3)nParMA1.period=3;
else if (nParMA1.period>nParMA1.rangeMin)nParMA1.period=nParMA1.rangeMin; 

if (nParMA1.bar> nParMA1.MaxBar-nParMA1.period){nParMA1.reset=0;return(0.0);}

//----++ <<<    >>> +SSSSSSSSSSSS+
if (nParMA1.bar==nParMA1.MaxBar-nParMA1.period)
{ 
 nParMA1.Test[nParMA1.n]=1;
 for(nParMA1.iii=1;nParMA1.iii<=nParMA1.period;nParMA1.iii++)
   {
    dParMA1.var_tmp  = nParMA1.iii;
    nParMA1.sum_x[nParMA1.n]   += dParMA1.var_tmp; 
    dParMA1.var_tmp *= nParMA1.iii;
    nParMA1.sum_x2[nParMA1.n]  += dParMA1.var_tmp; 
    dParMA1.var_tmp *= nParMA1.iii;
    nParMA1.sum_x3[nParMA1.n]  += dParMA1.var_tmp; 
    dParMA1.var_tmp *= nParMA1.iii;
    nParMA1.sum_x4[nParMA1.n]  += dParMA1.var_tmp; 
   }
}
//----++ SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

if (nParMA1.period<1)nParMA1.period=1;

//----++        nParMA1.bar
if((nParMA1.limit>=nParMA1.MaxBar)&&(nParMA1.bar==0))
  if((nParMA1.MaxBar>nParMA1.period)&&(nParMA1.Test[nParMA1.n]==0))
                        Print("ParMASeries1 number ="+nParMA1.n+
                        ". !!!      nParMA1.bar   !!!"); 
//----++                       
  // main calculation loop
  nParMA1.loop_begin = nParMA1.period - 1;
  dParMA1.sum_y   = 0.0;
  dParMA1.sum_xy  = 0.0;
  dParMA1.sum_x2y = 0.0;
  for (nParMA1.iii = 1; nParMA1.iii<=nParMA1.period; nParMA1.iii++)
   {
    dParMA1.var_tmp  = dParMA1.TempBuffer[nParMA1.n][nParMA1.loop_begin-nParMA1.iii+1];  
    dParMA1.sum_y   += dParMA1.var_tmp;
    dParMA1.sum_xy  += nParMA1.iii * dParMA1.var_tmp;    
    dParMA1.sum_x2y += nParMA1.iii * nParMA1.iii * dParMA1.var_tmp; 
   }
  // initialization
  dParMA1.A = nParMA1.period;
  dParMA1.B = nParMA1.sum_x[nParMA1.n];  dParMA1.C = nParMA1.sum_x2[nParMA1.n]; 
  dParMA1.F = nParMA1.sum_x3[nParMA1.n]; dParMA1.M = nParMA1.sum_x4[nParMA1.n]; 
  dParMA1.P = dParMA1.sum_y;                   dParMA1.R = dParMA1.sum_xy; 
  dParMA1.S = dParMA1.sum_x2y;
  // intermediates
  dParMA1.D = dParMA1.B;  dParMA1.E = dParMA1.C;  dParMA1.K = dParMA1.C;  dParMA1.L = dParMA1.F;
  dParMA1.Q = dParMA1.D / dParMA1.A;  dParMA1.E = dParMA1.E - dParMA1.Q * dParMA1.B; 
  dParMA1.F = dParMA1.F - dParMA1.Q * dParMA1.C;  dParMA1.R = dParMA1.R - dParMA1.Q * dParMA1.P;  
  dParMA1.Q = dParMA1.K / dParMA1.A;  dParMA1.L = dParMA1.L - dParMA1.Q * dParMA1.B;
  dParMA1.M = dParMA1.M - dParMA1.Q * dParMA1.C;  dParMA1.S = dParMA1.S - dParMA1.Q * dParMA1.P; 
  dParMA1.Q = dParMA1.L / dParMA1.E;
  // calculate regression coefficients
  dParMA1.B2 = (dParMA1.S - dParMA1.R * dParMA1.Q) / (dParMA1.M - dParMA1.F * dParMA1.Q);
  dParMA1.B1 = (dParMA1.R - dParMA1.F * dParMA1.B2) / dParMA1.E;
  dParMA1.B0 = (dParMA1.P - dParMA1.B * dParMA1.B1 - dParMA1.C * dParMA1.B2) / dParMA1.A;
  // value to be returned - parabolic MA
  dParMA1.ret_val = dParMA1.B0 + (dParMA1.B1 + dParMA1.B2 * dParMA1.A) * dParMA1.A;
 //----
 //----++         JParMASeries1()
nParMA1.Error=GetLastError();
if(nParMA1.Error>4000)
  {
    Print("ParMASeries1 number ="+nParMA1.n+".    ParMASeries1()  !!!");
    Print("ParMASeries1 number ="+nParMA1.n+ ". ",ParMA_ErrDescr1(nParMA1.Error));   
    return(0.0);
  }
  
  dParMA1.reset=0;
  return(dParMA1.ret_val);
//----     ParMASeries1() ----------------+ 
}

//--+ --------------------------------------------------------------------------------------------+


//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// ParMASeries1Resize -              | 
//  ParMASeries1.  : ParMASeries1Resize(5);  5 -    | 
//  ParMASeries1()  .      ParMASeries1Resize         |
//                                |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int ParMASeries1Resize(int nParMA1Resize.Size)
 {
//----+
  if(nParMA1Resize.Size<1)
   {
    Print("ParMASeries1Resize: !!!  nParMA1Resize.Size     !!!"); 
    nParMA1.Resize=-1; 
    return(0);
   }
  //----+    
  nParMA1.rangeMin=ArrayRange(dParMA1.TempBuffer,1)-1;  
  if(nParMA1Resize.Size==-2)return(nParMA1.rangeMin);
  //----+
  int nParMA1Resize.reset,nParMA1Resize.cycle;
  //--+
  while(nParMA1Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    if(ArrayResize(dParMA1.TempBuffer,nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    if(ArrayResize(nParMA1.sum_x ,    nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    if(ArrayResize(nParMA1.sum_x2,    nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    if(ArrayResize(nParMA1.sum_x3,    nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    if(ArrayResize(nParMA1.sum_x4,    nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    if(ArrayResize(nParMA1.Test,      nParMA1Resize.Size)==0){nParMA1Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nParMA1Resize.cycle=1;
   }
  //--+
  if(nParMA1Resize.reset==-1)
   {
    Print("ParMASeries1Resize: !!!        ParMASeries1().");
    int nParMA1Resize.Error=GetLastError();
    if(nParMA1Resize.Error>4000)Print("ParMASeries1Resize: ",ParMA_ErrDescr1(nParMA1Resize.Error));    
    nParMA1.Resize=-2;
    return(0);
   }
  else  
   {
    Print("ParMASeries1Resize: ParMASeries1 Size = "+nParMA1Resize.Size+"");
    nParMA1.Resize=nParMA1Resize.Size;
    return(nParMA1Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
ParMASeries1Alert -                   |
 ParMASeries1.                                                                                    |
  --------------------------    --------------------------                               |
ParMASeries1Alert.Number                                                                                 |
ParMASeries1Alert.ExternVar      nParMA1.Phase                      |
ParMASeries1Alert.name      nParMA1.Length,                          |
ParMASeries1Alert.Number=0.                                                                              |                                                  
  --------------------------    -----------------------                               |
  int init()                                                                                             |
//----                                                                                                   |
 -                                                            |
                                                                                                         |
//----                                            |                                                           
ParMASeries1Alert(0,"Length1",Length1);                                                                  |
ParMASeries1Alert(0,"Length2",Length2);                                                                  |
//----                                                                            |
return(0);                                                                                               |
}                                                                                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void ParMASeries1Alert
 (
  int ParMASeries1Alert.Number, string ParMASeries1Alert.name, int ParMASeries1Alert.ExternVar
 )
 {
  //----        ==========================+ 
   if(ParMASeries1Alert.Number==0)if(ParMASeries1Alert.ExternVar<3)
          {Alert(" "+ParMASeries1Alert.name+"     3" 
          + "    " +ParMASeries1Alert.ExternVar+ "    3");}
   int ParMASeries1Alert.MaxPeriod=ArrayRange(dParMA1.TEMPBUFFER,1); 
   if(ParMASeries1Alert.Number==0)if((ParMASeries1Alert.ExternVar>ParMASeries1Alert.MaxPeriod))
          {Alert(" "+ParMASeries1Alert.name+"     "+ParMASeries1Alert.MaxPeriod+"" 
          + "    " +ParMASeries1Alert.ExternVar+ ".    "+ParMASeries1Alert.MaxPeriod+"."
          + "      nParMA1.period,    "
          +" dParMA1.TempBuffer  dParMA1.TEMPBUFFER  ParMA_ErrDescr1" );}       
 }
//--+ -------------------------------------------------------------------------------------------+

//     01.12.2006  
//+------------------------------------------------------------------+
//|                                    ParMA_ErrDescr1_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string ParMA_ErrDescr1(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

