//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                            ParMASeries0(Exp).mqh |
//|          Parabolic approximation code: Copyright  2005, alexjou |
//|        MQL4 ParMASeries0()Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*
  
  SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  ParMASeries0() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

   ParMASeries0()         ,
                .           ():
  MetaTrader\experts\include\.      ,       nParMA0.bar  ,    nParMA0.MaxBar,    
  ParMASeries0()   !   ! , ,     
     -    !    ParMASeries0()    
          ,     .    ParMASeries0()
         ,        
       !                  ParMASeries0(),  
           nParMA0....  dParMA0....    ParMASeries0()
        ,        .    ParMASeries0()    
          ,       ,     
                    ParMASeries0()          
  (nParMA0.number). 

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nParMA0.n      -      ParMASeries0(). (0, 1, 2, 3 ......)
  nParMA0.MaxBar -  ,      (nParMA0.bar).   
                   Bars-1-period;  "period" -    ,     dParMA0.series   
                   ; 
  nParMA0.limit  -          ,
  nParMA0.Period -  .      !      
                   500.                ,           
                   dParMA0.TempBuffer[1][500]  dParMA0.TEMPBUFFER[1][500].      
                   3.
  dParMA0.series -   ,      ParMASeries0();
  nParMA0.bar    -   ,           
                   .          
                   nParMA0.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  ParMASeries0() -   dParMA0.ret_val.   nParMA0.bar   nParMA0.MaxBar-nParMA0.Length 
                    ParMASeries0()   !!!
  nParMA0.reset  - ,    ,   0 ,      ,
                   0,    .      ,   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

          ParMASeries0()  ,         0,   
        ,           ParMASeries0() 
       ParMASeries0Resize()      :  ParMASeries0Resize(MaxParMA.number+1);
     nParMA0.n(MaxParMA.number)      ParMASeries0,   
   ,   nParMA0.n. 
  
  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .      ParMASeries0()      \MetaTrader\EXPERTS\LOGS\. ,   
   ParMASeries0()  ,   ,  MQL4 ,       
        .         ParMASeries0()  ParMASeries0() MQL4
  ,            .     
    ParMASeries0() nParMA0.number       nJParMAResize.Size  
                  .       
     nParMA0.limit.      init()   
           ParMASeries0(),   ParMASeries0Resize()    
              .      ParMASeries0()
               nParMA0.bar,    
         .  ,        
        ,   ParMASeries0()       ,  
       .      ParMASeries0()  
                  .     
          ,             init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+

 
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< ParMASeries0()>>> +++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSS+ 
double dParMA0.TempBuffer[1][501], dParMA0.TEMPBUFFER[1][501];
int nParMA0.range1, nParMA0.range2, nParMA0.rangeMin; 
int nParMA0.sum_x [1], nParMA0.sum_x2[1], nParMA0.sum_x3[1];
int nParMA0.sum_x4[1], nParMA0.TIME[1], nParMA0.Test[1];
//----++
double dParMA0.sum_y, dParMA0.sum_xy, dParMA0.sum_x2y, dParMA0.var_tmp;
double dParMA0.A, dParMA0.B, dParMA0.C, dParMA0.D, dParMA0.E, dParMA0.F; 
double dParMA0.K, dParMA0.L, dParMA0.M, dParMA0.P, dParMA0.Q, dParMA0.R; 
double dParMA0.S, dParMA0.B0, dParMA0.B1, dParMA0.B2, dParMA0.ret_val;
int    nParMA0.iii, nParMA0.loop_begin,nParMA0.Error;
int    nParMA0.Tnew,nParMA0.Told,nParMA0.n,nParMA0.Resize; 

//----++ <<<   ParMASeries0() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double ParMASeries0
 (
  int nParMA0.number,int nParMA0.MaxBar,int nParMA0.limit,int nParMA0.period,double dParMA0.series,int nParMA0.bar,int& nParMA0.reset
  )
//----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
 
{
nParMA0.n=nParMA0.number;

nParMA0.reset=1;
//=====+ <<<    >>> ==========================================================================+
if (nParMA0.bar==nParMA0.limit)
 {
  //----++     ParMASeries0()
  if(nParMA0.Resize<1)
   {
    Print("ParMASeries0 number ="+nParMA0.n+
         ".         ParMASeries0Resize()");
    if(nParMA0.Resize==0)
       Print("ParMASeries0 number ="+nParMA0.n+
                ".      ParMASeries0Resize()   ");
         
    return(0.0);
   }
  //----++       ,   ParMASeries0()
  nParMA0.Error=GetLastError();
  if(nParMA0.Error>4000)
   {
    Print("ParMASeries0 number ="+nParMA0.n+
         ".  ,     ParMASeries0() number = "+nParMA0.n+" !!!");
    Print("ParMASeries0 number ="+nParMA0.n+ ". ",ParMA_ErrDescr0(nParMA0.Error));  
   } 
                                                   
  //----++       nParMA0.number  nParMA0Resize.Number
  if (ArraySize(nParMA0.sum_x)< nParMA0.number) 
   {
    Print("ParMASeries0 number ="+nParMA0.n+
                ". !!!     nParMA0.number  ParMASeries0()");
    Print("ParMASeries0 number ="+nParMA0.n+
         ".       nParMA0Resize.Size  ParMASeries0Resize()");
    return(0.0);
   }
 }
//----++ +====================================================================================================+ 

if (nParMA0.bar>nParMA0.MaxBar){nParMA0.reset=0;return(0.0);}

if(nParMA0.bar!=nParMA0.limit)
        for(nParMA0.iii=nParMA0.period;nParMA0.iii>=0;nParMA0.iii--)
                            dParMA0.TempBuffer[nParMA0.n][nParMA0.iii+1]=
                                       dParMA0.TempBuffer[nParMA0.n][nParMA0.iii];
                                 
dParMA0.TempBuffer[nParMA0.n][0]=dParMA0.series;

if (nParMA0.period<3)nParMA0.period=3;
else if (nParMA0.period>nParMA0.rangeMin)nParMA0.period=nParMA0.rangeMin; 

if (nParMA0.bar> nParMA0.MaxBar-nParMA0.period){nParMA0.reset=0;return(0.0);}

//----++ <<<    >>> +SSSSSSSSSSSS+
if (nParMA0.bar==nParMA0.MaxBar-nParMA0.period)
{ 
 nParMA0.Test[nParMA0.n]=1;
 for(nParMA0.iii=1;nParMA0.iii<=nParMA0.period;nParMA0.iii++)
   {
    dParMA0.var_tmp  = nParMA0.iii;
    nParMA0.sum_x[nParMA0.n]   += dParMA0.var_tmp; 
    dParMA0.var_tmp *= nParMA0.iii;
    nParMA0.sum_x2[nParMA0.n]  += dParMA0.var_tmp; 
    dParMA0.var_tmp *= nParMA0.iii;
    nParMA0.sum_x3[nParMA0.n]  += dParMA0.var_tmp; 
    dParMA0.var_tmp *= nParMA0.iii;
    nParMA0.sum_x4[nParMA0.n]  += dParMA0.var_tmp; 
   }
}
//----++ SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

if (nParMA0.period<1)nParMA0.period=1;

//----++        nParMA0.bar
if((nParMA0.limit>=nParMA0.MaxBar)&&(nParMA0.bar==0))
  if((nParMA0.MaxBar>nParMA0.period)&&(nParMA0.Test[nParMA0.n]==0))
                        Print("ParMASeries0 number ="+nParMA0.n+
                        ". !!!      nParMA0.bar   !!!"); 
                        
if((nParMA0.bar==nParMA0.limit)&&(nParMA0.limit<nParMA0.MaxBar))
{
//----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
nParMA0.Tnew=Time[nParMA0.limit+1];
nParMA0.Told=nParMA0.TIME[nParMA0.n];
 //--+
if(nParMA0.Tnew==nParMA0.Told)
         for(nParMA0.iii=nParMA0.period;nParMA0.iii>=1;nParMA0.iii--)
                              dParMA0.TempBuffer[nParMA0.n][nParMA0.iii]=
                                                         dParMA0.TEMPBUFFER[nParMA0.n][nParMA0.iii];  
//--+   
if(nParMA0.Tnew!=nParMA0.Told)
    {
     nParMA0.reset=-1;
     //--+       nParMA0.limit  ParMASeries0()
     if (nParMA0.Tnew>nParMA0.TIME[nParMA0.n])
       {
       Print("ParMASeries0 number ="+nParMA0.n+
                                 ". !!!  nParMA0.limit  ParMASeries0() ,  ");
       }
    else 
       { 
       int nParMA0.LimitERROR=nParMA0.limit+1-iBarShift(NULL,0,nParMA0.TIME[nParMA0.n],TRUE);
       Print("ParMASeries0 number ="+nParMA0.n+
         ". !!!  nParMA0.limit  ParMASeries0() ,    "+nParMA0.LimitERROR+"");
       }
  //--+   nParMA0.reset=-1;     ParMASeries0
  return(0);
  }                     
//----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
} 

//+---    +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
if ((nParMA0.bar==0)&&(nParMA0.limit!=0))
 {
  nParMA0.TIME[nParMA0.n]=Time[1];
  for(nParMA0.iii=nParMA0.period;nParMA0.iii>=1;nParMA0.iii--)
                        dParMA0.TEMPBUFFER[nParMA0.n][nParMA0.iii]=
                                    dParMA0.TempBuffer[nParMA0.n][nParMA0.iii];      
 }
//+---+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  
 
  // main calculation loop
  nParMA0.loop_begin = nParMA0.period - 1;
  dParMA0.sum_y   = 0.0;
  dParMA0.sum_xy  = 0.0;
  dParMA0.sum_x2y = 0.0;
  for (nParMA0.iii = 1; nParMA0.iii<=nParMA0.period; nParMA0.iii++)
   {
    dParMA0.var_tmp  = dParMA0.TempBuffer[nParMA0.n][nParMA0.loop_begin-nParMA0.iii+1];  
    dParMA0.sum_y   += dParMA0.var_tmp;
    dParMA0.sum_xy  += nParMA0.iii * dParMA0.var_tmp;    
    dParMA0.sum_x2y += nParMA0.iii * nParMA0.iii * dParMA0.var_tmp; 
   }
  // initialization
  dParMA0.A = nParMA0.period;
  dParMA0.B = nParMA0.sum_x[nParMA0.n];  dParMA0.C = nParMA0.sum_x2[nParMA0.n]; 
  dParMA0.F = nParMA0.sum_x3[nParMA0.n]; dParMA0.M = nParMA0.sum_x4[nParMA0.n]; 
  dParMA0.P = dParMA0.sum_y;                   dParMA0.R = dParMA0.sum_xy; 
  dParMA0.S = dParMA0.sum_x2y;
  // intermediates
  dParMA0.D = dParMA0.B;  dParMA0.E = dParMA0.C;  dParMA0.K = dParMA0.C;  dParMA0.L = dParMA0.F;
  dParMA0.Q = dParMA0.D / dParMA0.A;  dParMA0.E = dParMA0.E - dParMA0.Q * dParMA0.B; 
  dParMA0.F = dParMA0.F - dParMA0.Q * dParMA0.C;  dParMA0.R = dParMA0.R - dParMA0.Q * dParMA0.P;  
  dParMA0.Q = dParMA0.K / dParMA0.A;  dParMA0.L = dParMA0.L - dParMA0.Q * dParMA0.B;
  dParMA0.M = dParMA0.M - dParMA0.Q * dParMA0.C;  dParMA0.S = dParMA0.S - dParMA0.Q * dParMA0.P; 
  dParMA0.Q = dParMA0.L / dParMA0.E;
  // calculate regression coefficients
  dParMA0.B2 = (dParMA0.S - dParMA0.R * dParMA0.Q) / (dParMA0.M - dParMA0.F * dParMA0.Q);
  dParMA0.B1 = (dParMA0.R - dParMA0.F * dParMA0.B2) / dParMA0.E;
  dParMA0.B0 = (dParMA0.P - dParMA0.B * dParMA0.B1 - dParMA0.C * dParMA0.B2) / dParMA0.A;
  // value to be returned - parabolic MA
  dParMA0.ret_val = dParMA0.B0 + (dParMA0.B1 + dParMA0.B2 * dParMA0.A) * dParMA0.A;
 //----
 //----++         JParMASeries0()
nParMA0.Error=GetLastError();
if(nParMA0.Error>4000)
  {
    Print("ParMASeries0 number ="+nParMA0.n+".    ParMASeries0()  !!!");
    Print("ParMASeries0 number ="+nParMA0.n+ ". ",ParMA_ErrDescr0(nParMA0.Error));   
    return(0.0);
  }
  
  nParMA0.reset=0;
  return(dParMA0.ret_val);
//----     ParMASeries0() ----------------+ 
}

//--+ --------------------------------------------------------------------------------------------+


//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// ParMASeries0Resize -              | 
//  ParMASeries0.  : ParMASeries0Resize(5);  5 -    | 
//  ParMASeries0()  .      ParMASeries0Resize         |
//                                |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int ParMASeries0Resize(int nParMA0Resize.Size)
 {
//----+
  if(nParMA0Resize.Size<1)
   {
    Print("ParMASeries0Resize: !!!  nParMA0Resize.Size     !!!"); 
    nParMA0.Resize=-1; 
    return(0);
   }
  //----+    
  nParMA0.range1=ArrayRange(dParMA0.TempBuffer,1)-1; 
  nParMA0.range2=ArrayRange(dParMA0.TEMPBUFFER,1)-1;   
  nParMA0.rangeMin=MathMin(nParMA0.range1,nParMA0.range2);
  if(nParMA0Resize.Size==-2)return(nParMA0.rangeMin);
  //----+
  int nParMA0Resize.reset,nParMA0Resize.cycle;
  //--+
  while(nParMA0Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    if(ArrayResize(dParMA0.TempBuffer,nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(dParMA0.TEMPBUFFER,nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.sum_x ,    nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.sum_x2,    nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.sum_x3,    nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.sum_x4,    nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.TIME,      nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    if(ArrayResize(nParMA0.Test,      nParMA0Resize.Size)==0){nParMA0Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nParMA0Resize.cycle=1;
   }
  //--+
  if(nParMA0Resize.reset==-1)
   {
    Print("ParMASeries0Resize: !!!        ParMASeries0().");
    int nParMA0Resize.Error=GetLastError();
    if(nParMA0Resize.Error>4000)Print("ParMASeries0Resize: ",ParMA_ErrDescr0(nParMA0Resize.Error));    
    nParMA0.Resize=-2;
    return(0);
   }
  else  
   {
    Print("ParMASeries0Resize: ParMASeries0 Size = "+nParMA0Resize.Size+"");
    nParMA0.Resize=nParMA0Resize.Size;
    return(nParMA0Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
ParMASeries0Alert -                   |
 ParMASeries0.                                                                                    |
  --------------------------    --------------------------                               |
ParMASeries0Alert.Number                                                                                 |
ParMASeries0Alert.ExternVar      nParMA0.Phase                      |
ParMASeries0Alert.name      nParMA0.Length,                          |
ParMASeries0Alert.Number=0.                                                                              |                                                  
  --------------------------    -----------------------                               |
  int init()                                                                                             |
//----                                                                                                   |
 -                                                            |
                                                                                                         |
//----                                            |                                                           
ParMASeries0Alert(0,"Length1",Length1);                                                                  |
ParMASeries0Alert(0,"Length2",Length2);                                                                  |
//----                                                                            |
return(0);                                                                                               |
}                                                                                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void ParMASeries0Alert
 (
  int ParMASeries0Alert.Number, string ParMASeries0Alert.name, int ParMASeries0Alert.ExternVar
 )
 {
  //----        ==========================+ 
   if(ParMASeries0Alert.Number==0)if(ParMASeries0Alert.ExternVar<3)
          {Alert(" "+ParMASeries0Alert.name+"     3" 
          + "    " +ParMASeries0Alert.ExternVar+ "    3");}
   int ParMASeries0Alert.MaxPeriod=ArrayRange(dParMA0.TEMPBUFFER,1); 
   if(ParMASeries0Alert.Number==0)if((ParMASeries0Alert.ExternVar>ParMASeries0Alert.MaxPeriod))
          {Alert(" "+ParMASeries0Alert.name+"     "+ParMASeries0Alert.MaxPeriod+"" 
          + "    " +ParMASeries0Alert.ExternVar+ ".    "+ParMASeries0Alert.MaxPeriod+"."
          + "      nParMA0.period,    "
          +" dParMA0.TempBuffer  dParMA0.TEMPBUFFER  ParMASeries0" );}       
 }
//--+ -------------------------------------------------------------------------------------------+

//     01.12.2006  
//+------------------------------------------------------------------+
//|                                    ParMA_ErrDescr0_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string ParMA_ErrDescr0(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

