//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                             LRMASeries1(Exp).mqh |
//|                             LRMA code: Copyright  2005, alexjou |
//|            MQL4 LRMASeries1() Copyright  2006, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  LRMASeries1() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    LRMASeries1()              , 
                  .            ():
  MetaTrader\experts\include\.      ,         nLRMA1.bar  ,    nLRMA1.MaxBar,    
  LRMASeries1()    !   ! , ,     
    -    !    LRMASeries1()    
        ,        .      LRMASeries1()
         ,        
    !         LRMASeries1(),  
       nLRMA1....  dLRMA1....    LRMASeries1()   
  ,         .    LRMASeries1()        
    ,          ,       
       LRMASeries1()      (nLRMA1.number). 

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nLRMA1.n      -      LRMASeries1(). (0, 1, 2, 3 ......)
  nLRMA1.MaxBar -  ,        (nLRMA1.bar).   
                  Bars-1-period;  "period" -    ,       dLRMA1.series   
                  ; 
  nLRMA1.limit  -          ,  
  nLRMA1.Period -  .      !       
                  500.                ,            
                  dLRMA1.TempBuffer[1][500].     3.
  dLRMA1.series -   ,      LRMASeries1();
  nLRMA1.bar    -   ,            
                  !           nLRMA1.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  LRMASeries1() -   dLRMA1.ret_val.     nLRMA1.bar      nLRMA1.MaxBar-nLRMA1.Length 
                   LRMASeries1()   !!!
  nLRMA1.reset  - ,    ,   0 ,       ,
                  0,    .      ,   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

          LRMASeries1()  ,          0,   
        ,            LRMASeries1() 
        LRMASeries1Resize()        :  LRMASeries1Resize(MaxLRMA.number+1);
        nLRMA1.n(MaxLRMA.number)      LRMASeries1,   
   ,   nLRMA1.n. 

  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .      LRMASeries1()       \MetaTrader\EXPERTS\LOGS\. ,   
    LRMASeries1()  ,   ,  MQL4 ,       
     .     LRMASeries1()  LRMASeries1()  MQL4 ,
                   .      
    LRMASeries1()  nLRMA1.number        nJLRMAResize.Size()  
                  .       
      nLRMA1.limit.      init()   
            LRMASeries1(),   LRMASeries1Resize ()    
              .      LRMASeries1() 
                nLRMA1.bar,    
         .  ,        
         ,   LRMASeries1()       ,  
       .      LRMASeries1()   
                  .     
          ,             init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+

//----+   LRMASeries1()
#include <LRMASeries1.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1      (    LRMASeries1()     !!!)
SetIndexBuffer(0,Ind_Buffer);
//----+      LRMASeries1, nLRMA1.n=1(    LRMASeries1)
if(LRMASeries1Resize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    LRMASeries1()  0    Ind_Buffer[], 
  double Resalt=LRMASeries1(0,MaxBar,limit,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 

*/
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< LRMASeries1()>>> +++++++++++++++++++++++++++++++++++++++++++++++++---++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+ 
double dLRMA1.TempBuffer[1][501],dLRMA1.den_x[1];
int nLRMA1.sum_x[1], nLRMA1.sum_x2[1], nLRMA1.TIME[1], nLRMA1.Test[1], nLRMA1.rangeMin; 
//----++
double dLRMA1.sum_y, dLRMA1.sum_xy, dLRMA1.var_tmp;
double dLRMA1.A, dLRMA1.B, dLRMA1.ret_val;
int    nLRMA1.iii, nLRMA1.loop_begin,nLRMA1.Error,nLRMA1.Tnew,nLRMA1.Told,nLRMA1.n,nLRMA1.Resize;

//----++ <<<   LRMASeries1() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

double LRMASeries1
 (
  int nLRMA1.number,int nLRMA1.MaxBar,int nLRMA1.limit,int nLRMA1.period,double dLRMA1.series,int nLRMA1.bar,int& nLRMA1.reset
 )
//----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nLRMA1.n=nLRMA1.number;

nLRMA1.reset=1;
//=====+ <<<    >>> ==========================================================================+
if (nLRMA1.bar==nLRMA1.limit)
 {
  //----++     LRMASeries1()
  if(nLRMA1.Resize<1)
   {
    Print("LRMASeries1 number ="+nLRMA1.n+
         ".         LRMASeries1Resize()");
    if(nLRMA1.Resize==0)
          Print("LRMASeries1 number ="+nLRMA1.n+
                ".      LRMASeries1Resize()   ");
         
    return(0.0);
   }
  //----++       ,   LRMASeries1()
  nLRMA1.Error=GetLastError();
  if(nLRMA1.Error>4000)
   {
    Print("LRMASeries1 number ="+nLRMA1.n+
         ".  ,     LRMASeries1() number = "+nLRMA1.n+" !!!");
    Print("LRMASeries1 number ="+nLRMA1.n+ ". ",LRMA_ErrDescr1(nLRMA1.Error));  
   } 
                                                   
  //----++       nLRMA1.number  nLRMA1Resize.Number
  if (ArraySize(nLRMA1.sum_x)< nLRMA1.number) 
   {
    Print("LRMASeries1 number ="+nLRMA1.n+
                 ". !!!     nLRMA1.number  LRMASeries1()");
    Print("LRMASeries1 number ="+nLRMA1.n+
          ".       nLRMA1Resize.Size  LRMASeries1Resize()");
    return(0.0);
   }
 }
//----++ +====================================================================================================+ 
  
if (nLRMA1.bar>nLRMA1.MaxBar){nLRMA1.reset=0;return(0.0);}

if(nLRMA1.bar!=nLRMA1.limit)
        for(nLRMA1.iii=nLRMA1.period;nLRMA1.iii>=0;nLRMA1.iii--)
                                          dLRMA1.TempBuffer[nLRMA1.n][nLRMA1.iii+1]=
                                                                dLRMA1.TempBuffer[nLRMA1.n][nLRMA1.iii];
dLRMA1.TempBuffer[nLRMA1.n][0]=dLRMA1.series;

if (nLRMA1.period<3)nLRMA1.period=3;
else if (nLRMA1.period>nLRMA1.rangeMin){nLRMA1.period=nLRMA1.rangeMin;}

if (nLRMA1.bar> nLRMA1.MaxBar-nLRMA1.period){nLRMA1.reset=0;return(0.0);}

//----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSS+
if (nLRMA1.bar==nLRMA1.MaxBar-nLRMA1.period)
 {
  nLRMA1.Test[nLRMA1.n]=1;
  for(nLRMA1.iii=1;nLRMA1.iii<=nLRMA1.period;nLRMA1.iii++)
   {
    nLRMA1.sum_x[nLRMA1.n]  += nLRMA1.iii;
    nLRMA1.sum_x2[nLRMA1.n] += nLRMA1.iii * nLRMA1.iii;
   }
  dLRMA1.den_x[nLRMA1.n] = nLRMA1.period * nLRMA1.sum_x2[nLRMA1.n] 
                - nLRMA1.sum_x[nLRMA1.n] * nLRMA1.sum_x[nLRMA1.n];
 }
//----++ SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

if (nLRMA1.period<1)nLRMA1.period=1;

//----++        nLRMA1.bar
if((nLRMA1.limit>=nLRMA1.MaxBar)&&(nLRMA1.bar==0))
  if((nLRMA1.MaxBar>nLRMA1.period)&&(nLRMA1.Test[nLRMA1.n]==0))
                        Print("LRMASeries1 number ="+nLRMA1.n+
                        ". !!!      nLRMA1.bar   !!!");  

//----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
if((nLRMA1.bar==nLRMA1.limit)&&(nLRMA1.limit<nLRMA1.MaxBar))
  {

   nLRMA1.Tnew=Time[nLRMA1.limit+1];
   nLRMA1.Told=nLRMA1.TIME[nLRMA1.n];
    //--+
   if(nLRMA1.Tnew==nLRMA1.Told)
   for(nLRMA1.iii=nLRMA1.period;nLRMA1.iii>=1;nLRMA1.iii--)
                               dLRMA1.TempBuffer[nLRMA1.n][nLRMA1.iii]=
                                               dLRMA1.TEMPBUFFER[nLRMA1.n][nLRMA1.iii];  
   //--+   
   if(nLRMA1.Tnew!=nLRMA1.Told)
    {
     nLRMA1.reset=-1;
     //--+       nLRMA1.limit  LRMASeries1()
     if (nLRMA1.Tnew>nLRMA1.Told)
       {
       Print("LRMASeries1 number ="+nLRMA1.n+
                           ". !!!  nLRMA1.limit  LRMASeries1() ,  ");
       }
     else 
       { 
       int nLRMA1.LimitERROR=nLRMA1.limit+1-iBarShift(NULL,0,nLRMA1.Told,TRUE);
       Print("LRMASeries1 number ="+nLRMA1.n+
               ". !!!  nLRMA1.limit  LRMASeries1() ,    "
                                                                                     +nLRMA1.LimitERROR+"");
       }
     //--+   nLRMA1.reset=-1;     LRMASeries1
     return(0);
    } 
  }                    
//----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//+---    +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
if ((nLRMA1.bar==0)&&(nLRMA1.limit!=0))
 {
  nLRMA1.TIME[nLRMA1.n]=Time[1];
  for(nLRMA1.iii=nLRMA1.period;nLRMA1.iii>=1;nLRMA1.iii--)
                        dLRMA1.TEMPBUFFER[nLRMA1.n][nLRMA1.iii]=
                                dLRMA1.TempBuffer[nLRMA1.n][nLRMA1.iii];      
 }
//+---+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

  nLRMA1.loop_begin = nLRMA1.period - 1;
  dLRMA1.sum_y   = 0.0;
  dLRMA1.sum_xy  = 0.0;
  for (nLRMA1.iii = 1; nLRMA1.iii<=nLRMA1.period; nLRMA1.iii++)
   {
    dLRMA1.var_tmp  = dLRMA1.TempBuffer[nLRMA1.n][nLRMA1.loop_begin-nLRMA1.iii+1];  
    dLRMA1.sum_y   += dLRMA1.var_tmp;
    dLRMA1.sum_xy  += nLRMA1.iii * dLRMA1.var_tmp; 
   }
  dLRMA1.B = (nLRMA1.period * dLRMA1.sum_xy - nLRMA1.sum_x[nLRMA1.n] * dLRMA1.sum_y) / dLRMA1.den_x[nLRMA1.n];
  dLRMA1.A = (dLRMA1.sum_y - dLRMA1.B * nLRMA1.sum_x[nLRMA1.n]) / nLRMA1.period;             
  //
  dLRMA1.ret_val = dLRMA1.A + dLRMA1.B * nLRMA1.period;   
 //----
 //----++         JLRMASeries1()
 nLRMA1.Error=GetLastError();
 if(nLRMA1.Error>4000)
   {
    Print("LRMASeries1 number ="+nLRMA1.n+".    LRMASeries1()  !!!");
    Print("LRMASeries1 number ="+nLRMA1.n+ ". ",LRMA_ErrDescr1(nLRMA1.Error));   
    return(0.0);
   }
  nLRMA1.reset=0;
  return(dLRMA1.ret_val);
  
//----+     LRMASeries1() --------------------------+  
}
//--+ --------------------------------------------------------------------------------------------+

//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// LRMASeries1Resize -              | 
//  LRMASeries1.  : LRMASeries1Resize(5);  5 -    | 
// LRMASeries1()  .      LRMASeries1Resize   |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int LRMASeries1Resize(int nLRMA1Resize.Size)
 {
//----+
  if(nLRMA1Resize.Size<1)
   {
    Print("LRMASeries1Resize: !!!  nLRMA1Resize.Size     !!!"); 
    nLRMA1.Resize=-1; 
    return(0);
   }
  //----+    
  nLRMA1.rangeMin=ArrayRange(dLRMA1.TempBuffer,1)-1; 
  if(nLRMA1Resize.Size==-2)return(nLRMA1.rangeMin);
  //----+  
  int nLRMA1Resize.reset,nLRMA1Resize.cycle;
  //--+
  while(nLRMA1Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    if(ArrayResize(dLRMA1.TempBuffer,nLRMA1Resize.Size)==0){nLRMA1Resize.reset=-1;break;}
    if(ArrayResize(nLRMA1.sum_x ,    nLRMA1Resize.Size)==0){nLRMA1Resize.reset=-1;break;}
    if(ArrayResize(nLRMA1.sum_x2,    nLRMA1Resize.Size)==0){nLRMA1Resize.reset=-1;break;}
    if(ArrayResize(dLRMA1.den_x,     nLRMA1Resize.Size)==0){nLRMA1Resize.reset=-1;break;}
    if(ArrayResize(nLRMA1.Test,      nLRMA1Resize.Size)==0){nLRMA1Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nLRMA1Resize.cycle=1;
   }
  //--+
  if(nLRMA1Resize.reset==-1)
   {
    Print("LRMASeries1Resize: !!!        LRMASeries1().");
    int nLRMA1Resize.Error=GetLastError();
    if(nLRMA1Resize.Error>4000)Print("LRMASeries1Resize: ",LRMA_ErrDescr1(nLRMA1Resize.Error));    
    nLRMA1.Resize=-2;
    return(0);
   }
  else  
   {
    Print("LRMASeries1Resize: LRMASeries1 Size = "+nLRMA1Resize.Size+"");
    nLRMA1.Resize=nLRMA1Resize.Size;
    return(nLRMA1Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
LRMASeries1Alert -                    |
 LRMASeries1.                                                                                     |
  --------------------------    --------------------------                               |
LRMASeries1Alert.Number                                                                                  |
LRMASeries1Alert.ExternVar      nLRMA1.Phase                        |
LRMASeries1Alert.name      nLRMA1.Length,  LRMASeries1Alert.Number=0.|                                                  
  --------------------------    -----------------------                               |
  int init()                                                                                             |
//----                                                                                                   |
 -                                                        |
                                                                                                         |
//----                                            |                                                           
LRMASeries1Alert(0,"Length1",Length1);                                                                   |
LRMASeries1Alert(0,"Length2",Length2);                                                                   |
//----                                                                            |
return(0);                                                                                               |
}                                                                                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void LRMASeries1Alert
 (
  int LRMASeries1Alert.Number, string LRMASeries1Alert.name, int LRMASeries1Alert.ExternVar
 )
 {
  //----        ==================================================+ 
   if(LRMASeries1Alert.Number==0)if(LRMASeries1Alert.ExternVar<3)
          {Alert(" "+LRMASeries1Alert.ExternVar+"     3" 
          + "    " +LRMASeries1Alert.ExternVar+ "   3");}
   int LRMASeries1Alert.MaxPeriod=ArrayRange(dLRMA1.TempBuffer,1);  
   if(LRMASeries1Alert.Number==0)if((LRMASeries1Alert.ExternVar>LRMASeries1Alert.MaxPeriod))
          {Alert(" "+LRMASeries1Alert.name+"     "+LRMASeries1Alert.MaxPeriod+"" 
          + "    " +LRMASeries1Alert.ExternVar+ "    "+LRMASeries1Alert.MaxPeriod+""
          + "      nLRMA1.period,    "
          +" dLRMA1.TempBuffer  LRMASeries1" );}
          
 }
//--+ -------------------------------------------------------------------------------------------------------------------+

//     01.12.2006  
//+------------------------------------------------------------------+
//|                                     LRMA_ErrDescr1_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string LRMA_ErrDescr1(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

