//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                             LRMASeries0(Exp).mqh |
//|                             LRMA code: Copyright  2005, alexjou |
//|            MQL4 LRMASeries0() Copyright  2006, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  LRMASeries0() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    LRMASeries0()              , 
                  .            ():
  MetaTrader\experts\include\.      ,         nLRMA0.bar  ,    nLRMA0.MaxBar,    
  LRMASeries0()    !   ! , ,     
    -    !    LRMASeries0()    
        ,        .      LRMASeries0()
         ,        
    !         LRMASeries0(),  
       nLRMA0....  dLRMA0....    LRMASeries0()   
  ,        .    LRMASeries0()        
    ,          ,       
       LRMASeries0()      (nLRMA0.number). 

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nLRMA0.n      -      LRMASeries0(). (0, 1, 2, 3 ......)
  nLRMA0.MaxBar -  ,        (nLRMA0.bar).   
                  Bars-1-period;  "period" -    ,       dLRMA0.series   
                  ; 
  nLRMA0.limit  -          ,  
  nLRMA0.Period -  .      !       
                  500.                ,            
                  dLRMA0.TempBuffer[1][500]   dLRMA0.TEMPBUFFER[1][500].        
                  3.
  dLRMA0.series -   ,      LRMASeries0();
  nLRMA0.bar    -   ,            
                  .          nLRMA0.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  LRMASeries0() -   dLRMA0.ret_val.     nLRMA0.bar      nLRMA0.MaxBar-nLRMA0.Length 
                   LRMASeries0()   !!!
  nLRMA0.reset  - ,    ,   0 ,       ,
                  0,    .      ,   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

          LRMASeries0()  ,          0,   
        ,            LRMASeries0() 
        LRMASeries0Resize()        :  LRMASeries0Resize(MaxLRMA.number+1);
        nLRMA0.n(MaxLRMA.number)      LRMASeries0,   
   ,   nLRMA0.n. 

  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .      LRMASeries0()       \MetaTrader\EXPERTS\LOGS\. ,   
    LRMASeries0()  ,   ,  MQL4 ,       
     .     LRMASeries0()  LRMASeries0()  MQL4 ,
                   .      
    LRMASeries0()  nLRMA0.number        nJLRMAResize.Size()  
                  .       
      nLRMA0.limit.      init()   
            LRMASeries0(),   LRMASeries0Resize ()    
              .      LRMASeries0() 
                nLRMA0.bar,    
         .  ,        
         ,   LRMASeries0()       ,  
       .      LRMASeries0()   
                  .     
          ,             init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+

//----+   LRMASeries0()
#include <LRMASeries0.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1      (    LRMASeries0()     !!!)
SetIndexBuffer(0,Ind_Buffer);
//----+      LRMASeries0, nLRMA0.n=1(    LRMASeries0)
if(LRMASeries0Resize(1)==0)return(-1);
return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    LRMASeries0()  0    Ind_Buffer[], 
  double Resalt=LRMASeries0(0,MaxBar,limit,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 

*/
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< LRMASeries0()>>> +++++++++++++++++++++++++++++++++++++++++++++++++---++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSS+ 
double dLRMA0.TempBuffer[1][501], dLRMA0.TEMPBUFFER[1][501],dLRMA0.den_x[1];
int nLRMA0.range1, nLRMA0.range2, nLRMA0.rangeMin; 
int nLRMA0.sum_x[1], nLRMA0.sum_x2[1], nLRMA0.TIME[1], nLRMA0.Test[1];
//----++
double dLRMA0.sum_y, dLRMA0.sum_xy, dLRMA0.var_tmp;
double dLRMA0.A, dLRMA0.B, dLRMA0.ret_val;
int    nLRMA0.iii, nLRMA0.loop_begin,nLRMA0.Error,nLRMA0.Tnew,nLRMA0.Told,nLRMA0.n,nLRMA0.Resize;

//----++ <<<   LRMASeries0() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

double LRMASeries0
 (
  int nLRMA0.number,int nLRMA0.MaxBar,int nLRMA0.limit,int nLRMA0.period,double dLRMA0.series,int nLRMA0.bar,int& nLRMA0.reset
 )
//----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nLRMA0.n=nLRMA0.number;

nLRMA0.reset=1;
//=====+ <<<    >>> ==========================================================================+
if (nLRMA0.bar==nLRMA0.limit)
 {
  //----++     LRMASeries0()
  if(nLRMA0.Resize<1)
   {
    Print("LRMASeries0 number ="+nLRMA0.n+
         ".         LRMASeries0Resize()");
    if(nLRMA0.Resize==0)
          Print("LRMASeries0 number ="+nLRMA0.n+
                ".      LRMASeries0Resize()   ");
         
    return(0.0);
   }
  //----++       ,   LRMASeries0()
  nLRMA0.Error=GetLastError();
  if(nLRMA0.Error>4000)
   {
    Print("LRMASeries0 number ="+nLRMA0.n+
         ".  ,     LRMASeries0() number = "+nLRMA0.n+" !!!");
    Print("LRMASeries0 number ="+nLRMA0.n+ ". ",LRMA_ErrDescr0(nLRMA0.Error));  
   } 
                                                   
  //----++       nLRMA0.number  nLRMA0Resize.Number
  if (ArraySize(nLRMA0.sum_x)< nLRMA0.number) 
   {
    Print("LRMASeries0 number ="+nLRMA0.n+
                 ". !!!     nLRMA0.number  LRMASeries0()");
    Print("LRMASeries0 number ="+nLRMA0.n+
          ".       nLRMA0Resize.Size  LRMASeries0Resize()");
    return(0.0);
   }
 }
//----++ +====================================================================================================+ 
  
if (nLRMA0.bar>nLRMA0.MaxBar){nLRMA0.reset=0;return(0.0);}

if(nLRMA0.bar!=nLRMA0.limit)
        for(nLRMA0.iii=nLRMA0.period;nLRMA0.iii>=0;nLRMA0.iii--)
                                          dLRMA0.TempBuffer[nLRMA0.n][nLRMA0.iii+1]=
                                                                dLRMA0.TempBuffer[nLRMA0.n][nLRMA0.iii];
dLRMA0.TempBuffer[nLRMA0.n][0]=dLRMA0.series;

if (nLRMA0.period<3)nLRMA0.period=3;
else if (nLRMA0.period>nLRMA0.rangeMin){nLRMA0.period=nLRMA0.rangeMin;}

if (nLRMA0.bar> nLRMA0.MaxBar-nLRMA0.period){nLRMA0.reset=0;return(0.0);}

//----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSS+
if (nLRMA0.bar==nLRMA0.MaxBar-nLRMA0.period)
 {
  nLRMA0.Test[nLRMA0.n]=1;
  for(nLRMA0.iii=1;nLRMA0.iii<=nLRMA0.period;nLRMA0.iii++)
   {
    nLRMA0.sum_x[nLRMA0.n]  += nLRMA0.iii;
    nLRMA0.sum_x2[nLRMA0.n] += nLRMA0.iii * nLRMA0.iii;
   }
  dLRMA0.den_x[nLRMA0.n] = nLRMA0.period * nLRMA0.sum_x2[nLRMA0.n] 
                - nLRMA0.sum_x[nLRMA0.n] * nLRMA0.sum_x[nLRMA0.n];
 }
//----++ SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

if (nLRMA0.period<1)nLRMA0.period=1;

//----++        nLRMA0.bar
if((nLRMA0.limit>=nLRMA0.MaxBar)&&(nLRMA0.bar==0))
  if((nLRMA0.MaxBar>nLRMA0.period)&&(nLRMA0.Test[nLRMA0.n]==0))
                        Print("LRMASeries0 number ="+nLRMA0.n+
                        ". !!!      nLRMA0.bar   !!!");  

//----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
if((nLRMA0.bar==nLRMA0.limit)&&(nLRMA0.limit<nLRMA0.MaxBar))
  {

   nLRMA0.Tnew=Time[nLRMA0.limit+1];
   nLRMA0.Told=nLRMA0.TIME[nLRMA0.n];
    //--+
   if(nLRMA0.Tnew==nLRMA0.Told)
   for(nLRMA0.iii=nLRMA0.period;nLRMA0.iii>=1;nLRMA0.iii--)
                               dLRMA0.TempBuffer[nLRMA0.n][nLRMA0.iii]=
                                               dLRMA0.TEMPBUFFER[nLRMA0.n][nLRMA0.iii];  
   //--+   
   if(nLRMA0.Tnew!=nLRMA0.Told)
    {
     nLRMA0.reset=-1;
     //--+       nLRMA0.limit  LRMASeries0()
     if (nLRMA0.Tnew>nLRMA0.Told)
       {
       Print("LRMASeries0 number ="+nLRMA0.n+
                           ". !!!  nLRMA0.limit  LRMASeries0() ,  ");
       }
     else 
       { 
       int nLRMA0.LimitERROR=nLRMA0.limit+1-iBarShift(NULL,0,nLRMA0.Told,TRUE);
       Print("LRMASeries0 number ="+nLRMA0.n+
               ". !!!  nLRMA0.limit  LRMASeries0() ,    "
                                                                                     +nLRMA0.LimitERROR+"");
       }
     //--+   nLRMA0.reset=-1;     LRMASeries0
     return(0);
    } 
  }                    
//----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//+---    +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
if ((nLRMA0.bar==0)&&(nLRMA0.limit!=0))
 {
  nLRMA0.TIME[nLRMA0.n]=Time[1];
  for(nLRMA0.iii=nLRMA0.period;nLRMA0.iii>=1;nLRMA0.iii--)
                        dLRMA0.TEMPBUFFER[nLRMA0.n][nLRMA0.iii]=
                                dLRMA0.TempBuffer[nLRMA0.n][nLRMA0.iii];      
 }
//+---+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+  

  nLRMA0.loop_begin = nLRMA0.period - 1;
  dLRMA0.sum_y   = 0.0;
  dLRMA0.sum_xy  = 0.0;
  for (nLRMA0.iii = 1; nLRMA0.iii<=nLRMA0.period; nLRMA0.iii++)
   {
    dLRMA0.var_tmp  = dLRMA0.TempBuffer[nLRMA0.n][nLRMA0.loop_begin-nLRMA0.iii+1];  
    dLRMA0.sum_y   += dLRMA0.var_tmp;
    dLRMA0.sum_xy  += nLRMA0.iii * dLRMA0.var_tmp; 
   }
  dLRMA0.B = (nLRMA0.period * dLRMA0.sum_xy - nLRMA0.sum_x[nLRMA0.n] * dLRMA0.sum_y) / dLRMA0.den_x[nLRMA0.n];
  dLRMA0.A = (dLRMA0.sum_y - dLRMA0.B * nLRMA0.sum_x[nLRMA0.n]) / nLRMA0.period;             
  //
  dLRMA0.ret_val = dLRMA0.A + dLRMA0.B * nLRMA0.period;   
 //----
 //----++         JLRMASeries0()
 nLRMA0.Error=GetLastError();
 if(nLRMA0.Error>4000)
   {
    Print("LRMASeries0 number ="+nLRMA0.n+".    LRMASeries0()  !!!");
    Print("LRMASeries0 number ="+nLRMA0.n+ ". ",LRMA_ErrDescr0(nLRMA0.Error));   
    return(0.0);
   }
  nLRMA0.reset=0;
  return(dLRMA0.ret_val);
  
//----+     LRMASeries0() --------------------------+  
}
//--+ --------------------------------------------------------------------------------------------+

//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// LRMASeries0Resize -              | 
//  LRMASeries0.  : LRMASeries0Resize(5);  5 -    | 
// LRMASeries0()  .      LRMASeries0Resize   |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int LRMASeries0Resize(int nLRMA0Resize.Size)
 {
//----+
  if(nLRMA0Resize.Size<1)
   {
    Print("LRMASeries0Resize: !!!  nLRMA0Resize.Size     !!!"); 
    nLRMA0.Resize=-1; 
    return(0);
   }
  //----+    
  nLRMA0.range1=ArrayRange(dLRMA0.TempBuffer,1)-1; 
  nLRMA0.range2=ArrayRange(dLRMA0.TEMPBUFFER,1)-1;   
  nLRMA0.rangeMin=MathMin(nLRMA0.range1,nLRMA0.range2);
  if(nLRMA0Resize.Size==-2)return(nLRMA0.rangeMin);
  //----+  
  int nLRMA0Resize.reset,nLRMA0Resize.cycle;
  //--+
  while(nLRMA0Resize.cycle==0)
   {
    //----++ <<<     >>>  +SSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    if(ArrayResize(dLRMA0.TempBuffer,nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(dLRMA0.TEMPBUFFER,nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(nLRMA0.sum_x ,    nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(nLRMA0.sum_x2,    nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(dLRMA0.den_x,     nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(nLRMA0.TIME,      nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    if(ArrayResize(nLRMA0.Test,      nLRMA0Resize.Size)==0){nLRMA0Resize.reset=-1;break;}
    //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nLRMA0Resize.cycle=1;
   }
  //--+
  if(nLRMA0Resize.reset==-1)
   {
    Print("LRMASeries0Resize: !!!        LRMASeries0().");
    int nLRMA0Resize.Error=GetLastError();
    if(nLRMA0Resize.Error>4000)Print("LRMASeries0Resize: ",LRMA_ErrDescr0(nLRMA0Resize.Error));    
    nLRMA0.Resize=-2;
    return(0);
   }
  else  
   {
    Print("LRMASeries0Resize: LRMASeries0 Size = "+nLRMA0Resize.Size+"");
    nLRMA0.Resize=nLRMA0Resize.Size;
    return(nLRMA0Resize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
LRMASeries0Alert -                    |
 LRMASeries0.                                                                                     |
  --------------------------    --------------------------                               |
LRMASeries0Alert.Number                                                                                  |
LRMASeries0Alert.ExternVar      nLRMA0.Phase                        |
LRMASeries0Alert.name      nLRMA0.Length,  LRMASeries0Alert.Number=0.|                                                  
  --------------------------    -----------------------                               |
  int init()                                                                                             |
//----                                                                                                   |
 -                                                        |
                                                                                                         |
//----                                            |                                                           
LRMASeries0Alert(0,"Length1",Length1);                                                                   |
LRMASeries0Alert(0,"Length2",Length2);                                                                   |
//----                                                                            |
return(0);                                                                                               |
}                                                                                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void LRMASeries0Alert
 (
  int LRMASeries0Alert.Number, string LRMASeries0Alert.name, int LRMASeries0Alert.ExternVar
 )
 {
  //----        ==========================+ 
   if(LRMASeries0Alert.Number==0)if(LRMASeries0Alert.ExternVar<3)
          {Alert(" "+LRMASeries0Alert.ExternVar+"     3" 
          + "    " +LRMASeries0Alert.ExternVar+ "    3");}
   int LRMASeries0Alert.MaxPeriod=ArrayRange(dLRMA0.TempBuffer,1);  
   if(LRMASeries0Alert.Number==0)if((LRMASeries0Alert.ExternVar>LRMASeries0Alert.MaxPeriod))
          {Alert(" "+LRMASeries0Alert.name+"     "+LRMASeries0Alert.MaxPeriod+"" 
          + "    " +LRMASeries0Alert.ExternVar+ "    "+LRMASeries0Alert.MaxPeriod+""
          + "      nLRMA0.period,    "
          +" dLRMA0.TempBuffer  dLRMA0.TEMPBUFFER  LRMASeries0" );}
          
 }
//--+ -------------------------------------------------------------------------------------------+

//     01.12.2006  
//+------------------------------------------------------------------+
//|                                     LRMA_ErrDescr0_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string LRMA_ErrDescr0(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+

