//Version  January 7, 2007 Final
//+------------------------------------------------------------------+
//|                                                JLiteSeries().mqh |
//|                 JMA code: Copyright  1998,       Jurik Research |
//|                                          http://www.jurikres.com | 
//|       JLiteSeries() MQL4: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
  /*

  +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS <<<  JLiteSeries() >>> SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

  +-----------------------------------------+ <<<  >>> +----------------------------------------------------+

    JLiteSeries()      JLite       
  ,                .     ,  
  nJLite.limit    ,   !  ,    JLiteSeries(),   
    .         MetaTrader\experts\include\   JLiteSeries() - 
        JJMASeries,          .        
  ,      JLiteSeries(),       JLiteSeries()
        ,     JJMASeries().  JLiteSeries()       
            .          JJMASeries 
  JLiteSeries()!!!       JJMASeries  JLiteSeries()     
    #include  <JJMASeries.mqh>   #include <JLiteSeries.mqh> .  ,   nJLite.bar ,
    nJLite.MaxBar,     JLiteSeries()    !   ! , , 
              -        !      
  JLiteSeries(Exp)            ,   
  .        JLiteSeries()         , 
                   !      
    JLiteSeries(),       nJLite....  dJLite...
   JLiteSeries()         ,    
      ,                 JLiteSeries()
       (nJLite.number).

  +-------------------------------------+ <<<   >>> +-------------------------------------------------+

  nJLite.number -      JLiteSeries. (0, 1, 2, 3 ......)
  nJLite.dinJ   - ,       nJLite.Length  nJLite.Phase     . 0 -  
                   ,     - .
  nJLite.MaxBar -  ,        (nJLite.bar).   
                  Bars-1-period;  "period" -   ,         dJLite.series  
                  ;
  nJLite.limit  -            .    
                    Bars-IndicatorCounted()-1;
  nJLite.Length -  
  nJLite.Phase  - ,    -100 ... +100,     ;
  dJLite.series -   ,      JLiteSeries();
  nJLite.bar    -   ,            
                  .            nJMA.limit!!!

  +------------------------------------+ <<<   >>> +-------------------------------------------------+

  JJMASeries()  -   dJLite.JLite().       nJLite.bar      nJLite.MaxBar-30   
                  JJMASeries()   !!!
  nJLite.reset  - ,    ,   0 ,      ,
                  0,    .      ,   !!!

  +-----------------------------------+ <<<   >>> +-----------------------------------------------+

      JLiteSeries() ,       0, (    
           ),      
      ,        JLiteSeries()   
  JJMASeriesResize        :  JJMASeriesResize(MaxJLite.number+1);      
  nJLite.number(MaxJLite.number)           JLiteSeries,     , 
   nJLite.number. 
    
  +--------------------------------------+ <<<   >>> +-------------------------------------------------+
  
           ,       
  .      JLiteSeries()       \MetaTrader\EXPERTS\LOGS\. ,   
    JLiteSeries()  ,   ,  MQL4 ,       
        .         JLiteSeries()   JLiteSeries()  MQL4
  ,            .     
      JLiteSeries()  nJLite.number       nJLiteResize.Size  
                  .       
      nJLite.limit.      init()   
            JLiteSeries(),    JLiteSeriesResize()    
              .      JLiteSeries() 
            nJMA.bar,     
     .  ,          
     ,   JLiteSeries()       ,    
        .      JLiteSeries()     
             .      
           ,       init(). 
  
  +---------------------------------+ <<<     >>> +--------------------------------------------+

//----+   JLiteSeries() 
#include <JLiteSeries.mqh>
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----    
SetIndexStyle (0,DRAW_LINE); 
//---- 1     
SetIndexBuffer(0,Ind_Buffer);
//----+      JLiteSeries, nJLite.number=1(    JLiteSeries)
if(JJMASeriesResize(1)==0)return(-1);

return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator function                                        |
//+------------------------------------------------------------------+
int start()
{
//----+        
int reset,bar,MaxBar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       (    JLiteSeries()     !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;
MaxBar=Bars-1;
//----+ 
for(bar=limit;bar>=0;bar--)
 (
  double Series=Close[bar];
  //----+    JLiteSeries()   0    Ind_Buffer[] 
  // nJLite.Phase  nJLite.Length      (nJLite.din=0) 
  double Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,Series,bar,reset);
  if (reset!=0)return(-1);
  Ind_Buffer[bar]=Resalt;
 }
return(0);
}
//----+ 

  */
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
//+++++++++++++++++++++++++++++++++++++++++++++++++++++ <<< JLiteSeries() >>> +++++++++++++++++++++++++++++++++++++++++++++++++++++++|
//SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+

//----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double dJLite.fB0,dJLite.fD0,dJLite.fA8[1],dJLite.fA8m[1],dJLite.fC0[1],dJLite.fC0m[1],dJLite.fC8[1];
double dJLite.fC8m[1],dJLite.Kg[1],dJLite.Pf[1],dJLite.fB0dJLite.f20,dJLite.f20,dJLite.f30,dJLite.f40;
double dJLite.JLite[1],dJLite.JLitem[1];
int    nJLite.TIME[1],nJLite.n,nJLite.Error,nJLite.Tnew,nJLite.Told,nJLite.size,nJLite.Resize;

//----++ <<<   JurXSeries() >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
double JJMASeries
  (
    int nJLite.number, int    nJLite.din,    int nJLite.MaxBar, int  nJLite.limit, 
    int nJLite.Phase,  int nJLite.Length, double dJLite.series, int  nJLite.bar,    int& nJLite.reset
  )
//----++ +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
{
nJLite.n=nJLite.number;

nJLite.reset=1;
//=====+ <<<    >>> ====================================================================================================+
if (nJLite.bar==nJLite.limit)
 {
  //----++     JLiteSeries()
  if(nJLite.Resize<1)
   {
    Print("JLiteSeries number ="+nJLite.n+
         ".         JLiteSeriesResize()");
    if(nJLite.Resize==0)
          Print("JLiteSeries number ="+nJLite.n+
                ".      JLiteSeriesResize()   ");
         
    return(0.0);
   }
  //----++       ,   JLiteSeries() 
  nJLite.Error=GetLastError();
  if(nJLite.Error>4000)
   {
    Print("JLiteSeries number ="+nJLite.n+
        ".  ,     JLiteSeries() number = "
                                                                    +nJLite.n+" !!!");
    Print("JLiteSeries number ="+nJLite.n+ ". ",JLite_ErrDescr(nJLite.Error));  
   }

  //----++       nJLite.number  nJLiteResize.Size
  nJLite.size=ArraySize(dJLite.fC0);
  if (nJLite.size< nJLite.n) 
   {
    Print("JLiteSeries number ="+nJLite.n+
                ". !!!     nJLite.number="
                                                          +nJLite.n+"  JLiteSeries()");
    Print("JLiteSeries number ="+nJLite.n+
                ".       nJLiteResize.Size="
                                                  +nJLite.size+"  JJMASeriesResize()");
    return(0.0);
   }
 }
//----++        nJLite.bar
if((nJLite.limit>=nJLite.MaxBar)&&(nJLite.bar==0))
    if((nJLite.MaxBar>30)&&(nJLite.TIME[nJLite.n]==0))
                  Print("JLiteSeries number ="+nJLite.n+
                        ". !!!      nJLite.bar   !!!");  
//----++ +==============================================================================================================================+  
if (nJLite.bar> nJLite.MaxBar){nJLite.reset=0;return(0.0);}
if((nJLite.bar==nJLite.MaxBar)||(nJLite.din!=0))
  {
   //----++ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   double dJLite.Dr;
   if(nJLite.Length < 1.0000000002) dJLite.Dr = 0.0000000001;
   else dJLite.Dr= (nJLite.Length - 1.0) / 2.0;
   dJLite.Kg[nJLite.n] = 0.9*dJLite.Dr/(dJLite.Dr + 2.0);
   //--+
   if((nJLite.Phase >= -100)&&(nJLite.Phase <= 100))dJLite.Pf[nJLite.n] = nJLite.Phase / 100.0 + 1.5;
   if (nJLite.Phase >  100) dJLite.Pf[nJLite.n] = 2.5;
   if (nJLite.Phase < -100) dJLite.Pf[nJLite.n] = 0.5;
   //----++SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }

//--+
if((nJLite.bar==nJLite.limit)&&(nJLite.limit<nJLite.MaxBar))
  {
   //----+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   nJLite.Tnew=Time[nJLite.limit+1];
   nJLite.Told=nJLite.TIME[nJLite.n];
   //--+
   if(nJLite.Tnew==nJLite.Told)
    {
     dJLite.fC0[nJLite.n]=dJLite.fC0m[nJLite.n];dJLite.fC8  [nJLite.n]=dJLite.fC8m  [nJLite.n];
     dJLite.fA8[nJLite.n]=dJLite.fA8m[nJLite.n];dJLite.JLite[nJLite.n]=dJLite.JLitem[nJLite.n];
    }
   //--+   
   if(nJLite.Tnew!=nJLite.TIME[nJLite.n])
    {
     nJLite.reset=-1;
     //--+       nJLite.limit  JLiteSeries()
     if (nJLite.Tnew>nJLite.TIME[nJLite.n])
      {
       Print("JLiteSeries number ="+nJLite.n+
              ". !!!  nJLite.limit  JLiteSeries() ,  ");
      }
    else 
      { 
       int nJLite.LimitERROR=nJLite.limit+1-iBarShift(NULL,0,nJLite.TIME[nJLite.n],TRUE);
       Print("JLiteSeries number ="+nJLite.n+
            ". !!!  nJLite.limit  JLiteSeries() ,    "
                                                                                +nJLite.LimitERROR+"");
      }
    //--+   nJLite.reset=-1;     JLiteSeries
    return(0);
   }
//----+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }
if ((nJLite.bar==1)&&( nJLite.limit!=1))
  {
   //--+ <<<    >>> +SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
   dJLite.fC0m[nJLite.n]=dJLite.fC0[nJLite.n];dJLite.fC8m  [nJLite.n]=dJLite.fC8  [nJLite.n];
   dJLite.fA8m[nJLite.n]=dJLite.fA8[nJLite.n];dJLite.JLitem[nJLite.n]=dJLite.JLite[nJLite.n];
   nJLite.TIME[nJLite.n]=Time[2];
   //--+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
  }

dJLite.f30 = MathPow(dJLite.Kg[nJLite.n], 1);
dJLite.fC0[nJLite.n] =(1.0 - dJLite.f30) * dJLite.series + dJLite.f30 * dJLite.fC0[nJLite.n];
dJLite.fC8[nJLite.n] =(dJLite.series - dJLite.fC0[nJLite.n]) 
                  * (1.0 - dJLite.Kg[nJLite.n]) + dJLite.Kg[nJLite.n] * dJLite.fC8[nJLite.n];
dJLite.fD0 = dJLite.Pf[nJLite.n] * dJLite.fC8[nJLite.n] + dJLite.fC0[nJLite.n];
dJLite.f20 = dJLite.f30 *(-2.0);
dJLite.f40 = dJLite.f30 * dJLite.f30;
dJLite.fB0 = dJLite.f20 + dJLite.f40 + 1.0;
dJLite.fA8[nJLite.n] =(dJLite.fD0 - dJLite.JLite[nJLite.n]) * dJLite.fB0 
                                                         + dJLite.f40 * dJLite.fA8[nJLite.n];
dJLite.JLite[nJLite.n] = dJLite.JLite[nJLite.n] + dJLite.fA8[nJLite.n];
//----+  
nJLite.Error=GetLastError();
//----++         JLiteSeries()
if(nJLite.Error>1)
  {
   Print("JLiteSeries number ="+nJLite.n+".    JLiteSeries()  !!!");
   Print("JLiteSeries number ="+nJLite.n+ ". ",JLite_ErrDescr(nJLite.Error));  
   return(0.0);
  }
nJLite.reset=0;
if (nJLite.bar>=nJLite.MaxBar-30-2*nJLite.Length)return(0.0);
else return(dJLite.JLite[nJLite.n]);
//----+     JLiteSeries() --------------------------+
}
//--+ --------------------------------------------------------------------------------------------+

//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
// JLiteSeriesReset -               | 
//  JLiteSeries.  : JLiteSeriesReset(5);  5 -     | 
// JLiteSeries()   .      JLiteSeriesReset   |
//                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
int JJMASeriesResize(int nJLiteResize.Size)
 {
//----+
  if(nJLiteResize.Size<1)
   {
    Print("JJMASeriesResize: !!!  nJLiteResize.Size     !!!"); 
    nJLite.Resize=-1; 
    return(0);
   }  
  int nJLiteResize.reset,nJLiteResize.cycle;
  //--+
  while(nJLiteResize.cycle==0)
   {
    //----++ <<<     >>> +SSSSSSSSSSSSSSSSSSSSSSSS+
    if(ArrayResize(dJLite.Kg,    nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.Pf,    nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fA8,   nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fC0,   nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fC8,   nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.JLite, nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fA8m,  nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fC0m,  nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.fC8m,  nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(dJLite.JLitem,nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    if(ArrayResize(nJLite.TIME,  nJLiteResize.Size)==0){nJLiteResize.reset=-1;break;}
    //+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
    nJLiteResize.cycle=1;
   }
  //--+
  if(nJLiteResize.reset==-1)
   {
    Print("JLiteSeriesResize: !!!        JLiteSeries().");
    int nJLiteResize.Error=GetLastError();
    if(nJLiteResize.Error>4000)Print("JJMASeriesResize(): ",JLite_ErrDescr(nJLiteResize.Error));       
    nJLite.Resize=-2;
    return(0);
   }
  else  
   {
    Print("JLiteSeriesResize: JLiteSeries() size = "+nJLiteResize.Size+"");
    nJLite.Resize=nJLiteResize.Size;
    return(nJLiteResize.Size);
   }  
//----+
 }
//--+ --------------------------------------------------------------------------------------------+
/*
//--+ ---------------------------------------------------------------------------------------------------+
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
JJMASeriesAlert -                     |
 JLiteSeries.                                                                                     |
  --------------------------    --------------------------                               |
JLiteSeriesAlert.Number                                                                                  |
JLiteSeriesAlert.ExternVar      nJLite.Length                       |
JLiteSeriesAlert.name      nJLite.Phase,  JLiteSeriesAlert.Number=0  | 
 nJLite.Phase,  JLiteSeriesAlert.Number=1.                                                        |
  --------------------------    -----------------------                               |
  int init()                                                                                             |
//----                                                                                                   |
 -                                                            |
                                                                                                         |
//----                                            |
JJMASeriesAlert(0,"Length1",Length1);                                                                    |
JJMASeriesAlert(0,"Length2",Length2);                                                                    |
JJMASeriesAlert(1,"Phase1",Phase1);                                                                      |                                                            
JJMASeriesAlert(1,"Phase2",Phase2);                                                                      |                                                          
//----                                                                            |
return(0);                                                                                               |
}                                                                                                        |
//+SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS+
*/
void JJMASeriesAlert
 (
  int JLiteSeriesAlert.Number, string JLiteSeriesAlert.name, int JLiteSeriesAlert.ExternVar
 )
 {
  //----        ==========================+ 
  if(JLiteSeriesAlert.Number==0)if(JLiteSeriesAlert.ExternVar<1)
          {Alert(" "+JLiteSeriesAlert.name+"     1" 
          + "    " +JLiteSeriesAlert.ExternVar+ "    1"  );}
  if(JLiteSeriesAlert.Number==1)
   {
    if(JLiteSeriesAlert.ExternVar<-100)
          {Alert(" "+JLiteSeriesAlert.name+"    -100  +100" 
          + "    "+JLiteSeriesAlert.ExternVar+  "   -100");}
    if(JLiteSeriesAlert.ExternVar> 100)
          {Alert(" "+JLiteSeriesAlert.name+"    -100  +100" 
          + "    "+JLiteSeriesAlert.ExternVar+  "    100");}
   }
 }
//--+ --------------------------------------------------------------------------------------------+

//     01.12.2006  
//+------------------------------------------------------------------+
//|                                     JLite_ErrDescr_RUS(MQL4).mqh |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
string JLite_ErrDescr(int error_code)
 {
  string error_string;
//----
  switch(error_code)
    {
     //---- MQL4  
     case 4000: error_string="  = "+error_code+".  ";                                                  break;
     case 4001: error_string="  = "+error_code+".   ";                              break;
     case 4002: error_string="  = "+error_code+".      ";                 break;
     case 4003: error_string="  = "+error_code+".     ";                                break;
     case 4004: error_string="  = "+error_code+".     ";                break;
     case 4005: error_string="  = "+error_code+".       ";                 break;
     case 4006: error_string="  = "+error_code+".     ";                         break;
     case 4007: error_string="  = "+error_code+".     ";                             break;
     case 4008: error_string="  = "+error_code+".  ";                                 break;
     case 4009: error_string="  = "+error_code+".    ";                       break;
     case 4010: error_string="  = "+error_code+".     ";                           break;
     case 4011: error_string="  = "+error_code+".   ";                                      break;
     case 4012: error_string="  = "+error_code+".     ";                                  break;
     case 4013: error_string="  = "+error_code+".   ";                                             break;
     case 4014: error_string="  = "+error_code+".  ";                                         break;
     case 4015: error_string="  = "+error_code+".   (never generated error)";                break;
     case 4016: error_string="  = "+error_code+".  ";                                 break;
     case 4017: error_string="  = "+error_code+".  DLL  ";                                     break;
     case 4018: error_string="  = "+error_code+".   ";                             break;
     case 4019: error_string="  = "+error_code+".   ";                                  break;
     case 4020: error_string="  = "+error_code+".      ";            break;
     case 4021: error_string="  = "+error_code+".    ,   ";     break;
     case 4022: error_string="  = "+error_code+".   (never generated error)";                      break;
     case 4050: error_string="  = "+error_code+".    ";                  break;
     case 4051: error_string="  = "+error_code+".    ";                     break;
     case 4052: error_string="  = "+error_code+".    ";                         break;
     case 4053: error_string="  = "+error_code+".  ";                                              break;
     case 4054: error_string="  = "+error_code+".   -";                break;
     case 4055: error_string="  = "+error_code+".   ";                         break;
     case 4056: error_string="  = "+error_code+".  ";                                        break;
     case 4057: error_string="  = "+error_code+".    ";                     break;
     case 4058: error_string="  = "+error_code+".    ";                         break;
     case 4059: error_string="  = "+error_code+".      ";                      break;
     case 4060: error_string="  = "+error_code+".   ";                                     break;
     case 4061: error_string="  = "+error_code+".   ";                                       break;
     case 4062: error_string="  = "+error_code+".    string";                              break;
     case 4063: error_string="  = "+error_code+".    integer";                             break;
     case 4064: error_string="  = "+error_code+".    double";                              break;
     case 4065: error_string="  = "+error_code+".     ";                       break;
     case 4066: error_string="  = "+error_code+".      ";      break;
     case 4067: error_string="  = "+error_code+".     ";                     break;
     case 4099: error_string="  = "+error_code+".  ";                                                 break;
     case 4100: error_string="  = "+error_code+".     ";                                  break;
     case 4101: error_string="  = "+error_code+".   ";                                      break;
     case 4102: error_string="  = "+error_code+".    ";                               break;
     case 4103: error_string="  = "+error_code+".   ";                                     break;
     case 4104: error_string="  = "+error_code+".     ";                         break;
     case 4105: error_string="  = "+error_code+".     ";                                     break;
     case 4106: error_string="  = "+error_code+".  ";                                          break;
     case 4107: error_string="  = "+error_code+".      ";             break;
     case 4108: error_string="  = "+error_code+".   ";                                       break;
     case 4109: error_string="  = "+error_code+".   ";                                       break;
     case 4110: error_string="  = "+error_code+".    ";                                break;
     case 4111: error_string="  = "+error_code+".    ";                               break;
     case 4200: error_string="  = "+error_code+".   ";                                       break;
     case 4201: error_string="  = "+error_code+".    ";                      break;
     case 4202: error_string="  = "+error_code+".   ";                                        break;
     case 4203: error_string="  = "+error_code+".   ";                                     break;
     case 4204: error_string="  = "+error_code+".   ";                                           break;
     case 4205: error_string="  = "+error_code+".   ";                                    break;
     case 4206: error_string="  = "+error_code+".    ";                                break;
     case 4207: error_string="  = "+error_code+".     ";                                break;
     default:   error_string="  = "+error_code+".  ";
    }
//----
  return(error_string);
 }
//+------------------------------------------------------------------+


