/*
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
//Version  July 1, 2006                                              |
Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru        |
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
HTFm.mqh      -    ,          
 ,         
 ,  .        - 
 J2JMA_htfm.mq4
//+------------------------------------------------------------------+
//|                                                         HTFm.mqh |
//|                            Copyright  2006, GS  Conversion only |
//|                    http://www.gustis.narod.ru;     gsb51@mail.ru |
//+------------------------------------------------------------------+
#property copyright "  Copyright  2006, GS  Conversion only"
#property link      " http://www.gustis.narod.ru;     gsb51@mail.ru"
//----     
#property indicator_chart_window
//----   
#property indicator_buffers  1
//----  
#property indicator_color1 Red
*/
//----    -------------------------------------------------------------+
extern int  TFrame_Period = 240; //    
extern int         Smooth = 48;  //   . 
//          
extern int         Shift  = 0;   // c     
//---- ------------------------------------------------------------------------------------------+
datetime TFrame_Times[]; 
//----  
double Ind_Buffer[];
double Vel_Buffer [];
//----
int NTF,time1,weight;
//+------------------------------------------------------------------+
//| HTFm initialization function                                     | 
//+------------------------------------------------------------------+
int init() 
  { 
//---------  ---------------------------------------------- 

   //----        
   SetIndexStyle(0,DRAW_LINE);
   //----    
   SetIndexShift(0, Shift); 
   //----         
   IndicatorShortName(""+Label+"");
   SetIndexLabel   (0,""+Label+""+"_HTFm");
   //---- 2     
   IndicatorBuffers(2);
   SetIndexBuffer(0,Ind_Buffer);
   SetIndexBuffer(1,Vel_Buffer); 
   //----   ,      
   SetIndexEmptyValue(0,EmptyValue); 
   //----   
   weight=0;
   if (Smooth>1)for(int fff=1; fff<=Smooth; fff++)weight+=fff; 
   NTF=TFrame_Period/Period();  
   //----     
   IndicatorDigits(digits());
//-----------  ------------------------------------------------   
   if (TFrame_Period !=1 && TFrame_Period !=5 && TFrame_Period !=15 && TFrame_Period !=30 && TFrame_Period !=60 && TFrame_Period !=240 && TFrame_Period !=1440 && TFrame_Period != 10080)
      { 
       Alert("Chart ", Symbol(), " TimeFrame_period    : 1, 5, 15, 30, 60, 240, 1440, 7200, 10080.\n" +
                                 "     ");
       TFrame_Period=Period();
      }
   if (Period()>= TFrame_Period) 
      {
       TFrame_Period = Period();
       Alert(" TimeFrame_period     !      ");
      }
//-------------------------------------------------------------------- 
   //----  Time[]       
   ArrayCopySeries(TFrame_Times,MODE_TIME,Symbol(),TFrame_Period); 
   //----  
   return(0); 
  } 
//+------------------------------------------------------------------+
//| HTFm iteration function                                          | 
//+------------------------------------------------------------------+
int start() 
  { 
   //----+   
   int TFlimit,MaxBar,MaxBarS,bar,bar0,bar1,Dbar,MaxBarTF,TFbar,limit; 
   //----+     
   double Vel0,Vel1,sum,price,lsum;
   //----
   //----       
   MaxBar=Bars-1; 
   MaxBarTF=iBarShift(NULL,TFrame_Period,Time[MaxBar-1],false)-2;
   MaxBarS=iBarShift(NULL,0,TFrame_Times[MaxBarTF+1],false)-Smooth;
   
   //----
   //----+    
   //----    
   if (time1!=0)
     {
       TFlimit=iBarShift(NULL,TFrame_Period,time1,false); 
       if (TFlimit<=0)
        {
         TFlimit=MaxBarTF;
         Print("    ");
         Print("      ");
        }
     }
   else TFlimit=MaxBarTF;
   //----      
   time1=TFrame_Times[1]; 
   //----
   //----  
   if (TFlimit>=MaxBarTF)
     {
      TFlimit=MaxBarTF;
      limit=(TFlimit+1)*NTF+1;//limit=iBarShift(NULL,0,TFrame_Times[TFlimit+1],false)+1;
      for(int nnn=MaxBar;nnn>limit;nnn--)
        {
         Vel_Buffer [nnn]=EmptyValue;
         Ind_Buffer[nnn]=EmptyValue;
        }  
     }
   else limit=(TFlimit+1)*NTF+2;//limit=iBarShift(NULL,0,TFrame_Times[TFlimit+1],true)+1;
   //---- 
 
   if (limit>MaxBarS)
     {
      for(int xxx=limit;xxx>MaxBarS;xxx--)
         {
         Vel_Buffer[xxx]=EmptyValue;
         Ind_Buffer[xxx]=EmptyValue;
        }  
      limit=MaxBarS;
     }   
   //----+ +--------------------+
   
   //----+     
   for(TFbar=TFlimit;TFbar>=-1;TFbar--)  
      {  
        if (TFbar!=-1)bar=iBarShift(NULL,0,TFrame_Times[TFbar],false);else bar=0; 
        Vel_Buffer[bar]=INDICATOR(TFbar+1);
        if ((TFbar==0)&&(bar==0))break;
      }
   //----      
   if (TFlimit==MaxBarTF)TFlimit--;    
   for(TFbar=TFlimit;TFbar>=-1;TFbar--) 
      {
       //----     
       if (TFbar!=-1)bar0=iBarShift(NULL,0,TFrame_Times[TFbar],false);else bar0=0;
       bar1=iBarShift(NULL,0,TFrame_Times[TFbar+1],false);
       Dbar=bar1-bar0;
       //----     
       Vel1=Vel_Buffer[bar1];
       Vel0=Vel_Buffer[bar0];
       //----    
       if((Vel1==0)||( Vel0==0)||(Dbar==0))
         { 
           Print("      ");
           Print("      ");
           return(-1);
         }
       //----  
       for(int iii=Dbar-1;iii>0;iii--) Vel_Buffer[bar0+iii]=Vel1+(Vel0-Vel1)*(Dbar-iii)/Dbar;
       if ((TFbar==0)&&(bar0==0))break;
      } 
   //----  
   //---- LWMA    
   if (Smooth> 1)
    {
     sum=0;
     lsum=0;
     bar=limit+Smooth;
     for(int sss=1;sss<=Smooth;sss++,bar--)
      {
      price=Vel_Buffer[bar];
      sum+=price*sss;
      lsum+=price;
      }
     sss=Smooth;
     for(bar=limit;bar>=0;bar--)   
      {
       Ind_Buffer[bar]=sum/weight;
       if(bar==0) break;
       price=Vel_Buffer[bar];
       sum=sum-lsum+price*Smooth;
       lsum-=Vel_Buffer[bar+sss];
       lsum+=price;
      }
    }
   //----  
   if (Smooth==1)for(bar=limit;bar>=0;bar--)Ind_Buffer[bar]=Vel_Buffer [bar];  
    
   //----    
    return(0);
  }
//---- +---------------------------------------------------------------------------------+

