/*
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
//Version  October 1, 2006                                           |
Editing   Nikolay Kositsin  15.06.2006  farria@mail.redcom.ru        |
//----+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -+ 
TF_KlCannel.mqh -   ,        
     ʸ,  
          ,     
.        -   J2JMA KlChannel_htf.mq4
//+------------------------------------------------------------------+
//|                                                 HTF_KlCannel.mqh |
//|                            Copyright  2006, GS  Conversion only |
//|                    http://www.gustis.narod.ru;     gsb51@mail.ru |
//+------------------------------------------------------------------+
#property copyright "  Copyright  2006, GS  Conversion only"
#property link      " http://www.gustis.narod.ru;     gsb51@mail.ru"
//----     
#property indicator_chart_window
//----   
#property indicator_buffers  4
//----  
#property indicator_color1 BlueViolet
#property indicator_color2 Gray
#property indicator_color3 Gray
#property indicator_color4 Lime
#property indicator_color5 Red
#property indicator_color6 Gray
*/
//----    ------------------------------------------------------------------+
extern int Keltner_Period = 10;  //   ʸ
extern int  TFrame_Period = 240; //    
extern int         Smooth = 48;  //   .           
extern bool Trend_Visible = true;//   
extern int  Trend_Minimum = 5;   //   ,   
extern int         Shift  = 0;   // c     
//---- -----------------------------------------------------------------------------------------------+
datetime TFrame_Times[]; 
//----  
double Ind_Buffer0[];
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
double Ind_Buffer5[];
double Vel_Buffer [];
//----
double MINIMUM;
int NTF,time1,weight;
//+------------------------------------------------------------------+
//| HTF initialization function                                      | 
//+------------------------------------------------------------------+
int init() 
  { 
//---------  ---------------------------------------------- 

   //----         
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   //----      
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexStyle(4,DRAW_ARROW);
   SetIndexStyle(5,DRAW_ARROW);
   //----    
   SetIndexArrow(1,159);
   SetIndexArrow(2,159);
   SetIndexArrow(3,159);
   SetIndexArrow(4,159);
   SetIndexArrow(5,159);
   //----    
   SetIndexShift(0, Shift); 
   SetIndexShift(1, Shift);
   SetIndexShift(2, Shift);
   SetIndexShift(3, Shift);
   SetIndexShift(4, Shift);
   SetIndexShift(5, Shift);
   //----         
   IndicatorShortName(""+Label+"_HTF");
   SetIndexLabel   (0,""+Label+""+"_HTF");
   SetIndexLabel   (1,"Upper_"+Label+"_HTF");
   SetIndexLabel   (2,"Lower_"+Label+"_HTF");
   SetIndexLabel   (3,"Up_Trend");
   SetIndexLabel   (4,"Down_Trend");
   SetIndexLabel   (5,"Straight_Trend");
   //---- 7     
   IndicatorBuffers(7);
   SetIndexBuffer(0,Ind_Buffer0);
   SetIndexBuffer(1,Ind_Buffer1); 
   SetIndexBuffer(2,Ind_Buffer2); 
   SetIndexBuffer(3,Ind_Buffer3); 
   SetIndexBuffer(4,Ind_Buffer4); 
   SetIndexBuffer(5,Ind_Buffer5); 
   SetIndexBuffer(6,Vel_Buffer); 
   //----   ,      
   SetIndexEmptyValue(0,EmptyValue); 
   SetIndexEmptyValue(1,EmptyValue); 
   SetIndexEmptyValue(2,EmptyValue); 
   SetIndexEmptyValue(3,EmptyValue); 
   SetIndexEmptyValue(4,EmptyValue); 
   SetIndexEmptyValue(5,EmptyValue); 
   //----  
   MINIMUM=Trend_Minimum*Point;
   weight=0;
   if (Smooth>1)for(int fff=1; fff<=Smooth; fff++)weight+=fff; 
   NTF=TFrame_Period/Period();
   //----    (    )       
   IndicatorDigits(digits());
//-----------  ------------------------------------------------   
   if (TFrame_Period !=1 && TFrame_Period !=5 && TFrame_Period !=15 && TFrame_Period !=30 && TFrame_Period !=60 && TFrame_Period !=240 && TFrame_Period !=1440 && TFrame_Period != 10080)
      { 
       Alert("Chart ", Symbol(), " TimeFrame_period    : 1, 5, 15, 30, 60, 240, 1440, 7200, 10080.\n" +
                                 "     ");
       TFrame_Period=Period();
      }
   if (Period()>= TFrame_Period) 
      {
       TFrame_Period = Period();
       Alert(" TimeFrame_period     !      ");
      }
//-------------------------------------------------------------------- 
   //  Time[]       
   ArrayCopySeries(TFrame_Times,MODE_TIME,Symbol(),TFrame_Period); 
   return(0); 
  } 
//+------------------------------------------------------------------+
//| HTF iteration function                                           | 
//+------------------------------------------------------------------+
int start() 
  { 
   //----+   
   int TFlimit,MaxBar,MaxBarS,bar,bar0,bar1,Dbar,MaxBarTF,TFbar,limit; 
   //----+     
   double Vel0,Vel1,trend,Resalt,sum,price,lsum,Half_Width;
   //----
   //----       
   MaxBar=Bars-1; 
   MaxBarTF=iBarShift(NULL,TFrame_Period,Time[MaxBar-1],false)-2;
   MaxBarS=iBarShift(NULL,0,TFrame_Times[MaxBarTF+1],false)-Smooth;
   
   //----
   //----+    
   //----    
   if (time1!=0)
     {
       TFlimit=iBarShift(NULL,TFrame_Period,time1,false); 
       if (TFlimit<=0)
        {
         TFlimit=MaxBarTF;
         Print("    ");
         Print("      ");
        }
     }
   else TFlimit=MaxBarTF;
   //----      
   time1=TFrame_Times[1]; 
   //----
   //----  
   if (TFlimit>=MaxBarTF)
     {
      TFlimit=MaxBarTF;
      limit=(TFlimit+1)*NTF+1;//limit=iBarShift(NULL,0,TFrame_Times[TFlimit+1],false)+1;
      for(int nnn=MaxBar;nnn>limit;nnn--)
        {
         Vel_Buffer [nnn]=EmptyValue;
         Ind_Buffer0[nnn]=EmptyValue;
         Ind_Buffer1[nnn]=EmptyValue;
         Ind_Buffer2[nnn]=EmptyValue;
         Ind_Buffer3[nnn]=EmptyValue;
         Ind_Buffer4[nnn]=EmptyValue;
         Ind_Buffer5[nnn]=EmptyValue;
        }  
     }
   else limit=(TFlimit+1)*NTF+2;//limit=iBarShift(NULL,0,TFrame_Times[TFlimit+1],true)+1;
   //---- 
 
   if (limit>MaxBarS)
     {
      for(int xxx=limit;xxx>MaxBarS;xxx--)
         {
         Vel_Buffer [xxx]=EmptyValue;
         Ind_Buffer0[xxx]=EmptyValue;
         Ind_Buffer1[xxx]=EmptyValue;
         Ind_Buffer2[xxx]=EmptyValue;
         Ind_Buffer3[xxx]=EmptyValue;
         Ind_Buffer4[xxx]=EmptyValue;
         Ind_Buffer5[xxx]=EmptyValue;
        }  
      limit=MaxBarS;
     }   
   //----+ +--------------------+
   
   //----+     
   for(TFbar=TFlimit;TFbar>=-1;TFbar--)  
      {  
        if (TFbar!=-1)bar=iBarShift(NULL,0,TFrame_Times[TFbar],false);else bar=0; 
        Vel_Buffer[bar]=INDICATOR(TFbar+1);
        if ((TFbar==0)&&(bar==0))break;
      }
   //----      
   if (TFlimit==MaxBarTF)TFlimit--;    
   for(TFbar=TFlimit;TFbar>=-1;TFbar--) 
      {
       //----     
       if (TFbar!=-1)bar0=iBarShift(NULL,0,TFrame_Times[TFbar],false);else bar0=0;
       bar1=iBarShift(NULL,0,TFrame_Times[TFbar+1],false);
       Dbar=bar1-bar0;
       //----     
       Vel1=Vel_Buffer[bar1];
       Vel0=Vel_Buffer[bar0];
       //----    
       if((Vel1==0)||( Vel0==0)||(Dbar==0))
         { 
           Print("      ");
           Print("      ");
           return(-1);
         }
       //----  
       for(int iii=Dbar-1;iii>0;iii--) Vel_Buffer[bar0+iii]=Vel1+(Vel0-Vel1)*(Dbar-iii)/Dbar;
       if ((TFbar==0)&&(bar0==0))break;
      } 
   //----  
   //---- LWMA    
   if (Smooth> 1)
    {
     sum=0;
     lsum=0;
     bar=limit+Smooth;
     for(int sss=1;sss<=Smooth;sss++,bar--)
      {
      price=Vel_Buffer[bar];
      sum+=price*sss;
      lsum+=price;
      }
     sss=Smooth;
     for(bar=limit;bar>=0;bar--)   
      {
       Resalt=sum/weight;
       Ind_Buffer0[bar]=Resalt;
       Half_Width=GetKeltner(Symbol(),TFrame_Period,Keltner_Period,bar);
       //----+  
       Ind_Buffer1[bar]=Resalt+Half_Width;     
       Ind_Buffer2[bar]=Resalt-Half_Width;
       //----+
       if(bar==0) break;
       price=Vel_Buffer[bar];
       sum=sum-lsum+price*Smooth;
       lsum-=Vel_Buffer[bar+sss];
       lsum+=price;
      }
    }
   //----  
   if (Smooth<=1)for(bar=limit;bar>=0;bar--)
     {
       Resalt=Vel_Buffer [bar];
       Ind_Buffer0[bar]=Resalt; 
       Half_Width=GetKeltner(Symbol(),TFrame_Period,Keltner_Period,bar);
       //----+  
       Ind_Buffer1[bar]=Resalt+Half_Width;     
       Ind_Buffer2[bar]=Resalt-Half_Width; 
     }
      
   //----   
   if (Trend_Visible==true)
      {
        //----  
        for(int kkk=limit;kkk>=0;kkk--) 
          {
            Ind_Buffer3[kkk]=EmptyValue;
            Ind_Buffer4[kkk]=EmptyValue;
            Ind_Buffer5[kkk]=EmptyValue;
          }
        //----  
        if (TFlimit==MaxBarTF-1)TFlimit--; 
       for(TFbar=TFlimit+1;TFbar>=-1;TFbar--) 
          {
           if (TFbar!=-1)bar0=iBarShift(NULL,0,TFrame_Times[TFbar],false);else bar0=0;
           bar1=iBarShift(NULL,0,TFrame_Times[TFbar+1],false);
           //----  
           Resalt=Ind_Buffer0[bar0];
           trend=Resalt-Ind_Buffer0[bar1];
           if (MathAbs(trend)<MINIMUM)trend=0;
           if (trend>0)Ind_Buffer3[bar0]=Resalt;
           else if (trend<0)Ind_Buffer4[bar0]=Resalt;
           else Ind_Buffer5[bar0]=Resalt;
           if ((TFbar==0)&&(bar0==0))break;
           //---- 
          }
      } 
   //----    
    return(0);
  }
//+-------------------------------------+
//----+   GetKeltner
#include <GetKeltner.mqh>
//+-------------------------------------+

 

