//+------------------------------------------------------------------+
//|                                                SpreadMonitor.mq5 |
//|                          Copyright 2024, Wanateki Solutions Ltd. |
//|                                         https://www.wanateki.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, Wanateki Solutions Ltd."
#property link      "https://www.wanateki.com"
#property version   "1.00"
#property description "Monitors the spread and displays it as a colored histogram."
#property description "Changes the histogram color to indicate if the spread is "
#property description "rising or falling."
#property description "Works best on symbols with a floating spread."

//--- indicator window settings
#property indicator_separate_window

//--- indicator buffers and plots
#property indicator_buffers 2
#property indicator_plots   1

//--- indicator type and style settings
#property indicator_type1   DRAW_COLOR_HISTOGRAM
#property indicator_color1  clrDarkBlue, clrTomato
#property indicator_style1  0
#property indicator_width1  1
#property indicator_minimum 0.0

//--- indicator buffers
double spreadDataBuffer[];
double histoColorsBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- initialize the indicator
   GetInit();

   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- check if we have enough data start calculating
   if(rates_total < 2) //--- don't do any calculations, exit and reload function
      return(0);

//--- we have new data, starting the calculations
   int position = prev_calculated - 1;

//--- update the position variable
   if(position < 1)
     {
      spreadDataBuffer[0] = 0;
      position = 1;
     }
//--- calculate and get the tick volume
   GetSpreadData(position, rates_total, spread);

//--- Exit function and return new prev_calculated value
   return(rates_total);
  }

//+------------------------------------------------------------------+
//| Custom function for calculating the spread                       |
//+------------------------------------------------------------------+
void GetSpreadData(const int position, const int rates_total, const int& spreadData[])
  {
   spreadDataBuffer[0] = (double)spreadData[0];
   histoColorsBuffer[0] = 0.0;
//---
   for(int x = position; x < rates_total && !IsStopped(); x++)
     {
      double currentSpread = (double)spreadData[x];
      double previousSpread = (double)spreadData[x - 1];

      //--- calculate and save the spread
      spreadDataBuffer[x] = currentSpread;
      if(currentSpread > previousSpread)
        {
         histoColorsBuffer[x] = 1.0; //-- set the histogram to clrTomato
        }
      else
        {
         histoColorsBuffer[x] = 0.0; //-- set the histogram to clrDarkBlue
        }
     }
//---
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| User custom function for custom indicator initialization         |
//+------------------------------------------------------------------+
void GetInit()
  {
//--- set and register the indicator buffers mapping
   SetIndexBuffer(0, spreadDataBuffer, INDICATOR_DATA);
   SetIndexBuffer(1, histoColorsBuffer, INDICATOR_COLOR_INDEX);

//--- name for mt5 datawindow and the indicator subwindow label
   IndicatorSetString(INDICATOR_SHORTNAME,"Spread Histogram");

//--- set the indicators accuracy digits
   IndicatorSetInteger(INDICATOR_DIGITS, 0);
  }
//+------------------------------------------------------------------+
