//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
CCanvas canvas;
//+------------------------------------------------------------------+
#define _ToRadians(A) (A * (M_PI / 180.0))
//+------------------------------------------------------------------+
void MatrixA_x_MatrixB(const double &A[], const ushort Rows, const double &B[], double &R[])
{
    uint Lines = (uint)(A.Size() / Rows);

	for (uint cbl = 0; cbl < B.Size(); cbl += Rows)
		for (uint car = 0; car < Rows; car++)
		{
			R[car + cbl] = 0;
			for (uint cal = 0; cal < Lines; cal++)
				R[car + cbl] += (A[(cal * Rows) + car] * B[cal + cbl]);
		}
}
//+------------------------------------------------------------------+
void Plot(const int x, const int y, const double &A[])
{
	int dx[], dy[];

    for (uint c0 = 0, c1 = 0; c1 < A.Size(); c0++)
	{
		ArrayResize(dx, c0 + 1, A.Size());
		ArrayResize(dy, c0 + 1, A.Size());
        dx[c0] = x + (int)(A[c1++]);
        dy[c0] = y + (int)(A[c1++]);
	}

	canvas.FillPolygon(dx, dy, ColorToARGB(clrPurple, 255));
	canvas.FillCircle(x, y, 5, ColorToARGB(clrRed, 255));

    ArrayFree(dx);
    ArrayFree(dy);
}
//+------------------------------------------------------------------+
void Arrow(const int x, const int y, const ushort angle, const uchar size = 100)
{
	double  M_1[]={
                   	cos(_ToRadians(angle)), sin(_ToRadians(angle)),
                   	-sin(_ToRadians(angle)), cos(_ToRadians(angle))
                  },
		    M_2[]={
                 	0.0,  0.0,
                   	1.5, -.75,
                   	1.0,  0.0,
                   	1.5,  .75
                  },
		   M_3[M_2.Size()];
	
    MatrixA_x_MatrixB(M_1, 2, M_2, M_3);
	ZeroMemory(M_1);
	M_1[0] = M_1[3] = size;
	MatrixA_x_MatrixB(M_1, 2, M_3, M_2);
    Plot(x, y, M_2);
}
//+------------------------------------------------------------------+
int OnInit()
{	
	int px, py;
	
	px = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	py = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

	canvas.CreateBitmapLabel("BL", 0, 0, px, py, COLOR_FORMAT_ARGB_NORMALIZE);
	canvas.Erase(ColorToARGB(clrWhite, 255));
		
	Arrow(px / 2, py / 2, -60);

	canvas.Update(true);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	canvas.Destroy();
}
//+------------------------------------------------------------------+
