//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property indicator_chart_window
#property indicator_plots 0
//+------------------------------------------------------------------+
#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
CCanvas canvas;
//+------------------------------------------------------------------+
#define _ToRadians(A) (A * (M_PI / 180.0))
//+------------------------------------------------------------------+
void MatrixA_x_MatrixB(const double &A[][], const double &B[][], double &R[][], const int nDim)
{
	for (int c = 0, size = (int)(B.Size() / nDim); c < size; c++)
	{
		R[c][0] = (A[0][0] * B[c][0]) + (A[0][1] * B[c][1]);
		R[c][1] = (A[1][0] * B[c][0]) + (A[1][1] * B[c][1]);
	}
}
//+------------------------------------------------------------------+
void Arrow(const int x, const int y, const ushort angle, const uchar size = 100)
{
	double M_1[2][2] {
                   	  cos(_ToRadians(angle)), sin(_ToRadians(angle)),
                        -sin(_ToRadians(angle)), cos(_ToRadians(angle))
                    	},
		   M_2[][2]		{
                    		0.0,  0.0,
                       	1.5, -.75,
                       	1.0,  0.0,
                       	1.5,  .75
                    	},
		   M_3[M_2.Size() / 2][2];

	int dx[M_2.Size() / 2], dy[M_2.Size() / 2];
	
	MatrixA_x_MatrixB(M_1, M_2, M_3, 2);
	ZeroMemory(M_1);
	M_1[0][0] = M_1[1][1] = size;
	MatrixA_x_MatrixB(M_1, M_3, M_2, 2);

	for (int c = 0; c < (int)M_2.Size() / 2; c++)
	{
        dx[c] = x + (int) M_2[c][0];
        dy[c] = y + (int) M_2[c][1];
	}

	canvas.FillPolygon(dx, dy, ColorToARGB(clrPurple, 255));
	canvas.FillCircle(x, y, 5, ColorToARGB(clrRed, 255));
}
//+------------------------------------------------------------------+
int OnInit()
{	
	int px, py;
	
	px = (int)ChartGetInteger(0, CHART_WIDTH_IN_PIXELS, 0);
	py = (int)ChartGetInteger(0, CHART_HEIGHT_IN_PIXELS, 0);

	canvas.CreateBitmapLabel("BL", 0, 0, px, py, COLOR_FORMAT_ARGB_NORMALIZE);
	canvas.Erase(ColorToARGB(clrWhite, 255));
		
	Arrow(px / 2, py / 2, 160);

	canvas.Update(true);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
	return rates_total;
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	canvas.Destroy();
}
//+------------------------------------------------------------------+
